/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.deployers.WebModuleMBean;

public class WebModule
implements WebModuleMBean {
    private static Logger log = Logger.getLogger(WebModule.class);
    private VFSDeploymentUnit di;
    private AbstractWarDeployer container;
    private AbstractWarDeployment deployment;

    public WebModule(VFSDeploymentUnit di, AbstractWarDeployer container, AbstractWarDeployment deployment) {
        this.di = di;
        this.container = container;
        this.deployment = deployment;
    }

    public void create() {
    }

    public void start() throws Exception {
        this.startModule();
    }

    public void stop() throws Exception {
        this.stopModule();
    }

    public void destroy() {
        this.di = null;
        this.container = null;
        this.deployment = null;
    }

    public synchronized void startModule() throws Exception {
        JBossWebMetaData metaData = (JBossWebMetaData)this.di.getAttachment(JBossWebMetaData.class);
        WebApplication webApp = this.deployment.start(this.di, metaData);
        String warURL = this.di.getName();
        this.container.addDeployedApp(warURL, webApp);
    }

    public synchronized void stopModule() throws DeploymentException {
        String warURL = this.di.getName();
        try {
            WebApplication webApp = this.container.removeDeployedApp(warURL);
            if (this.deployment != null && webApp != null) {
                this.deployment.stop((DeploymentUnit)this.di, webApp);
            } else {
                log.debug((Object)("Failed to find deployer/deployment for war: " + warURL));
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Error during stop", (Throwable)e);
        }
    }
}

