/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.deployment.security;

import java.security.Policy;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;

//$Id$

/**
 *  A facade for the JACC Policy Configuration
 *  @author Anil.Saldhana@redhat.com
 *  @since  Apr 23, 2007 
 *  @version $Revision$
 */
public class PolicyConfigurationFacade implements PolicyConfigurationFacadeMBean
{ 
   private static Logger log = Logger.getLogger(PolicyConfigurationFacade.class);
   
   private String jaccContextId;
   private PolicyConfiguration policyConfiguration;
   private JaccPolicyMBean jaccPolicyMBean;
   private Object metaData;
 
   
   public PolicyConfigurationFacade(String id, Object md)
   {
      if(id == null)
         throw new IllegalArgumentException("Context ID is null");
      if(md == null)
         throw new IllegalArgumentException("Meta Data is null");
      this.jaccContextId = id; 
      this.metaData = md;
   }
   
   public void create()
   { 
      try
      { 
         PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
         policyConfiguration = pcf.getPolicyConfiguration(this.jaccContextId, true);

         JaccPolicyUtil.createPermissions(policyConfiguration, metaData);
      }
      catch (ClassNotFoundException e)
      {
         new RuntimeException(e);
      }
      catch (PolicyContextException e)
      {
         new RuntimeException(e);
      }
         
   }

   public void destroy()
   { 
      this.policyConfiguration = null;
   }

   public void start()
   {
      try
      {  
         if(jaccPolicyMBean != null)
         { 
            jaccPolicyMBean.link(policyConfiguration);
         }
         policyConfiguration.commit();
         // Allow the policy to incorporate the policy configs
         Policy.getPolicy().refresh();
      }  
      catch (PolicyContextException e)
      {
         new RuntimeException(e);
      }
   }

   public void stop()
   { 
      try
      {
         this.policyConfiguration.delete();
      }
      catch (PolicyContextException e)
      {
         new RuntimeException(e);
      } 
   } 
   
   public JaccPolicyMBean getJaccPolicyMBean()
   {
      return this.jaccPolicyMBean;
   }

   public void setJaccPolicyMBean(JaccPolicyMBean jaccPolicy)
   {
      this.jaccPolicyMBean = jaccPolicy;
   } 
}
