/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb.deployers;

import javax.management.ObjectName;

import org.jboss.mx.util.ObjectNameFactory;

/**
 * EJBDeployerMBean.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision: 1.1 $
 */
public interface EjbDeployerMBean
{
   /** The default ObjectName */
   ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss.ejb:service=EJBDeployer");
   
   /**
    * Whether ear deployments should be call by value
    */
   void setCallByValue(boolean callByValue);   
   boolean isCallByValue();

   /**
    * Enables/disables the application bean verification upon deployment.
   void setVerifyDeployments(boolean verify);
   boolean getVerifyDeployments();
    */
   
   /**
    * Enables/disables the verbose mode on the verifier.
   void setVerifierVerbose(boolean verbose);
   boolean getVerifierVerbose();   
    */

   /**
    * Enables/disables the strict mode on the verifier.
   void setStrictVerifier(boolean strictVerifier);
   boolean getStrictVerifier();
    */
   
   /**
    * Enables/disables the metrics interceptor for containers.
   void setMetricsEnabled(boolean enable);
   boolean isMetricsEnabled();
    */
   
   /**
    * The dynamic class loading simple web server name.
    */
   void setWebServiceName(String webServiceName);
   String getWebServiceName();
   
   /**
    * The TransactionManagerServiceName.
    */
   void setTransactionManagerServiceName(String transactionManagerServiceName);
   String getTransactionManagerServiceName();
}
