/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb.plugins.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityIdentity;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.plugins.SecurityContextAssociation;

//$Id$

/**
 *  Privileged Blocks
 *  @author Anil.Saldhana@redhat.com
 *  @since  Apr 30, 2007 
 *  @version $Revision$
 */
class SecurityActions
{
   public static SecurityContext createAndSetSecurityContext(final String domain,
         final String fqnClassName) throws PrivilegedActionException
   {
      return (SecurityContext) AccessController.doPrivileged(new PrivilegedExceptionAction()
      { 
         public Object run() throws Exception
         {
            SecurityContext sc =  SecurityContextFactory.createSecurityContext(domain, fqnClassName); 
            setSecurityContext(sc);
            return sc;
         }}
      );
   }

   public static SecurityContext getSecurityContext()
   {
      return (SecurityContext) AccessController.doPrivileged(new PrivilegedAction()
      { 
         public Object run()
         {
            return SecurityContextAssociation.getSecurityContext(); 
         }}
      );
   }
   
   static void pushCallerRunAsIdentity(final RunAs ra)
   {
      AccessController.doPrivileged(new PrivilegedAction(){ 
         public Object run()
         {
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if(sc == null)
               throw new IllegalStateException("Security Context is null");
            sc.setIncomingRunAs(ra);
            return null;
         } 
      }); 
   }
   

   public static void popCallerRunAsIdentity()
   {
      AccessController.doPrivileged(new PrivilegedAction(){ 
         public Object run()
         {
            SecurityContext sc = SecurityContextAssociation.getSecurityContext();
            if(sc == null)
               throw new IllegalStateException("Security Context is null");
            sc.setIncomingRunAs(null);
            return null;
         } 
      }); 
   }

   public static void setSecurityContext(final SecurityContext sc)
   {
      AccessController.doPrivileged(new PrivilegedAction()
      { 
         public Object run()
         {
            SecurityContextAssociation.setSecurityContext(sc);
            return null;
         }}
      );
   }

   public static void setSecurityIdentity(final SecurityContext sc,
         final SecurityIdentity si)
   {
      AccessController.doPrivileged(new PrivilegedAction()
      { 
         public Object run()
         {
            sc.getUtil().setSecurityIdentity(si);
            return null;
         }}
      );
   }
}
