/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.security.Policy;
import java.util.ArrayList;
import java.util.List;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployment.security.JaccPolicyMBean;
import org.jboss.deployment.security.PolicyConfigurationFacadeMBean;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.support.IdMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaccPolicy<T extends IdMetaData>
implements JaccPolicyMBean {
    private static Logger log = Logger.getLogger(JaccPolicy.class);
    private boolean trace = log.isTraceEnabled();
    private PolicyConfiguration parentPC = null;
    private String contextID = null;
    private T metaData;
    private Boolean standaloneDeployment = Boolean.FALSE;
    private List<PolicyConfigurationFacadeMBean> children = new ArrayList<PolicyConfigurationFacadeMBean>();

    public JaccPolicy(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Jacc Context Id passed is null");
        }
        this.contextID = id;
    }

    public JaccPolicy(String id, T metaData, Boolean standaloneDeployment) {
        this(id);
        this.metaData = metaData;
        this.standaloneDeployment = standaloneDeployment;
    }

    @Override
    public void create() {
        try {
            this.createPolicyConfiguration();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.standaloneDeployment == Boolean.TRUE) {
            try {
                if (this.metaData != null) {
                    this.createPermissions(this.metaData, this.parentPC);
                } else {
                    log.warn((Object)("Cannot create permissions with 'null' metaData for id=" + this.contextID));
                }
            }
            catch (PolicyContextException e) {
                throw new RuntimeException("Cannot create permissions:", e);
            }
        }
        if (this.trace) {
            log.trace((Object)("create():" + this.contextID));
        }
    }

    @Override
    public void destroy() {
        if (this.trace) {
            log.trace((Object)("destroy:" + this.contextID));
        }
        this.parentPC = null;
    }

    @Override
    public void start() {
        try {
            for (PolicyConfigurationFacadeMBean pcfm : this.children) {
                String jaccContextIdChild = pcfm.getJaccContextID();
                PolicyConfigurationFactory policyConfigurationFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
                PolicyConfiguration pcChild = policyConfigurationFactory.getPolicyConfiguration(jaccContextIdChild, false);
                if (pcChild == null) continue;
                this.parentPC.linkConfiguration(pcChild);
                pcChild.commit();
            }
            this.parentPC.commit();
            Policy.getPolicy().refresh();
        }
        catch (Exception e) {
            log.error((Object)"Cannot commit Parent Policy Configuration:", (Throwable)e);
        }
        if (this.trace) {
            log.trace((Object)("start():" + this.contextID));
        }
    }

    @Override
    public void stop() {
        try {
            this.parentPC.delete();
        }
        catch (PolicyContextException e) {
            throw new RuntimeException(e);
        }
        if (this.trace) {
            log.trace((Object)("stop():" + this.contextID));
        }
    }

    @Override
    public void setPolicyConfigurationFacadeMBean(PolicyConfigurationFacadeMBean mbeanName) {
        this.children.add(mbeanName);
    }

    private void createPolicyConfiguration() throws PolicyContextException, ClassNotFoundException {
        if (this.parentPC == null) {
            PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            this.parentPC = pcf.getPolicyConfiguration(this.contextID, true);
        }
    }

    protected void createPermissions(T metaData, PolicyConfiguration policyConfiguration) throws PolicyContextException {
        throw new RuntimeException("Need to override");
    }
}

