/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.EntitySynchronizationInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.ejb.plugins.lock.JDBCOptimisticLock;
import org.jboss.ejb.plugins.lock.MethodOnlyEJBLock;
import org.jboss.ejb.plugins.lock.NoLock;

public class EntityMultiInstanceSynchronizationInterceptor
extends EntitySynchronizationInterceptor {
    public void create() throws Exception {
        super.create();
    }

    public void start() {
        if (!(this.container.getLockManager().lockClass.equals(NoLock.class) || this.container.getLockManager().lockClass.equals(JDBCOptimisticLock.class) || this.container.getLockManager().lockClass.equals(MethodOnlyEJBLock.class))) {
            throw new IllegalStateException("the <locking-policy> must be org.jboss.ejb.plugins.lock.NoLock, JDBCOptimisticLock, or MethodOnlyEJBLock for Instance Per Transaction:" + this.container.getLockManager().lockClass.getName());
        }
    }

    protected Synchronization createSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
        return new MultiInstanceSynchronization(tx, ctx);
    }

    protected class MultiInstanceSynchronization
    implements Synchronization {
        protected Transaction tx;
        protected EntityEnterpriseContext ctx;

        MultiInstanceSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
            this.tx = tx;
            this.ctx = ctx;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            boolean trace = EntityMultiInstanceSynchronizationInterceptor.this.log.isTraceEnabled();
            ClassLoader oldCl = SecurityActions.getContextClassLoader();
            SecurityActions.setContextClassLoader(EntityMultiInstanceSynchronizationInterceptor.this.container.getClassLoader());
            EntityMultiInstanceSynchronizationInterceptor.this.container.pushENC();
            this.ctx.hasTxSynchronization(false);
            this.ctx.setTransaction(null);
            try {
                try {
                    if (status != 4) {
                        switch (EntityMultiInstanceSynchronizationInterceptor.this.commitOption) {
                            case 0: {
                                throw new IllegalStateException("Commit option A not allowed with this Interceptor");
                            }
                            case 1: {
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                throw new IllegalStateException("Commit option D not allowed with this Interceptor");
                            }
                        }
                    }
                    try {
                        if (this.ctx.getId() != null) {
                            EntityMultiInstanceSynchronizationInterceptor.this.container.getPersistenceManager().passivateEntity(this.ctx);
                        }
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    EntityMultiInstanceSynchronizationInterceptor.this.container.getInstancePool().free(this.ctx);
                }
                finally {
                    if (trace) {
                        EntityMultiInstanceSynchronizationInterceptor.this.log.trace((Object)("afterCompletion, clear tx for ctx=" + this.ctx + ", tx=" + this.tx));
                    }
                }
            }
            finally {
                EntityMultiInstanceSynchronizationInterceptor.this.container.popENC();
                SecurityActions.setContextClassLoader(oldCl);
            }
        }
    }
}

