/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityIdentity;

class SecurityActions {
    SecurityActions() {
    }

    public static SecurityContext createAndSetSecurityContext(final String domain, final String fqnClassName) throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                SecurityContext sc = SecurityContextFactory.createSecurityContext((String)domain, (String)fqnClassName);
                SecurityActions.setSecurityContext(sc);
                return sc;
            }
        });
    }

    public static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static void pushCallerRunAsIdentity(final RunAs ra) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(ra);
                return null;
            }
        });
    }

    public static void popCallerRunAsIdentity() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityContextAssociation.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("Security Context is null");
                }
                sc.setIncomingRunAs(null);
                return null;
            }
        });
    }

    public static void setSecurityContext(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    public static void setSecurityIdentity(final SecurityContext sc, final SecurityIdentity si) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                sc.getUtil().setSecurityIdentity(si);
                return null;
            }
        });
    }
}

