/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import java.util.HashMap;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.ejb.IEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.BasicJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.JBossSessionPolicyDecorator;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.JbossEntityPolicyDecorator;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;

public class EjbMetadataJndiPolicyDecoratorDeployer
extends AbstractDeployer {
    private static final Logger log = Logger.getLogger(EjbMetadataJndiPolicyDecoratorDeployer.class);
    public static final String EJB_DECORATED_FLAG = EjbMetadataJndiPolicyDecoratorDeployer.class.getSimpleName();

    public EjbMetadataJndiPolicyDecoratorDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
        this.addOutput(EJB_DECORATED_FLAG);
    }

    public void deploy(DeploymentUnit du) throws DeploymentException {
        JBossMetaData md = (JBossMetaData)du.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME, JBossMetaData.class);
        if (md == null) {
            return;
        }
        if (!md.isEJB3x()) {
            return;
        }
        HashMap<JBossEnterpriseBeanMetaData, JBossSessionPolicyDecorator> beansToReplace = new HashMap<JBossEnterpriseBeanMetaData, JBossSessionPolicyDecorator>();
        String mdJndiPolicyName = md.getJndiBindingPolicy();
        if (mdJndiPolicyName != null && mdJndiPolicyName.trim().length() == 0) {
            mdJndiPolicyName = null;
        }
        if (mdJndiPolicyName != null) {
            log.debug((Object)(JBossMetaData.class.getSimpleName() + " " + md + " has defined " + DefaultJndiBindingPolicy.class.getSimpleName() + " \"" + mdJndiPolicyName + "\""));
        }
        JBossEnterpriseBeansMetaData beans = md.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            JBossSessionPolicyDecorator decoratedBean = null;
            DefaultJndiBindingPolicy policy = this.getJndiBindingPolicy(bean, mdJndiPolicyName, du.getClassLoader());
            if (bean.isSession() || bean.isService()) {
                assert (bean instanceof JBossSessionBeanMetaData) : JBossEnterpriseBeanMetaData.class.getSimpleName() + " representing as Session Bean is not castable to " + JBossSessionBeanMetaData.class.getName();
                JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)bean;
                decoratedBean = new JBossSessionPolicyDecorator(sessionBean, policy);
            }
            if (bean.isEntity()) {
                assert (bean instanceof JBossEntityBeanMetaData) : JBossEnterpriseBeanMetaData.class.getSimpleName() + " representing as Entity Bean is not castable to " + JBossEntityBeanMetaData.class.getName();
                JBossEntityBeanMetaData entityBean = (JBossEntityBeanMetaData)bean;
                decoratedBean = new JbossEntityPolicyDecorator(entityBean, policy);
            }
            if (decoratedBean == null) continue;
            beansToReplace.put(bean, decoratedBean);
        }
        for (JBossEnterpriseBeanMetaData beanToReplace : beansToReplace.keySet()) {
            JBossEnterpriseBeanMetaData beanToReplaceWith = (JBossEnterpriseBeanMetaData)beansToReplace.get(beanToReplace);
            boolean removed = beans.remove((Object)beanToReplace);
            assert (removed) : "Remove operation of " + beanToReplace + " from " + beans + " resulted in no action";
            beans.add((IEnterpriseBeanMetaData)beanToReplaceWith);
            log.debug((Object)("Replaced " + beanToReplace.getEjbName() + " with decorated instance fit with " + DefaultJndiBindingPolicy.class.getSimpleName()));
        }
        du.addAttachment(EJB_DECORATED_FLAG, (Object)true, Boolean.class);
    }

    protected DefaultJndiBindingPolicy getJndiBindingPolicy(JBossEnterpriseBeanMetaData md, String deployableUnitDefaultJndiPolicyClassName, ClassLoader cl) {
        String jndiPolicyName;
        BasicJndiBindingPolicy policy = null;
        String beanJndiPolicyName = md.getJndiBindingPolicy();
        if (beanJndiPolicyName != null && beanJndiPolicyName.trim().length() == 0) {
            beanJndiPolicyName = null;
        }
        if (beanJndiPolicyName != null) {
            log.debug((Object)("Session EJB " + md.getEjbName() + " has defined " + DefaultJndiBindingPolicy.class.getSimpleName() + " of \"" + beanJndiPolicyName));
        }
        String string = jndiPolicyName = deployableUnitDefaultJndiPolicyClassName != null ? deployableUnitDefaultJndiPolicyClassName : beanJndiPolicyName;
        if (jndiPolicyName != null) {
            Class<?> policyClass = null;
            try {
                policyClass = Class.forName(jndiPolicyName, true, cl);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Could not find defined JNDI Binding Policy Class: " + jndiPolicyName, cnfe);
            }
            try {
                policy = (DefaultJndiBindingPolicy)policyClass.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("Error in instanciating defined JNDI Binding Policy Class: " + jndiPolicyName, t);
            }
            log.debug((Object)("Using " + DefaultJndiBindingPolicy.class.getSimpleName() + " \"" + policy.getClass().getName() + "\" for Session Bean " + md.getEjbName()));
        }
        if (policy == null) {
            policy = new BasicJndiBindingPolicy();
            log.warn((Object)("Defaulting to " + DefaultJndiBindingPolicy.class.getSimpleName() + " of \"" + BasicJndiBindingPolicy.class.getName() + "\" for Session Bean " + md.getEjbName()));
        }
        return policy;
    }
}

