/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.bridge;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.LocalProxyFactory;
import org.jboss.ejb.plugins.cmp.bridge.EntityBridge;
import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
import org.jboss.ejb.plugins.cmp.ejbql.Catalog;
import org.jboss.ejb.plugins.cmp.jdbc.CascadeDeleteStrategy;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCParameterSetter;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
import org.jboss.ejb.plugins.cmp.jdbc.RelationData;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRMessage;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMP2xFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.RelationSet;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.SecurityActions;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.ejb.plugins.lock.Entrancy;
import org.jboss.invocation.InvocationType;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.tm.TransactionLocal;

public final class JDBCCMRFieldBridge
extends JDBCAbstractCMRFieldBridge {
    private final JDBCEntityBridge entity;
    private final JDBCStoreManager manager;
    private final JDBCRelationshipRoleMetaData metadata;
    private DataSource dataSource;
    private String qualifiedTableName;
    private String tableName;
    private JDBCCMP2xFieldBridge[] tableKeyFields;
    private JDBCType jdbcType;
    private WeakReference relatedContainerRef;
    private JDBCStoreManager relatedManager;
    private JDBCEntityBridge relatedEntity;
    private JDBCCMRFieldBridge relatedCMRField;
    private final Logger log;
    private JDBCCMP2xFieldBridge[] foreignKeyFields;
    private boolean allFKFieldsMappedToPKFields;
    private final Map relatedPKFieldsByMyPKFields = new HashMap();
    private final Map relatedPKFieldsByMyFKFields = new HashMap();
    private boolean hasFKFieldsMappedToCMPFields;
    private final TransactionLocal relatedPKValuesWaitingForMyPK = new TransactionLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private Method relatedFindByPrimaryKey;
    private final int jdbcContextIndex;
    private CascadeDeleteStrategy cascadeDeleteStrategy;
    private RelationDataManager relationManager;
    private static final RelationDataManager EMPTY_RELATION_MANAGER = new RelationDataManager(){

        public void addRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
        }

        public void removeRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
        }

        public boolean isDirty() {
            return false;
        }

        public RelationData getRelationData() {
            throw new UnsupportedOperationException();
        }
    };

    public JDBCCMRFieldBridge(JDBCEntityBridge entity, JDBCStoreManager manager, JDBCRelationshipRoleMetaData metadata) throws DeploymentException {
        this.entity = entity;
        this.manager = manager;
        this.metadata = metadata;
        this.jdbcContextIndex = ((JDBCEntityBridge)manager.getEntityBridge()).getNextJDBCContextIndex();
        String categoryName = this.getClass().getName() + "." + manager.getMetaData().getName() + ".";
        categoryName = metadata.getCMRFieldName() != null ? categoryName + metadata.getCMRFieldName() : categoryName + metadata.getRelatedRole().getEntity().getName() + "-" + metadata.getRelatedRole().getCMRFieldName();
        this.log = Logger.getLogger((String)categoryName);
    }

    public RelationDataManager getRelationDataManager() {
        return this.relationManager;
    }

    public void resolveRelationship() throws DeploymentException {
        String relatedEntityName = this.metadata.getRelatedRole().getEntity().getName();
        Catalog catalog = (Catalog)this.manager.getApplicationData("CATALOG");
        this.relatedEntity = (JDBCEntityBridge)catalog.getEntityByEJBName(relatedEntityName);
        if (this.relatedEntity == null) {
            throw new DeploymentException("Related entity not found: entity=" + this.entity.getEntityName() + ", " + "cmrField=" + this.getFieldName() + ", " + "relatedEntity=" + relatedEntityName);
        }
        JDBCCMRFieldBridge[] cmrFields = (JDBCCMRFieldBridge[])this.relatedEntity.getCMRFields();
        for (int i = 0; i < cmrFields.length; ++i) {
            JDBCCMRFieldBridge cmrField = cmrFields[i];
            if (this.metadata.getRelatedRole() != cmrField.getMetaData()) continue;
            this.relatedCMRField = cmrField;
            break;
        }
        if (this.relatedCMRField == null) {
            String message = "Related CMR field not found in " + this.relatedEntity.getEntityName() + " for relationship from";
            message = message + this.entity.getEntityName() + ".";
            message = this.getFieldName() != null ? message + this.getFieldName() : message + "<no-field>";
            message = message + " to ";
            message = message + relatedEntityName + ".";
            message = this.metadata.getRelatedRole().getCMRFieldName() != null ? message + this.metadata.getRelatedRole().getCMRFieldName() : message + "<no-field>";
            throw new DeploymentException(message);
        }
        this.relatedManager = (JDBCStoreManager)this.relatedEntity.getManager();
        EntityContainer relatedContainer = this.relatedManager.getContainer();
        this.relatedContainerRef = new WeakReference<EntityContainer>(relatedContainer);
        Class homeClass = relatedContainer.getLocalHomeClass() != null ? relatedContainer.getLocalHomeClass() : relatedContainer.getHomeClass();
        try {
            this.relatedFindByPrimaryKey = homeClass.getMethod("findByPrimaryKey", this.relatedEntity.getPrimaryKeyClass());
        }
        catch (Exception e) {
            throw new DeploymentException("findByPrimaryKey(" + this.relatedEntity.getPrimaryKeyClass().getName() + " pk) was not found in " + homeClass.getName());
        }
        if (this.metadata.getRelationMetaData().isTableMappingStyle()) {
            Collection tableKeys = this.metadata.getKeyFields();
            ArrayList keyFieldsList = new ArrayList(tableKeys.size());
            HashMap<FieldBridge, JDBCCMP2xFieldBridge> pkFieldsToFKFields = new HashMap<FieldBridge, JDBCCMP2xFieldBridge>(tableKeys.size());
            for (JDBCCMPFieldMetaData cmpFieldMetaData : tableKeys) {
                FieldBridge pkField = this.entity.getFieldByName(cmpFieldMetaData.getFieldName());
                if (pkField == null) {
                    throw new DeploymentException("Primary key not found for key-field " + cmpFieldMetaData.getFieldName());
                }
                pkFieldsToFKFields.put(pkField, new JDBCCMP2xFieldBridge(this.manager, cmpFieldMetaData));
            }
            JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
            for (int i = 0; i < pkFields.length; ++i) {
                Object fkField = pkFieldsToFKFields.get(pkFields[i]);
                if (fkField == null) {
                    throw new DeploymentException("Primary key " + pkFields[i].getFieldName() + " is not mapped.");
                }
                keyFieldsList.add(fkField);
            }
            this.tableKeyFields = keyFieldsList.toArray(new JDBCCMP2xFieldBridge[keyFieldsList.size()]);
            this.dataSource = this.metadata.getRelationMetaData().getDataSource();
        } else {
            this.initializeForeignKeyFields();
            this.dataSource = this.hasForeignKey() ? this.entity.getDataSource() : this.relatedEntity.getDataSource();
        }
        this.qualifiedTableName = SQLUtil.fixTableName(this.metadata.getRelationMetaData().getDefaultTableName(), this.dataSource);
        this.tableName = SQLUtil.getTableNameWithoutSchema(this.qualifiedTableName);
        this.relationManager = this.relatedCMRField.initRelationManager(this);
    }

    public void start() throws DeploymentException {
        this.cascadeDeleteStrategy = CascadeDeleteStrategy.getCascadeDeleteStrategy(this);
    }

    public boolean removeFromRelations(EntityEnterpriseContext ctx, Object[] oldRelationsRef) {
        this.load(ctx);
        FieldState fieldState = this.getFieldState(ctx);
        List value = fieldState.getValue();
        boolean removed = false;
        if (!value.isEmpty()) {
            if (this.hasFKFieldsMappedToCMPFields) {
                if (this.isForeignKeyValid(value.get(0))) {
                    this.cascadeDeleteStrategy.removedIds(ctx, oldRelationsRef, value);
                    removed = true;
                }
            } else {
                this.cascadeDeleteStrategy.removedIds(ctx, oldRelationsRef, value);
                removed = true;
            }
        }
        return removed;
    }

    public void cascadeDelete(EntityEnterpriseContext ctx, List oldValues) throws RemoveException, RemoteException {
        this.cascadeDeleteStrategy.cascadeDelete(ctx, oldValues);
    }

    public boolean isBatchCascadeDelete() {
        return this.cascadeDeleteStrategy instanceof CascadeDeleteStrategy.BatchCascadeDeleteStrategy;
    }

    public JDBCStoreManager getJDBCStoreManager() {
        return this.manager;
    }

    public JDBCAbstractEntityBridge getEntity() {
        return this.entity;
    }

    public JDBCRelationshipRoleMetaData getMetaData() {
        return this.metadata;
    }

    public JDBCRelationMetaData getRelationMetaData() {
        return this.metadata.getRelationMetaData();
    }

    public String getFieldName() {
        return this.metadata.getCMRFieldName();
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JDBCReadAheadMetaData getReadAhead() {
        return this.metadata.getReadAhead();
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public boolean isPrimaryKeyMember() {
        return false;
    }

    public boolean hasForeignKey() {
        return this.foreignKeyFields != null;
    }

    public boolean allFkFieldsMappedToPkFields() {
        return this.allFKFieldsMappedToPKFields;
    }

    public boolean isCollectionValued() {
        return this.metadata.getRelatedRole().isMultiplicityMany();
    }

    public boolean isSingleValued() {
        return this.metadata.getRelatedRole().isMultiplicityOne();
    }

    public JDBCFieldBridge[] getTableKeyFields() {
        return this.tableKeyFields;
    }

    public JDBCFieldBridge[] getForeignKeyFields() {
        return this.foreignKeyFields;
    }

    public JDBCAbstractCMRFieldBridge getRelatedCMRField() {
        return this.relatedCMRField;
    }

    public JDBCStoreManager getRelatedManager() {
        return this.relatedManager;
    }

    public EntityBridge getRelatedEntity() {
        return this.relatedEntity;
    }

    public JDBCEntityBridge getRelatedJDBCEntity() {
        return this.relatedEntity;
    }

    private final EntityContainer getRelatedContainer() {
        return (EntityContainer)this.relatedContainerRef.get();
    }

    public final Class getRelatedLocalInterface() {
        return this.getRelatedContainer().getLocalClass();
    }

    public final LocalProxyFactory getRelatedInvoker() {
        return this.getRelatedContainer().getLocalProxyFactory();
    }

    public boolean isLoaded(EntityEnterpriseContext ctx) {
        return this.getFieldState(ctx).isLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelatedPKsWaitedForMe(EntityEnterpriseContext ctx) {
        Map relatedPKsMap;
        Map map = relatedPKsMap = this.getRelatedPKsWaitingForMyPK();
        synchronized (map) {
            List relatedPKsWaitingForMe = (List)relatedPKsMap.get(ctx.getId());
            if (relatedPKsWaitingForMe != null) {
                Iterator waitingPKsIter = relatedPKsWaitingForMe.iterator();
                while (waitingPKsIter.hasNext()) {
                    Object waitingPK = waitingPKsIter.next();
                    waitingPKsIter.remove();
                    if (!this.isForeignKeyValid(waitingPK)) continue;
                    this.createRelationLinks(ctx, waitingPK);
                }
            }
        }
    }

    public boolean isReadOnly() {
        return this.getRelationMetaData().isReadOnly();
    }

    public boolean isReadTimedOut(EntityEnterpriseContext ctx) {
        if (!this.isReadOnly()) {
            return true;
        }
        if (this.getRelationMetaData().getReadTimeOut() == -1) {
            return false;
        }
        long readInterval = System.currentTimeMillis() - this.getFieldState(ctx).getLastRead();
        return readInterval > (long)this.getRelationMetaData().getReadTimeOut();
    }

    public Object getValue(EntityEnterpriseContext ctx) {
        return this.getInstanceValue(ctx);
    }

    public void setValue(EntityEnterpriseContext ctx, Object value) {
        if (this.isReadOnly()) {
            throw new EJBException("Field is read-only: fieldName=" + this.getFieldName());
        }
        if (!JDBCEntityBridge.isEjbCreateDone(ctx)) {
            throw new IllegalStateException("A CMR field cannot be set in ejbCreate; this should be done in the ejbPostCreate method instead [EJB 2.0 Spec. 10.5.2].");
        }
        if (this.isCollectionValued() && value == null) {
            throw new IllegalArgumentException("null cannot be assigned to a collection-valued cmr-field [EJB 2.0 Spec. 10.3.8].");
        }
        this.setInstanceValue(ctx, value);
    }

    public Object getInstanceValue(EntityEnterpriseContext myCtx) {
        this.load(myCtx);
        FieldState fieldState = this.getFieldState(myCtx);
        if (this.isCollectionValued()) {
            return fieldState.getRelationSet();
        }
        try {
            Object relatedId;
            List value = fieldState.getValue();
            if (!value.isEmpty()) {
                Object fk = value.get(0);
                return this.getRelatedEntityByFK(fk);
            }
            if (this.foreignKeyFields != null && (relatedId = this.getRelatedIdFromContext(myCtx)) != null) {
                return this.getRelatedEntityByFK(relatedId);
            }
            return null;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public EJBLocalObject getRelatedEntityByFK(Object fk) {
        EJBLocalObject relatedLocalObject = null;
        EntityContainer relatedContainer = this.getRelatedContainer();
        if (this.hasFKFieldsMappedToCMPFields && this.relatedManager.getReadAheadCache().getPreloadDataMap(fk, false) == null) {
            EJBLocalHome relatedHome = relatedContainer.getLocalProxyFactory().getEJBLocalHome();
            try {
                relatedLocalObject = (EJBLocalObject)this.relatedFindByPrimaryKey.invoke((Object)relatedHome, fk);
            }
            catch (Exception ignore) {}
        } else {
            relatedLocalObject = relatedContainer.getLocalProxyFactory().getEntityEJBLocalObject(fk);
        }
        return relatedLocalObject;
    }

    public boolean isForeignKeyValid(Object fk) {
        boolean valid;
        if (this.relatedManager.getReadAheadCache().getPreloadDataMap(fk, false) != null) {
            valid = true;
        } else {
            EJBLocalHome relatedHome = this.getRelatedContainer().getLocalProxyFactory().getEJBLocalHome();
            try {
                this.relatedFindByPrimaryKey.invoke((Object)relatedHome, fk);
                valid = true;
            }
            catch (Exception ignore) {
                valid = false;
            }
        }
        return valid;
    }

    public void setInstanceValue(EntityEnterpriseContext myCtx, Object newValue) {
        ArrayList<Object> newPks;
        if (newValue instanceof Collection) {
            Collection col = (Collection)newValue;
            if (!col.isEmpty()) {
                newPks = new ArrayList<Object>(col.size());
                for (Object localObject : col) {
                    if (localObject == null) continue;
                    Object relatedId = this.getRelatedPrimaryKey(localObject);
                    if (this.relatedPKFieldsByMyPKFields.size() > 0) {
                        this.checkSetForeignKey(myCtx, relatedId);
                    }
                    newPks.add(relatedId);
                }
            } else {
                newPks = Collections.EMPTY_LIST;
            }
        } else {
            newPks = newValue != null ? Collections.singletonList(this.getRelatedPrimaryKey(newValue)) : Collections.EMPTY_LIST;
        }
        this.load(myCtx);
        FieldState fieldState = this.getFieldState(myCtx);
        if (newValue == fieldState.getRelationSet()) {
            return;
        }
        try {
            List value = fieldState.getValue();
            if (!value.isEmpty()) {
                Object[] curPks = value.toArray(new Object[value.size()]);
                for (int i = 0; i < curPks.length; ++i) {
                    this.destroyRelationLinks(myCtx, curPks[i]);
                }
            }
            for (int i = 0; i < newPks.size(); ++i) {
                this.createRelationLinks(myCtx, newPks.get(i));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    private void checkSetForeignKey(EntityEnterpriseContext myCtx, Object newValue) throws IllegalStateException {
        JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            Object currentValue;
            Object comingValue;
            JDBCCMP2xFieldBridge pkField = (JDBCCMP2xFieldBridge)pkFields[i];
            JDBCCMP2xFieldBridge relatedPkField = (JDBCCMP2xFieldBridge)this.relatedPKFieldsByMyPKFields.get(pkField);
            if (relatedPkField == null || (comingValue = relatedPkField.getPrimaryKeyValue(newValue)).equals(currentValue = pkField.getInstanceValue(myCtx))) continue;
            throw new IllegalStateException("Can't create relationship: CMR field " + this.entity.getEntityName() + "." + this.getFieldName() + " has foreign key fields mapped to the primary key columns." + " Primary key may only be set once in ejbCreate [EJB 2.0 Spec. 10.3.5]." + " primary key value is " + currentValue + " overriding value is " + comingValue);
        }
    }

    public void createRelationLinks(EntityEnterpriseContext myCtx, Object relatedId) {
        this.createRelationLinks(myCtx, relatedId, true);
    }

    public void createRelationLinks(EntityEnterpriseContext myCtx, Object relatedId, boolean updateForeignKey) {
        Object oldRelatedId;
        if (this.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.getFieldName());
        }
        Transaction tx = this.getTransaction();
        if (this.metadata.isMultiplicityOne() && (oldRelatedId = this.relatedCMRField.invokeGetRelatedId(tx, relatedId)) != null) {
            this.invokeRemoveRelation(tx, oldRelatedId, relatedId);
            this.relatedCMRField.invokeRemoveRelation(tx, relatedId, oldRelatedId);
        }
        this.addRelation(myCtx, relatedId, updateForeignKey);
        this.relatedCMRField.invokeAddRelation(tx, relatedId, myCtx.getId());
    }

    public void destroyRelationLinks(EntityEnterpriseContext myCtx, Object relatedId) {
        this.destroyRelationLinks(myCtx, relatedId, true);
    }

    public void destroyRelationLinks(EntityEnterpriseContext myCtx, Object relatedId, boolean updateValueCollection) {
        this.destroyRelationLinks(myCtx, relatedId, updateValueCollection, true);
    }

    public void destroyRelationLinks(EntityEnterpriseContext myCtx, Object relatedId, boolean updateValueCollection, boolean updateForeignKey) {
        if (this.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.getFieldName());
        }
        this.removeRelation(myCtx, relatedId, updateValueCollection, updateForeignKey);
        this.relatedCMRField.invokeRemoveRelation(this.getTransaction(), relatedId, myCtx.getId());
    }

    public void scheduleChildrenForCascadeDelete(EntityEnterpriseContext ctx) {
        this.load(ctx);
        FieldState fieldState = this.getFieldState(ctx);
        List value = fieldState.getValue();
        if (!value.isEmpty()) {
            Transaction tx = this.getTransaction();
            for (int i = 0; i < value.size(); ++i) {
                this.relatedCMRField.invokeScheduleForCascadeDelete(tx, value.get(i));
            }
        }
    }

    public void scheduleChildrenForBatchCascadeDelete(EntityEnterpriseContext ctx) {
        this.load(ctx);
        FieldState fieldState = this.getFieldState(ctx);
        List value = fieldState.getValue();
        if (!value.isEmpty()) {
            Transaction tx = this.getTransaction();
            for (int i = 0; i < value.size(); ++i) {
                this.relatedCMRField.invokeScheduleForBatchCascadeDelete(tx, value.get(i));
            }
        }
    }

    private Object invokeScheduleForCascadeDelete(Transaction tx, Object myId) {
        try {
            EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
            SecurityContext sc = SecurityActions.getSecurityContext();
            CMRInvocation invocation = new CMRInvocation();
            invocation.setCmrMessage(CMRMessage.SCHEDULE_FOR_CASCADE_DELETE);
            invocation.setEntrancy(Entrancy.NON_ENTRANT);
            invocation.setId(instanceCache.createCacheKey(myId));
            invocation.setArguments(new Object[]{this});
            invocation.setTransaction(tx);
            invocation.setPrincipal(sc.getUtil().getUserPrincipal());
            invocation.setCredential(sc.getUtil().getCredential());
            invocation.setType(InvocationType.LOCAL);
            return this.manager.getContainer().invoke(invocation);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in scheduleForCascadeDelete()", e);
        }
    }

    private Object invokeScheduleForBatchCascadeDelete(Transaction tx, Object myId) {
        try {
            EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
            SecurityContext sc = SecurityActions.getSecurityContext();
            CMRInvocation invocation = new CMRInvocation();
            invocation.setCmrMessage(CMRMessage.SCHEDULE_FOR_BATCH_CASCADE_DELETE);
            invocation.setEntrancy(Entrancy.NON_ENTRANT);
            invocation.setId(instanceCache.createCacheKey(myId));
            invocation.setArguments(new Object[]{this});
            invocation.setTransaction(tx);
            invocation.setPrincipal(sc.getUtil().getUserPrincipal());
            invocation.setCredential(sc.getUtil().getCredential());
            invocation.setType(InvocationType.LOCAL);
            return this.manager.getContainer().invoke(invocation);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in scheduleForBatchCascadeDelete()", e);
        }
    }

    private Object invokeGetRelatedId(Transaction tx, Object myId) {
        try {
            EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
            SecurityContext sc = SecurityActions.getSecurityContext();
            CMRInvocation invocation = new CMRInvocation();
            invocation.setCmrMessage(CMRMessage.GET_RELATED_ID);
            invocation.setEntrancy(Entrancy.NON_ENTRANT);
            invocation.setId(instanceCache.createCacheKey(myId));
            invocation.setArguments(new Object[]{this});
            invocation.setTransaction(tx);
            invocation.setPrincipal(sc.getUtil().getUserPrincipal());
            invocation.setCredential(sc.getUtil().getCredential());
            invocation.setType(InvocationType.LOCAL);
            return this.manager.getContainer().invoke(invocation);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in getRelatedId", e);
        }
    }

    private void invokeAddRelation(Transaction tx, Object myId, Object relatedId) {
        try {
            SecurityContext sc = SecurityActions.getSecurityContext();
            EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
            CMRInvocation invocation = new CMRInvocation();
            invocation.setCmrMessage(CMRMessage.ADD_RELATION);
            invocation.setEntrancy(Entrancy.NON_ENTRANT);
            invocation.setId(instanceCache.createCacheKey(myId));
            invocation.setArguments(new Object[]{this, relatedId});
            invocation.setTransaction(tx);
            invocation.setPrincipal(sc.getUtil().getUserPrincipal());
            invocation.setCredential(sc.getUtil().getCredential());
            invocation.setType(InvocationType.LOCAL);
            this.manager.getContainer().invoke(invocation);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in addRelation", e);
        }
    }

    private void invokeRemoveRelation(Transaction tx, Object myId, Object relatedId) {
        try {
            EntityCache instanceCache = (EntityCache)this.manager.getContainer().getInstanceCache();
            SecurityContext sc = SecurityActions.getSecurityContext();
            CMRInvocation invocation = new CMRInvocation();
            invocation.setCmrMessage(CMRMessage.REMOVE_RELATION);
            invocation.setEntrancy(Entrancy.NON_ENTRANT);
            invocation.setId(instanceCache.createCacheKey(myId));
            invocation.setArguments(new Object[]{this, relatedId});
            invocation.setTransaction(tx);
            invocation.setPrincipal(sc.getUtil().getUserPrincipal());
            invocation.setCredential(sc.getUtil().getCredential());
            invocation.setType(InvocationType.LOCAL);
            this.manager.getContainer().invoke(invocation);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error in removeRelation", e);
        }
    }

    public Object getRelatedId(EntityEnterpriseContext myCtx) {
        if (this.isCollectionValued()) {
            throw new EJBException("getRelatedId may only be called on a cmr-field with a multiplicity of one.");
        }
        this.load(myCtx);
        List value = this.getFieldState(myCtx).getValue();
        return value.isEmpty() ? null : value.get(0);
    }

    public Object getRelatedIdFromContext(EntityEnterpriseContext ctx) {
        Object relatedId = null;
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge fkField = this.foreignKeyFields[i];
            Object fkFieldValue = fkField.getInstanceValue(ctx);
            if (fkFieldValue == null) {
                return null;
            }
            JDBCCMP2xFieldBridge relatedPKField = (JDBCCMP2xFieldBridge)this.relatedPKFieldsByMyFKFields.get(fkField);
            relatedId = relatedPKField.setPrimaryKeyValue(relatedId, fkFieldValue);
        }
        return relatedId;
    }

    public void addRelation(EntityEnterpriseContext myCtx, Object fk) {
        this.addRelation(myCtx, fk, true);
        this.relationManager.addRelation(this, myCtx.getId(), this.relatedCMRField, fk);
    }

    private void addRelation(EntityEnterpriseContext myCtx, Object fk, boolean updateForeignKey) {
        this.checkSetForeignKey(myCtx, fk);
        if (this.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.getFieldName());
        }
        if (!JDBCEntityBridge.isEjbCreateDone(myCtx)) {
            throw new IllegalStateException("A CMR field cannot be set or added to a relationship in ejbCreate; this should be done in the ejbPostCreate method instead [EJB 2.0 Spec. 10.5.2].");
        }
        FieldState myState = this.getFieldState(myCtx);
        myState.addRelation(fk);
        if (this.hasForeignKey() && updateForeignKey) {
            this.setForeignKey(myCtx, fk);
        }
    }

    public void removeRelation(EntityEnterpriseContext myCtx, Object fk) {
        this.removeRelation(myCtx, fk, true, true);
        this.relationManager.removeRelation(this, myCtx.getId(), this.relatedCMRField, fk);
    }

    private void removeRelation(EntityEnterpriseContext myCtx, Object fk, boolean updateValueCollection, boolean updateForeignKey) {
        if (this.isReadOnly()) {
            throw new EJBException("Field is read-only: " + this.getFieldName());
        }
        if (updateValueCollection) {
            FieldState myState = this.getFieldState(myCtx);
            myState.removeRelation(fk);
        }
        if (this.hasForeignKey() && updateForeignKey) {
            this.setForeignKey(myCtx, null);
        }
    }

    private void load(EntityEnterpriseContext myCtx) {
        Collection<Object> values;
        FieldState fieldState = this.getFieldState(myCtx);
        if (fieldState.isLoaded()) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Read ahead cahce load: cmrField=" + this.getFieldName() + " pk=" + myCtx.getId()));
        }
        this.manager.getReadAheadCache().load(myCtx);
        if (fieldState.isLoaded()) {
            return;
        }
        if (this.hasForeignKey()) {
            boolean loadWithManager = false;
            Object fk = null;
            for (int i = 0; i < this.foreignKeyFields.length; ++i) {
                JDBCCMP2xFieldBridge fkField = this.foreignKeyFields[i];
                if (!fkField.isLoaded(myCtx)) {
                    loadWithManager = true;
                    break;
                }
                Object fkFieldValue = fkField.getInstanceValue(myCtx);
                if (fkFieldValue == null) {
                    fk = null;
                    break;
                }
                JDBCCMP2xFieldBridge relatedPKField = (JDBCCMP2xFieldBridge)this.relatedPKFieldsByMyFKFields.get(fkField);
                fk = relatedPKField.setPrimaryKeyValue(fk, fkFieldValue);
            }
            values = loadWithManager ? this.manager.loadRelation(this, myCtx.getId()) : (fk == null ? Collections.EMPTY_LIST : Collections.singletonList(fk));
        } else {
            values = this.manager.loadRelation(this, myCtx.getId());
        }
        this.load(myCtx, values);
    }

    public void load(EntityEnterpriseContext myCtx, Collection values) {
        if (this.isSingleValued() && values.size() > 1) {
            throw new EJBException("Data contains multiple values, but this cmr field is single valued: " + values);
        }
        FieldState fieldState = this.getFieldState(myCtx);
        fieldState.loadRelations(values);
        if (this.hasForeignKey()) {
            List realValue;
            if (!values.isEmpty()) {
                Object loadedValue = values.iterator().next();
                for (int i = 0; i < this.foreignKeyFields.length; ++i) {
                    JDBCCMP2xFieldBridge fkField = this.foreignKeyFields[i];
                    Object fieldValue = fkField.getPrimaryKeyValue(loadedValue);
                    fkField.updateState(myCtx, fieldValue);
                }
            }
            Object fk = (realValue = fieldState.getValue()).isEmpty() ? null : realValue.get(0);
            this.setForeignKey(myCtx, fk);
        }
        JDBCEntityBridge.setCreated(myCtx);
    }

    public void setForeignKey(EntityEnterpriseContext myCtx, Object fk) {
        if (!this.hasForeignKey()) {
            throw new EJBException(this.getFieldName() + " CMR field does not have a foreign key to set.");
        }
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge fkField = this.foreignKeyFields[i];
            Object fieldValue = fkField.getPrimaryKeyValue(fk);
            fkField.setInstanceValue(myCtx, fieldValue);
        }
    }

    public void initInstance(EntityEnterpriseContext ctx) {
        this.getFieldState(ctx).loadRelations(Collections.EMPTY_SET);
        if (this.foreignKeyFields == null) {
            return;
        }
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge foreignKeyField = this.foreignKeyFields[i];
            if (foreignKeyField.isFKFieldMappedToCMPField()) continue;
            foreignKeyField.setInstanceValue(ctx, null);
        }
    }

    public void resetPersistenceContext(EntityEnterpriseContext ctx) {
        if (!this.isReadTimedOut(ctx)) {
            return;
        }
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        jdbcCtx.setFieldState(this.jdbcContextIndex, null);
        if (this.foreignKeyFields == null) {
            return;
        }
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge foreignKeyField = this.foreignKeyFields[i];
            if (foreignKeyField.isFKFieldMappedToCMPField()) continue;
            foreignKeyField.resetPersistenceContext(ctx);
        }
    }

    public int setInstanceParameters(PreparedStatement ps, int parameterIndex, EntityEnterpriseContext ctx) {
        if (this.foreignKeyFields == null) {
            return parameterIndex;
        }
        List value = this.getFieldState(ctx).getValue();
        Object fk = value.isEmpty() ? null : value.get(0);
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            parameterIndex = this.foreignKeyFields[i].setPrimaryKeyParameters(ps, parameterIndex, fk);
        }
        return parameterIndex;
    }

    public int loadInstanceResults(ResultSet rs, int parameterIndex, EntityEnterpriseContext ctx) {
        if (!this.hasForeignKey()) {
            return parameterIndex;
        }
        Object[] ref = new Object[1];
        parameterIndex = this.loadArgumentResults(rs, parameterIndex, ref);
        FieldState fieldState = this.getFieldState(ctx);
        if (!fieldState.isLoaded()) {
            if (ref[0] != null) {
                this.load(ctx, Collections.singleton(ref[0]));
            } else {
                this.load(ctx, Collections.EMPTY_SET);
            }
        }
        return parameterIndex;
    }

    public int loadArgumentResults(ResultSet rs, int parameterIndex, Object[] fkRef) {
        if (this.foreignKeyFields == null) {
            return parameterIndex;
        }
        boolean fkIsNull = false;
        Object[] argumentRef = new Object[1];
        for (int i = 0; i < this.foreignKeyFields.length; ++i) {
            JDBCCMP2xFieldBridge field = this.foreignKeyFields[i];
            parameterIndex = field.loadArgumentResults(rs, parameterIndex, argumentRef);
            if (fkIsNull) continue;
            if (field.getPrimaryKeyField() != null) {
                if (argumentRef[0] == null) {
                    fkRef[0] = null;
                    fkIsNull = true;
                    continue;
                }
                if (fkRef[0] == null) {
                    fkRef[0] = this.relatedEntity.createPrimaryKeyInstance();
                }
                try {
                    field.getPrimaryKeyField().set(fkRef[0], argumentRef[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new EJBException("Internal error setting foreign-key field " + this.getFieldName(), e);
                }
            }
            fkRef[0] = argumentRef[0];
        }
        return parameterIndex;
    }

    public boolean isDirty(EntityEnterpriseContext ctx) {
        return this.foreignKeyFields == null ? this.relationManager.isDirty() : false;
    }

    public boolean invalidateCache(EntityEnterpriseContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
        return fieldState == null ? false : fieldState.isChanged();
    }

    public void setClean(EntityEnterpriseContext ctx) {
        throw new UnsupportedOperationException();
    }

    public boolean isCMPField() {
        return false;
    }

    public JDBCEntityPersistenceStore getManager() {
        return this.manager;
    }

    public boolean hasFKFieldsMappedToCMPFields() {
        return this.hasFKFieldsMappedToCMPFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRelatedPKWaitingForMyPK(Object myPK, Object relatedPK) {
        Map relatedPKsWaitingForMyPK;
        Map map = relatedPKsWaitingForMyPK = this.getRelatedPKsWaitingForMyPK();
        synchronized (map) {
            ArrayList<Object> relatedPKs = (ArrayList<Object>)relatedPKsWaitingForMyPK.get(myPK);
            if (relatedPKs == null) {
                relatedPKs = new ArrayList<Object>(1);
                relatedPKsWaitingForMyPK.put(myPK, relatedPKs);
            }
            relatedPKs.add(relatedPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelatedPKWaitingForMyPK(Object myPK, Object relatedPK) {
        Map relatedPKMap;
        Map map = relatedPKMap = this.getRelatedPKsWaitingForMyPK();
        synchronized (map) {
            List relatedPKs = (List)relatedPKMap.get(myPK);
            if (relatedPKs != null) {
                relatedPKs.remove(relatedPK);
            }
        }
    }

    private FieldState getFieldState(EntityEnterpriseContext ctx) {
        JDBCContext jdbcCtx = (JDBCContext)ctx.getPersistenceContext();
        FieldState fieldState = (FieldState)jdbcCtx.getFieldState(this.jdbcContextIndex);
        if (fieldState == null) {
            fieldState = new FieldState(ctx);
            jdbcCtx.setFieldState(this.jdbcContextIndex, fieldState);
        }
        return fieldState;
    }

    private void initializeForeignKeyFields() throws DeploymentException {
        Collection foreignKeys = this.metadata.getRelatedRole().getKeyFields();
        HashMap<JDBCCMP2xFieldBridge, JDBCCMP2xFieldBridge> fkFieldsByRelatedPKFields = new HashMap<JDBCCMP2xFieldBridge, JDBCCMP2xFieldBridge>();
        for (JDBCCMPFieldMetaData fkFieldMetaData : foreignKeys) {
            JDBCCMP2xFieldBridge relatedPKField = (JDBCCMP2xFieldBridge)this.relatedEntity.getFieldByName(fkFieldMetaData.getFieldName());
            String fkColumnName = fkFieldMetaData.getColumnName();
            JDBCCMP2xFieldBridge fkField = null;
            JDBCFieldBridge[] tableFields = this.entity.getTableFields();
            for (int tableInd = 0; tableInd < tableFields.length && fkField == null; ++tableInd) {
                JDBCCMP2xFieldBridge cmpField = (JDBCCMP2xFieldBridge)tableFields[tableInd];
                if (!fkColumnName.equals(cmpField.getColumnName())) continue;
                this.hasFKFieldsMappedToCMPFields = true;
                fkField = new JDBCCMP2xFieldBridge((JDBCStoreManager)cmpField.getManager(), relatedPKField.getFieldName(), relatedPKField.getFieldType(), cmpField.getJDBCType(), relatedPKField.isReadOnly(), relatedPKField.getReadTimeOut(), relatedPKField.getPrimaryKeyClass(), relatedPKField.getPrimaryKeyField(), cmpField, this, fkColumnName);
                if (!cmpField.isPrimaryKeyMember()) continue;
                this.relatedPKFieldsByMyPKFields.put(cmpField, relatedPKField);
            }
            if (fkField == null) {
                fkField = new JDBCCMP2xFieldBridge(this.manager, fkFieldMetaData, this.manager.getJDBCTypeFactory().getJDBCType(fkFieldMetaData));
            }
            fkFieldsByRelatedPKFields.put(relatedPKField, fkField);
            this.relatedPKFieldsByMyFKFields.put(fkField, relatedPKField);
        }
        if (fkFieldsByRelatedPKFields.size() > 0) {
            JDBCFieldBridge[] relatedPKFields = this.relatedEntity.getPrimaryKeyFields();
            ArrayList<JDBCCMPFieldBridge> fkList = new ArrayList<JDBCCMPFieldBridge>(relatedPKFields.length);
            for (int i = 0; i < relatedPKFields.length; ++i) {
                JDBCCMPFieldBridge fkField = (JDBCCMPFieldBridge)fkFieldsByRelatedPKFields.remove(relatedPKFields[i]);
                fkList.add(fkField);
            }
            this.foreignKeyFields = fkList.toArray(new JDBCCMP2xFieldBridge[fkList.size()]);
        } else {
            this.foreignKeyFields = null;
        }
        boolean bl = this.allFKFieldsMappedToPKFields = this.relatedPKFieldsByMyPKFields.size() > 0 && this.relatedPKFieldsByMyPKFields.size() == this.foreignKeyFields.length;
        if (this.foreignKeyFields != null) {
            this.jdbcType = new CMRJDBCType(Arrays.asList(this.foreignKeyFields));
        }
    }

    private Transaction getTransaction() {
        try {
            EntityContainer container = this.getJDBCStoreManager().getContainer();
            TransactionManager tm = container.getTransactionManager();
            return tm.getTransaction();
        }
        catch (SystemException e) {
            throw new EJBException("Error getting transaction from the transaction manager", (Exception)((Object)e));
        }
    }

    private Map getRelatedPKsWaitingForMyPK() {
        return (Map)this.relatedPKValuesWaitingForMyPK.get();
    }

    private RelationDataManager initRelationManager(JDBCCMRFieldBridge relatedField) {
        if (this.relationManager == null) {
            this.relationManager = this.metadata.getRelationMetaData().isTableMappingStyle() ? new M2MRelationManager(this, relatedField) : EMPTY_RELATION_MANAGER;
        }
        return this.relationManager;
    }

    private Object getRelatedPrimaryKey(Object localObject) {
        Object relatedId;
        if (this.relatedEntity.getLocalInterface().isAssignableFrom(localObject.getClass())) {
            EJBLocalObject local = (EJBLocalObject)localObject;
            try {
                relatedId = local.getPrimaryKey();
            }
            catch (NoSuchObjectLocalException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("The values of this field must be of type " + this.relatedEntity.getLocalInterface().getName());
        }
        return relatedId;
    }

    public String toString() {
        return this.entity.getEntityName() + '.' + this.getFieldName();
    }

    public static class M2MRelationManager
    implements RelationDataManager {
        private final JDBCCMRFieldBridge leftField;
        private final JDBCCMRFieldBridge rightField;
        private final TransactionLocal relationData = new TransactionLocal(){

            protected Object initialValue() {
                return new RelationData(M2MRelationManager.this.leftField, M2MRelationManager.this.rightField);
            }
        };

        public M2MRelationManager(JDBCCMRFieldBridge leftField, JDBCCMRFieldBridge rightField) {
            this.leftField = leftField;
            this.rightField = rightField;
        }

        public void addRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
            RelationData local = this.getRelationData();
            local.addRelation(field, id, relatedField, relatedId);
        }

        public void removeRelation(JDBCCMRFieldBridge field, Object id, JDBCCMRFieldBridge relatedField, Object relatedId) {
            RelationData local = this.getRelationData();
            local.removeRelation(field, id, relatedField, relatedId);
        }

        public boolean isDirty() {
            RelationData local = this.getRelationData();
            return local.isDirty();
        }

        public RelationData getRelationData() {
            RelationData local = (RelationData)this.relationData.get();
            return local;
        }
    }

    public static interface RelationDataManager {
        public void addRelation(JDBCCMRFieldBridge var1, Object var2, JDBCCMRFieldBridge var3, Object var4);

        public void removeRelation(JDBCCMRFieldBridge var1, Object var2, JDBCCMRFieldBridge var3, Object var4);

        public boolean isDirty();

        public RelationData getRelationData();
    }

    private static final class TxSynchronization
    implements Synchronization {
        private final WeakReference fieldStateRef;

        private TxSynchronization(FieldState fieldState) {
            if (fieldState == null) {
                throw new IllegalArgumentException("fieldState is null");
            }
            this.fieldStateRef = new WeakReference<FieldState>(fieldState);
        }

        public void beforeCompletion() {
            FieldState fieldState = (FieldState)this.fieldStateRef.get();
            if (fieldState != null) {
                fieldState.invalidate();
            }
        }

        public void afterCompletion(int status) {
        }
    }

    private static final class CMRJDBCType
    implements JDBCType {
        private final String[] columnNames;
        private final Class[] javaTypes;
        private final int[] jdbcTypes;
        private final String[] sqlTypes;
        private final boolean[] notNull;

        private CMRJDBCType(List fields) {
            int i;
            ArrayList<String> columnNamesList = new ArrayList<String>();
            ArrayList<Class> javaTypesList = new ArrayList<Class>();
            ArrayList<Integer> jdbcTypesList = new ArrayList<Integer>();
            ArrayList<String> sqlTypesList = new ArrayList<String>();
            ArrayList<Boolean> notNullList = new ArrayList<Boolean>();
            for (JDBCCMPFieldBridge field : fields) {
                JDBCType type = field.getJDBCType();
                for (int i2 = 0; i2 < type.getColumnNames().length; ++i2) {
                    columnNamesList.add(type.getColumnNames()[i2]);
                    javaTypesList.add(type.getJavaTypes()[i2]);
                    jdbcTypesList.add(new Integer(type.getJDBCTypes()[i2]));
                    sqlTypesList.add(type.getSQLTypes()[i2]);
                    notNullList.add(new Boolean(type.getNotNull()[i2]));
                }
            }
            this.columnNames = columnNamesList.toArray(new String[columnNamesList.size()]);
            this.javaTypes = javaTypesList.toArray(new Class[javaTypesList.size()]);
            this.sqlTypes = sqlTypesList.toArray(new String[sqlTypesList.size()]);
            this.jdbcTypes = new int[jdbcTypesList.size()];
            for (i = 0; i < this.jdbcTypes.length; ++i) {
                this.jdbcTypes[i] = (Integer)jdbcTypesList.get(i);
            }
            this.notNull = new boolean[notNullList.size()];
            for (i = 0; i < this.notNull.length; ++i) {
                this.notNull[i] = (Boolean)notNullList.get(i);
            }
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        public Class[] getJavaTypes() {
            return this.javaTypes;
        }

        public int[] getJDBCTypes() {
            return this.jdbcTypes;
        }

        public String[] getSQLTypes() {
            return this.sqlTypes;
        }

        public boolean[] getNotNull() {
            return this.notNull;
        }

        public boolean[] getAutoIncrement() {
            return new boolean[]{false};
        }

        public Object getColumnValue(int index, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object setColumnValue(int index, Object value, Object columnValue) {
            throw new UnsupportedOperationException();
        }

        public boolean hasMapper() {
            throw new UnsupportedOperationException("hasMapper is not implemented.");
        }

        public boolean isSearchable() {
            throw new UnsupportedOperationException("isSearchable is not implemented.");
        }

        public JDBCResultSetReader[] getResultSetReaders() {
            throw new UnsupportedOperationException();
        }

        public JDBCParameterSetter[] getParameterSetter() {
            throw new UnsupportedOperationException();
        }
    }

    private final class FieldState {
        private final EntityEnterpriseContext ctx;
        private List[] setHandle = new List[1];
        private Set addedRelations;
        private Set removedRelations;
        private Set relationSet;
        private boolean isLoaded = false;
        private final long lastRead = -1L;
        private boolean changed;

        public FieldState(EntityEnterpriseContext ctx) {
            this.ctx = ctx;
            this.setHandle[0] = new ArrayList();
        }

        public List getValue() {
            if (!this.isLoaded) {
                throw new EJBException("CMR field value not loaded yet");
            }
            return Collections.unmodifiableList(this.setHandle[0]);
        }

        public boolean isLoaded() {
            return this.isLoaded;
        }

        public long getLastRead() {
            return -1L;
        }

        public void addRelation(Object fk) {
            if (this.isLoaded) {
                this.setHandle[0].add(fk);
            } else {
                if (this.removedRelations == null) {
                    this.removedRelations = new HashSet();
                    this.addedRelations = new HashSet();
                }
                this.removedRelations.remove(fk);
                this.addedRelations.add(fk);
            }
            this.changed = true;
        }

        public void removeRelation(Object fk) {
            if (this.isLoaded) {
                this.setHandle[0].remove(fk);
            } else {
                if (this.removedRelations == null) {
                    this.removedRelations = new HashSet();
                    this.addedRelations = new HashSet();
                }
                this.addedRelations.remove(fk);
                this.removedRelations.add(fk);
            }
            this.changed = true;
        }

        public void loadRelations(Collection values) {
            if (this.isLoaded) {
                throw new EJBException("CMR field value is already loaded");
            }
            this.setHandle[0].clear();
            this.setHandle[0].addAll(values);
            if (this.removedRelations != null) {
                this.setHandle[0].removeAll(this.removedRelations);
                this.removedRelations = null;
            }
            if (this.addedRelations != null) {
                this.setHandle[0].removeAll(this.addedRelations);
                this.setHandle[0].addAll(this.addedRelations);
                this.addedRelations = null;
            }
            this.isLoaded = true;
        }

        public Set getRelationSet() {
            if (!this.isLoaded) {
                throw new EJBException("CMR field value not loaded yet");
            }
            if (this.ctx.isReadOnly()) {
                return new RelationSet(JDBCCMRFieldBridge.this, this.ctx, new List[]{new ArrayList(this.setHandle[0])}, true);
            }
            if (this.relationSet != null) {
                return this.relationSet;
            }
            try {
                EntityContainer container = JDBCCMRFieldBridge.this.getJDBCStoreManager().getContainer();
                TransactionManager tm = container.getTransactionManager();
                Transaction tx = tm.getTransaction();
                if (tx != null && (tx.getStatus() == 0 || tx.getStatus() == 7)) {
                    this.relationSet = new RelationSet(JDBCCMRFieldBridge.this, this.ctx, this.setHandle, false);
                    TxSynchronization sync = new TxSynchronization(this);
                    tx.registerSynchronization((Synchronization)sync);
                } else {
                    this.relationSet = new RelationSet(JDBCCMRFieldBridge.this, this.ctx, new List[1], false);
                }
                return this.relationSet;
            }
            catch (SystemException e) {
                throw new EJBException("Error while creating RelationSet", (Exception)((Object)e));
            }
            catch (RollbackException e) {
                throw new EJBException("Error while creating RelationSet", (Exception)((Object)e));
            }
        }

        public void invalidate() {
            List currentList = null;
            if (this.setHandle != null && this.setHandle.length > 0) {
                currentList = this.setHandle[0];
                this.setHandle[0] = null;
            }
            this.setHandle = new List[1];
            this.setHandle[0] = currentList;
            this.relationSet = null;
            this.changed = false;
        }

        public boolean isChanged() {
            return this.changed;
        }
    }
}

