/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.security.Principal;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.proxy.Interceptor;
import org.jboss.proxy.SecurityActions;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;

public class SecurityInterceptor
extends Interceptor {
    private static final long serialVersionUID = -4206940878404525061L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation invocation) throws Throwable {
        Object credential;
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        Principal principal = sa.getPrincipal();
        if (principal != null) {
            invocation.setPrincipal(principal);
        }
        if ((credential = sa.getCredential()) != null) {
            invocation.setCredential(credential);
        }
        SecurityContext sc = sa.getSecurityContext();
        RunAs callerRAI = sa.getCallerRunAsIdentity();
        SecurityContext newSc = this.createSecurityContext(invocation);
        if (callerRAI != null) {
            newSc.setOutgoingRunAs(callerRAI);
            newSc.setIncomingRunAs(callerRAI);
        }
        invocation.setSecurityContext(newSc);
        try {
            Object object = this.getNext().invoke(invocation);
            Object var10_9 = null;
            if (sc != null) {
                sa.setSecurityContext(sc);
            }
            return object;
        }
        catch (Throwable throwable) {
            block6: {
                Object var10_10 = null;
                if (sc == null) break block6;
                sa.setSecurityContext(sc);
            }
            throw throwable;
        }
    }

    private SecurityContext createSecurityContext(Invocation invocation) throws Exception {
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        Principal p = invocation.getPrincipal();
        Object cred = invocation.getCredential();
        String domain = (String)invocation.getInvocationContext().getValue(InvocationKey.SECURITY_DOMAIN);
        if (domain == null) {
            domain = "CLIENT_PROXY";
        }
        return sa.createSecurityContext(p, cred, domain);
    }
}

