/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;

public class WARStructure
extends AbstractVFSStructureDeployer {
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private VirtualFileFilter webInfLibFilter = DEFAULT_WEB_INF_LIB_FILTER;

    public WARStructure() {
        this.setRelativeOrder(1000);
    }

    public VirtualFileFilter getWebInfLibFilter() {
        return this.webInfLibFilter;
    }

    public void setWebInfLibFilter(VirtualFileFilter webInfLibFilter) {
        if (webInfLibFilter == null) {
            throw new IllegalArgumentException("Null filter");
        }
        this.webInfLibFilter = webInfLibFilter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        ContextInfo context = null;
        VirtualFile file = structureContext.getFile();
        try {
            boolean trace = this.log.isTraceEnabled();
            if (!WARStructure.isLeaf((VirtualFile)file)) {
                block26: {
                    if (!file.getName().endsWith(".war")) {
                        try {
                            VirtualFile child = file.getChild("WEB-INF");
                            if (child != null) {
                                if (trace) {
                                    this.log.trace((Object)"... ok - directory has a WEB-INF subdirectory");
                                }
                                break block26;
                            }
                            if (!trace) return false;
                            this.log.trace((Object)"... no - doesn't look like a war and no WEB-INF subdirectory.");
                            return false;
                        }
                        catch (IOException e) {
                            this.log.warn((Object)("Exception while checking if file is a war: " + e));
                            return false;
                        }
                    }
                    if (trace) {
                        this.log.trace((Object)"... ok - name ends in .war.");
                    }
                }
                ArrayList<String> metaDataLocations = new ArrayList<String>();
                metaDataLocations.add("WEB-INF");
                VirtualFile classes = null;
                try {
                    classes = file.getChild("WEB-INF/classes");
                    if (classes != null) {
                        metaDataLocations.add("WEB-INF/classes/META-INF");
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Exception while looking for classes, " + file.getPathName() + ", " + e));
                }
                List archives = null;
                try {
                    VirtualFile webinfLib = file.getChild("WEB-INF/lib");
                    if (webinfLib != null) {
                        archives = webinfLib.getChildren(this.webInfLibFilter);
                        for (VirtualFile jar : archives) {
                            metaDataLocations.add("WEB-INF/lib/" + jar.getName() + "/META-INF");
                        }
                    }
                }
                catch (IOException e) {
                    this.log.warn((Object)("Exception looking for WEB-INF/lib, " + file.getPathName() + ", " + e));
                }
                context = this.createContext(structureContext, metaDataLocations.toArray(new String[metaDataLocations.size()]));
                this.addClassPath(structureContext, file, false, true, context);
                if (classes != null) {
                    this.addClassPath(structureContext, classes, true, false, context);
                } else if (trace) {
                    this.log.trace((Object)("No WEB-INF/classes for: " + file.getPathName()));
                }
                if (archives != null) {
                    for (VirtualFile jar : archives) {
                        this.addClassPath(structureContext, jar, true, true, context);
                    }
                    return true;
                } else {
                    if (!trace) return true;
                    this.log.trace((Object)("No WEB-INF/lib for: " + file.getPathName()));
                }
                return true;
            }
            if (!trace) return false;
            this.log.trace((Object)"... no - not a directory or an archive.");
            return false;
        }
        catch (Exception e) {
            if (context == null) throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
            structureContext.removeChild(context);
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
    }
}

