/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.util;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.remoting.transport.servlet.ServletServerInvokerMBean;
import org.jboss.remoting.util.SecurityUtility;

public class ServletSecurityUtility {
    public static byte[] processRequest(final ServletServerInvokerMBean invoker, final HttpServletRequest request, final byte[] byteArray, final HttpServletResponse response) throws ServletException, IOException {
        if (SecurityUtility.skipAccessControl()) {
            return invoker.processRequest(request, byteArray, response);
        }
        try {
            return (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ServletException, IOException {
                    return invoker.processRequest(request, byteArray, response);
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServletException) {
                throw (ServletException)cause;
            }
            throw (IOException)e.getCause();
        }
    }
}

