/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.net.URL;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.deployer.SchemaResolverDeployer;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossEjbParsingDeployer
extends SchemaResolverDeployer<JBossMetaData> {
    private JBossMetaData standardMetaData;
    private URL standardJBossXmlPath;
    private boolean ignoreMissingStandardJBossXml = false;

    public JBossEjbParsingDeployer() {
        super(JBossMetaData.class);
        this.setName("jboss.xml");
        this.addInput(EjbJarMetaData.class);
        this.addOutput(ApplicationMetaData.class.getName());
        this.addOutput("standardjboss.xml");
    }

    public URL getStandardJBossXmlPath() {
        return this.standardJBossXmlPath;
    }

    public void setStandardJBossXmlPath(URL standardJBossXmlPath) {
        this.standardJBossXmlPath = standardJBossXmlPath;
    }

    public boolean isIgnoreMissingStandardJBossXml() {
        return this.ignoreMissingStandardJBossXml;
    }

    public void setIgnoreMissingStandardJBossXml(boolean ignoreMissingStandardJBossXml) {
        this.ignoreMissingStandardJBossXml = ignoreMissingStandardJBossXml;
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix) throws DeploymentException {
        super.createMetaData(unit, name, suffix);
        JBossMetaData jbossMetaData = (JBossMetaData)unit.getAttachment(this.getOutput());
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)unit.getAttachment(EjbJarMetaData.class);
        if (ejbJarMetaData != null || jbossMetaData != null) {
            JBossMetaData stdMetaData = this.getStandardMetaData();
            if (stdMetaData != null) {
                unit.addAttachment("standardjboss.xml", (Object)stdMetaData);
            }
            if (jbossMetaData != null) {
                ApplicationMetaData amd = new ApplicationMetaData(jbossMetaData);
                unit.addAttachment(ApplicationMetaData.class, (Object)amd);
            }
        }
    }

    private JBossMetaData getStandardMetaData() throws DeploymentException {
        if (this.standardMetaData == null) {
            try {
                VirtualFile stdJBoss;
                if (this.standardJBossXmlPath == null) {
                    String configPath = System.getProperty("jboss.server.config.url");
                    if (configPath == null) {
                        if (!this.ignoreMissingStandardJBossXml) {
                            throw new DeploymentException("standardjboss.xml not specified and jboss.server.config.url does not exist");
                        }
                        return null;
                    }
                    URL configUrl = new URL(configPath);
                    this.standardJBossXmlPath = new URL(configUrl, "standardjboss.xml");
                }
                if ((stdJBoss = VFS.getCachedFile((URL)this.standardJBossXmlPath)) == null && !this.ignoreMissingStandardJBossXml) {
                    throw new DeploymentException("standardjboss.xml not found in config dir: " + this.standardJBossXmlPath);
                }
                this.standardMetaData = (JBossMetaData)super.parse(stdJBoss);
            }
            catch (Exception ex) {
                DeploymentException.rethrowAsDeploymentException((String)ex.getMessage(), (Throwable)ex);
            }
        }
        return this.standardMetaData;
    }
}

