/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.schema;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEntityException;
import javax.ejb.NoSuchObjectLocalException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.cache.invalidation.InvalidationManagerMBean;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeFactory;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.CacheInvalidator;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.PartitionedTableCache;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Table;
import org.jboss.logging.Logger;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.Registry;
import org.jboss.system.ServiceControllerMBean;
import org.w3c.dom.Element;

public class EntityTable
implements Table {
    private static final byte UNREFERENCED = 0;
    private static final byte CLEAN = 1;
    private static final byte DIRTY = 2;
    private static final byte CREATED = 4;
    private static final byte DELETED = 8;
    private static final byte DIRTY_RELATIONS = 16;
    private static final Object NOT_LOADED = new Object();
    private JDBCEntityBridge2 entity;
    private String tableName;
    private int fieldsTotal;
    private int relationsTotal;
    private DataSource dataSource;
    private Schema schema;
    private int tableId;
    private boolean dontFlushCreated;
    private String deleteSql;
    private String updateSql;
    private String insertSql;
    private String selectSql;
    private String duplicatePkSql;
    private final CommitStrategy insertStrategy;
    private final CommitStrategy deleteStrategy;
    private final CommitStrategy updateStrategy;
    private Logger log;
    private Cache cache;
    private ServiceControllerMBean serviceController;
    private ObjectName cacheName;
    private int[] references;
    private int[] referencedBy;
    private ForeignKeyConstraint[] fkConstraints;
    private CacheInvalidator cacheInvalidator;
    private static final CommitStrategy BATCH_UPDATE = new CommitStrategy(){

        public void executeUpdate(PreparedStatement ps) throws SQLException {
            ps.addBatch();
        }

        public void executeBatch(PreparedStatement ps) throws SQLException {
            int[] updates = ps.executeBatch();
            for (int i = 0; i < updates.length; ++i) {
                int status = updates[i];
                if (status == 1 || status == -2) continue;
                String msg = status == -3 ? "One of the commands in the batch failed to execute" : "Each command in the batch should update exactly 1 row but one of the commands updated " + updates[i] + " rows.";
                throw new EJBException(msg);
            }
        }
    };
    private static final CommitStrategy NON_BATCH_UPDATE = new CommitStrategy(){

        public void executeUpdate(PreparedStatement ps) throws SQLException {
            int rows = ps.executeUpdate();
            if (rows != 1) {
                throw new EJBException("Expected one updated row but got: " + rows);
            }
        }

        public void executeBatch(PreparedStatement ps) {
        }
    };

    public EntityTable(JDBCEntityMetaData metadata, JDBCEntityBridge2 entity, Schema schema, int tableId) throws DeploymentException {
        boolean invalidable;
        Element batchCommitStrategy;
        int partitionsTotal;
        Element otherConf;
        int maxCapacity;
        int minCapacity;
        Element cachePolicy;
        try {
            InitialContext ic = new InitialContext();
            this.dataSource = (DataSource)ic.lookup(metadata.getDataSourceName());
        }
        catch (NamingException e) {
            throw new DeploymentException("Filed to lookup: " + metadata.getDataSourceName(), (Throwable)e);
        }
        this.entity = entity;
        this.tableName = SQLUtil.fixTableName(metadata.getDefaultTableName(), this.dataSource);
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.tableName));
        this.schema = schema;
        this.tableId = tableId;
        EntityMetaData entityMetaData = (EntityMetaData)entity.getContainer().getBeanMetaData();
        ConfigurationMetaData containerConf = entityMetaData.getContainerConfiguration();
        this.dontFlushCreated = containerConf.isInsertAfterEjbPostCreate();
        Element cacheConf = containerConf.getContainerCacheConf();
        Element element = cachePolicy = cacheConf == null ? null : MetaData.getOptionalChild((Element)cacheConf, (String)"cache-policy-conf");
        if (cachePolicy != null) {
            String str = MetaData.getOptionalChildContent((Element)cachePolicy, (String)"min-capacity");
            minCapacity = str == null ? 1000 : Integer.parseInt(str);
            str = MetaData.getOptionalChildContent((Element)cachePolicy, (String)"max-capacity");
            maxCapacity = str == null ? 10000 : Integer.parseInt(str);
        } else {
            minCapacity = 1000;
            maxCapacity = 10000;
        }
        Element element2 = otherConf = cacheConf == null ? null : MetaData.getOptionalChild((Element)cacheConf, (String)"cache-policy-conf-other");
        if (otherConf != null) {
            String str = MetaData.getOptionalChildContent((Element)otherConf, (String)"partitions");
            partitionsTotal = str == null ? 10 : Integer.parseInt(str);
            batchCommitStrategy = MetaData.getOptionalChild((Element)otherConf, (String)"batch-commit-strategy");
            invalidable = MetaData.getOptionalChild((Element)otherConf, (String)"invalidable") != null;
        } else {
            partitionsTotal = 10;
            batchCommitStrategy = null;
            invalidable = false;
        }
        if (cachePolicy != null) {
            this.cache = new PartitionedTableCache(minCapacity, maxCapacity, partitionsTotal);
            String periodStr = MetaData.getOptionalChildContent((Element)cachePolicy, (String)"overager-period");
            String maxAgeStr = MetaData.getOptionalChildContent((Element)cachePolicy, (String)"max-bean-age");
            if (periodStr != null && maxAgeStr == null || maxAgeStr != null && periodStr == null) {
                throw new DeploymentException("Failed to initialize age-out thread for entity " + entity.getEntityName() + ": overager-period or max-bean-age is missing!");
            }
            if (periodStr != null && maxAgeStr != null) {
                long period = Long.parseLong(periodStr);
                long maxAge = Long.parseLong(maxAgeStr);
                ((PartitionedTableCache)this.cache).initOverager(period, maxAge, entity.getEntityName() + " overager");
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("initialized age-out thread for " + entity.getEntityName() + ": overager-period=" + period + ", max-bean-age=" + maxAge));
                }
            }
            MBeanServer server = MBeanServerLocator.locateJBoss();
            this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, (ObjectName)ServiceControllerMBean.OBJECT_NAME, (MBeanServer)server);
            try {
                this.cacheName = new ObjectName("jboss.cmp:service=tablecache,ejbname=" + metadata.getName() + ",table=" + this.tableName);
                server.registerMBean(this.cache, this.cacheName);
                this.serviceController.create(this.cacheName);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to register table cache for " + this.tableName, (Throwable)e);
            }
        } else {
            this.cache = Cache.NONE;
        }
        if (invalidable) {
            String groupName = entityMetaData.getDistributedCacheInvalidationConfig().getInvalidationGroupName();
            String imName = entityMetaData.getDistributedCacheInvalidationConfig().getInvalidationManagerName();
            InvalidationManagerMBean im = (InvalidationManagerMBean)Registry.lookup((Object)imName);
            InvalidationGroup invalidationGroup = im.getInvalidationGroup(groupName);
            this.cacheInvalidator = new CacheInvalidator(this.cache, entity.getContainer().getTransactionManager(), invalidationGroup);
        }
        if (batchCommitStrategy == null) {
            this.insertStrategy = NON_BATCH_UPDATE;
            this.deleteStrategy = NON_BATCH_UPDATE;
            this.updateStrategy = NON_BATCH_UPDATE;
        } else {
            this.log.debug((Object)"batch-commit-strategy enabled");
            this.insertStrategy = BATCH_UPDATE;
            this.deleteStrategy = BATCH_UPDATE;
            this.updateStrategy = BATCH_UPDATE;
        }
    }

    public void start() throws DeploymentException {
        int i;
        int i2;
        JDBCAbstractCMRFieldBridge[] cmrFields = this.entity.getCMRFields();
        this.relationsTotal = cmrFields != null ? cmrFields.length : 0;
        JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])this.entity.getPrimaryKeyFields();
        JDBCCMPFieldBridge2[] tableFields = (JDBCCMPFieldBridge2[])this.entity.getTableFields();
        this.deleteSql = "delete from " + this.tableName + " where ";
        this.deleteSql = this.deleteSql + pkFields[0].getColumnName() + "=?";
        for (i2 = 1; i2 < pkFields.length; ++i2) {
            this.deleteSql = this.deleteSql + " and " + pkFields[i2].getColumnName() + "=?";
        }
        this.log.debug((Object)("delete sql: " + this.deleteSql));
        this.insertSql = "insert into " + this.tableName + "(";
        this.insertSql = this.insertSql + tableFields[0].getColumnName();
        for (i2 = 1; i2 < tableFields.length; ++i2) {
            this.insertSql = this.insertSql + ", " + tableFields[i2].getColumnName();
        }
        this.insertSql = this.insertSql + ") values (?";
        for (i2 = 1; i2 < tableFields.length; ++i2) {
            this.insertSql = this.insertSql + ", ?";
        }
        this.insertSql = this.insertSql + ")";
        this.log.debug((Object)("insert sql: " + this.insertSql));
        this.updateSql = "update " + this.tableName + " set ";
        int setFields = 0;
        for (i = 0; i < tableFields.length; ++i) {
            JDBCCMPFieldBridge2 field = tableFields[i];
            if (field.isPrimaryKeyMember()) continue;
            if (setFields++ > 0) {
                this.updateSql = this.updateSql + ", ";
            }
            this.updateSql = this.updateSql + field.getColumnName() + "=?";
        }
        this.updateSql = this.updateSql + " where ";
        this.updateSql = this.updateSql + pkFields[0].getColumnName() + "=?";
        for (i = 1; i < pkFields.length; ++i) {
            this.updateSql = this.updateSql + " and " + pkFields[i].getColumnName() + "=?";
        }
        if (this.entity.getVersionField() != null) {
            this.updateSql = this.updateSql + " and " + this.entity.getVersionField().getColumnName() + "=?";
        }
        this.log.debug((Object)("update sql: " + this.updateSql));
        String selectColumns = tableFields[0].getColumnName();
        for (int i3 = 1; i3 < tableFields.length; ++i3) {
            JDBCCMPFieldBridge2 field = tableFields[i3];
            selectColumns = selectColumns + ", " + field.getColumnName();
        }
        String whereColumns = pkFields[0].getColumnName() + "=?";
        for (int i4 = 1; i4 < pkFields.length; ++i4) {
            whereColumns = whereColumns + " and " + pkFields[i4].getColumnName() + "=?";
        }
        if (this.entity.getMetaData().hasRowLocking()) {
            JDBCEntityPersistenceStore manager = this.entity.getManager();
            JDBCTypeFactory typeFactory = manager.getJDBCTypeFactory();
            JDBCTypeMappingMetaData typeMapping = typeFactory.getTypeMapping();
            JDBCFunctionMappingMetaData rowLockingTemplate = typeMapping.getRowLockingTemplate();
            if (rowLockingTemplate == null) {
                throw new DeploymentException("Row locking template is not defined for mapping: " + typeMapping.getName());
            }
            this.selectSql = rowLockingTemplate.getFunctionSql(new Object[]{selectColumns, this.tableName, whereColumns, null}, new StringBuffer()).toString();
        } else {
            this.selectSql = "select ";
            this.selectSql = this.selectSql + selectColumns;
            this.selectSql = this.selectSql + " from " + this.tableName + " where ";
            this.selectSql = this.selectSql + whereColumns;
        }
        this.log.debug((Object)("select sql: " + this.selectSql));
        if (this.dontFlushCreated) {
            int i5;
            this.duplicatePkSql = "select ";
            this.duplicatePkSql = this.duplicatePkSql + pkFields[0].getColumnName();
            for (i5 = 1; i5 < pkFields.length; ++i5) {
                this.duplicatePkSql = this.duplicatePkSql + ", " + pkFields[i5].getColumnName();
            }
            this.duplicatePkSql = this.duplicatePkSql + " from " + this.tableName + " where ";
            this.duplicatePkSql = this.duplicatePkSql + pkFields[0].getColumnName() + "=?";
            for (i5 = 1; i5 < pkFields.length; ++i5) {
                this.duplicatePkSql = this.duplicatePkSql + " and " + pkFields[i5].getColumnName() + "=?";
            }
            this.log.debug((Object)("duplicate pk sql: " + this.duplicatePkSql));
        }
        if (this.cacheName != null) {
            try {
                this.serviceController.start(this.cacheName);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to start table cache.", (Throwable)e);
            }
        }
    }

    public void stop() throws Exception {
        if (this.cacheInvalidator != null) {
            this.cacheInvalidator.unregister();
        }
        if (this.cacheName != null) {
            this.serviceController.stop(this.cacheName);
            this.serviceController.destroy(this.cacheName);
            this.serviceController.remove(this.cacheName);
        }
        this.serviceController = null;
    }

    public StringBuffer appendColumnNames(JDBCCMPFieldBridge2[] fields, String alias, StringBuffer buf) {
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if (alias != null) {
                buf.append(alias).append(".");
            }
            buf.append(fields[i].getColumnName());
        }
        return buf;
    }

    public void addField() {
        ++this.fieldsTotal;
    }

    public int addVersionField() {
        return this.fieldsTotal++;
    }

    public ForeignKeyConstraint addFkConstraint(JDBCCMPFieldBridge2[] fkFields, EntityTable referenced) {
        ForeignKeyConstraint fkc;
        this.addReference(referenced);
        referenced.addReferencedBy(this);
        if (this.fkConstraints == null) {
            this.fkConstraints = new ForeignKeyConstraint[1];
        } else {
            ForeignKeyConstraint[] tmp = this.fkConstraints;
            this.fkConstraints = new ForeignKeyConstraint[tmp.length + 1];
            System.arraycopy(tmp, 0, this.fkConstraints, 0, tmp.length);
        }
        int fkindex = this.fkConstraints.length - 1;
        this.fkConstraints[fkindex] = fkc = new ForeignKeyConstraint(fkindex, fkFields, referenced.tableId == this.tableId);
        return fkc;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Object loadRow(ResultSet rs, boolean searchableOnly) {
        View view = this.getView();
        Object pk = view.loadPk(rs);
        if (pk != null) {
            view.loadRow(rs, pk, searchableOnly);
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"loaded pk is null.");
        }
        return pk;
    }

    public Row getRow(Object id) {
        return this.getView().getRow(id);
    }

    public boolean hasRow(Object id) {
        return this.getView().hasRow(id);
    }

    public Row loadRow(Object id) throws SQLException {
        Row row;
        View view = this.getView();
        Row row2 = view.getRowByPk(id, false);
        if (row2 != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("row is already loaded: pk=" + id));
            }
            return row2;
        }
        JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])this.entity.getPrimaryKeyFields();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("executing sql: " + this.selectSql));
            }
            con = this.dataSource.getConnection();
            ps = con.prepareStatement(this.selectSql);
            int paramInd = 1;
            for (int i = 0; i < pkFields.length; ++i) {
                JDBCCMPFieldBridge2 pkField = pkFields[i];
                Object pkValue = pkField.getPrimaryKeyValue(id);
                paramInd = pkField.setArgumentParameters(ps, paramInd, pkValue);
            }
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new NoSuchEntityException("Row not found: " + id);
            }
            row = view.loadRow(rs, id, false);
            Object var13_14 = null;
        }
        catch (SQLException e) {
            try {
                this.log.error((Object)("Failed to load row: table=" + this.tableName + ", pk=" + id));
                throw e;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        return row;
    }

    public int getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Table.View createView(Transaction tx) {
        return new View(tx);
    }

    private void addReference(EntityTable table) {
        boolean wasRegistered = false;
        if (this.references != null) {
            for (int i = 0; i < this.references.length; ++i) {
                if (this.references[i] != table.getTableId()) continue;
                wasRegistered = true;
                break;
            }
            if (!wasRegistered) {
                int[] tmp = this.references;
                this.references = new int[this.references.length + 1];
                System.arraycopy(tmp, 0, this.references, 0, tmp.length);
                this.references[tmp.length] = table.getTableId();
            }
        } else {
            this.references = new int[1];
            this.references[0] = table.getTableId();
        }
        if (!wasRegistered && this.log.isTraceEnabled()) {
            this.log.trace((Object)("references " + table.getTableName()));
        }
    }

    private void addReferencedBy(EntityTable table) {
        boolean wasRegistered = false;
        if (this.referencedBy != null) {
            for (int i = 0; i < this.referencedBy.length; ++i) {
                if (this.referencedBy[i] != table.getTableId()) continue;
                wasRegistered = true;
                break;
            }
            if (!wasRegistered) {
                int[] tmp = this.referencedBy;
                this.referencedBy = new int[this.referencedBy.length + 1];
                System.arraycopy(tmp, 0, this.referencedBy, 0, tmp.length);
                this.referencedBy[tmp.length] = table.getTableId();
            }
        } else {
            this.referencedBy = new int[1];
            this.referencedBy[0] = table.getTableId();
        }
        if (!wasRegistered && this.log.isTraceEnabled()) {
            this.log.trace((Object)("referenced by " + table.getTableName()));
        }
    }

    private void delete(View view) throws SQLException {
        JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])this.entity.getPrimaryKeyFields();
        Connection con = null;
        PreparedStatement ps = null;
        try {
            block8: {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("executing : " + this.deleteSql));
                    }
                    con = this.dataSource.getConnection();
                    ps = con.prepareStatement(this.deleteSql);
                    int batchCount = 0;
                    while (view.deleted != null) {
                        Row row = view.deleted;
                        int paramInd = 1;
                        for (int pkInd = 0; pkInd < pkFields.length; ++pkInd) {
                            JDBCCMPFieldBridge2 pkField = pkFields[pkInd];
                            Object fieldValue = row.fields[pkField.getRowIndex()];
                            paramInd = pkField.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        this.deleteStrategy.executeUpdate(ps);
                        ++batchCount;
                        row.flushStatus();
                    }
                    this.deleteStrategy.executeBatch(ps);
                    if (view.deleted != null) {
                        throw new IllegalStateException("There are still rows to delete!");
                    }
                    if (!this.log.isTraceEnabled()) break block8;
                    this.log.trace((Object)("deleted rows: " + batchCount));
                }
                catch (SQLException e) {
                    this.log.error((Object)("Failed to delete view: " + e.getMessage()), (Throwable)e);
                    throw e;
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
    }

    private void update(View view) throws SQLException {
        JDBCCMPFieldBridge2[] tableFields = (JDBCCMPFieldBridge2[])this.entity.getTableFields();
        JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])this.entity.getPrimaryKeyFields();
        Connection con = null;
        PreparedStatement ps = null;
        try {
            block9: {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("executing : " + this.updateSql));
                    }
                    con = this.dataSource.getConnection();
                    ps = con.prepareStatement(this.updateSql);
                    int batchCount = 0;
                    while (view.dirty != null) {
                        Object fieldValue;
                        int fInd;
                        Row row = view.dirty;
                        int paramInd = 1;
                        for (fInd = 0; fInd < tableFields.length; ++fInd) {
                            JDBCCMPFieldBridge2 field = tableFields[fInd];
                            if (field.isPrimaryKeyMember()) continue;
                            fieldValue = row.fields[field.getRowIndex()];
                            paramInd = field.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        for (fInd = 0; fInd < pkFields.length; ++fInd) {
                            JDBCCMPFieldBridge2 pkField = pkFields[fInd];
                            fieldValue = row.fields[pkField.getRowIndex()];
                            paramInd = pkField.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        JDBCCMPFieldBridge2 versionField = this.entity.getVersionField();
                        if (versionField != null) {
                            Object newVersion;
                            int versionIndex = versionField.getVersionIndex();
                            Object curVersion = row.fields[versionIndex];
                            paramInd = versionField.setArgumentParameters(ps, paramInd, curVersion);
                            ((Row)row).fields[versionIndex] = newVersion = row.fields[versionField.getRowIndex()];
                        }
                        this.updateStrategy.executeUpdate(ps);
                        ++batchCount;
                        row.flushStatus();
                    }
                    this.updateStrategy.executeBatch(ps);
                    if (!this.log.isTraceEnabled()) break block9;
                    this.log.trace((Object)("updated rows: " + batchCount));
                }
                catch (SQLException e) {
                    this.log.error((Object)("Failed to update: table=" + this.tableName), (Throwable)e);
                    throw e;
                }
            }
            Object var14_16 = null;
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
    }

    private void insert(View view) throws SQLException {
        JDBCCMPFieldBridge2[] tableFields = (JDBCCMPFieldBridge2[])this.entity.getTableFields();
        Connection con = null;
        PreparedStatement ps = null;
        try {
            block7: {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("executing : " + this.insertSql));
                    }
                    con = this.dataSource.getConnection();
                    ps = con.prepareStatement(this.insertSql);
                    int batchCount = 0;
                    while (view.created != null) {
                        Row row = view.created;
                        int paramInd = 1;
                        for (int fInd = 0; fInd < tableFields.length; ++fInd) {
                            JDBCCMPFieldBridge2 field = tableFields[fInd];
                            Object fieldValue = row.fields[field.getRowIndex()];
                            paramInd = field.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        this.insertStrategy.executeUpdate(ps);
                        ++batchCount;
                        row.flushStatus();
                    }
                    this.insertStrategy.executeBatch(ps);
                    if (!this.log.isTraceEnabled()) break block7;
                    this.log.trace((Object)("inserted rows: " + batchCount));
                }
                catch (SQLException e) {
                    this.log.error((Object)("Failed to insert new rows: " + e.getMessage()), (Throwable)e);
                    throw e;
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
    }

    private View getView() {
        return (View)this.schema.getView(this);
    }

    public class ForeignKeyConstraint {
        public final int index;
        private final String nullFkSql;
        private final boolean selfReference;

        public ForeignKeyConstraint(int index, JDBCCMPFieldBridge2[] fkFields, boolean selfReference) {
            this.index = index;
            this.selfReference = selfReference;
            StringBuffer buf = new StringBuffer();
            buf.append("update ").append(EntityTable.this.tableName).append(" set ").append(fkFields[0].getColumnName()).append("=null");
            for (int i = 1; i < fkFields.length; ++i) {
                buf.append(", ").append(fkFields[i].getColumnName()).append("=null");
            }
            buf.append(" where ");
            JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])EntityTable.this.entity.getPrimaryKeyFields();
            buf.append(pkFields[0].getColumnName()).append("=?");
            for (int i = 1; i < pkFields.length; ++i) {
                buf.append(" and ").append(pkFields[i].getColumnName()).append("=?");
            }
            this.nullFkSql = buf.toString();
            if (EntityTable.this.log.isDebugEnabled()) {
                EntityTable.this.log.debug((Object)("update foreign key sql: " + this.nullFkSql));
            }
        }
    }

    public static interface CommitStrategy {
        public void executeUpdate(PreparedStatement var1) throws SQLException;

        public void executeBatch(PreparedStatement var1) throws SQLException;
    }

    public class Row {
        private View view;
        private Object pk;
        private final Object[] fields;
        private final Object[] relations;
        private byte state;
        private Row prev;
        private Row next;
        private boolean cacheUpdateScheduled;
        private Row nextCacheUpdate;
        private ForeignKeyConstraint[] fkUpdates;

        public Row(View view) {
            this.view = view;
            this.fields = new Object[EntityTable.this.fieldsTotal];
            this.relations = EntityTable.this.relationsTotal == 0 ? null : new Object[EntityTable.this.relationsTotal];
            this.state = 0;
        }

        public Row(View view, Object[] fields, Object[] relations) {
            this.view = view;
            this.fields = fields;
            this.relations = relations;
            this.state = 0;
        }

        public Object getPk() {
            return this.pk;
        }

        public void loadCachedRelations(int index, Cache.CacheLoader loader) {
            if (this.relations != null) {
                Object cached = this.relations[index];
                this.relations[index] = loader.loadFromCache(cached);
            }
        }

        public void cacheRelations(int index, Cache.CacheLoader loader) {
            this.relations[index] = loader.getCachedValue();
            this.scheduleCacheUpdate();
        }

        public void insert(Object pk) throws DuplicateKeyException {
            this.pk = pk;
            this.view.addCreated(this);
        }

        public Object getFieldValue(int i) {
            if (this.state == 8) {
                throw new NoSuchObjectLocalException("The instance was removed: " + this.pk);
            }
            Object value = this.fields[i];
            if (value == NOT_LOADED) {
                value = this.loadField(i);
            }
            return value;
        }

        public void setFieldValue(int i, Object value) {
            this.fields[i] = value;
        }

        public boolean isDirty() {
            return this.state != 1 && this.state != 16;
        }

        public void setDirty() {
            if (this.state == 1 || this.state == 16) {
                this.updateState((byte)2);
            }
        }

        public void setDirtyRelations() {
            if (this.state == 1) {
                this.updateState((byte)16);
            }
        }

        public void delete() {
            if (this.state == 1 || this.state == 2 || this.state == 16) {
                this.updateState((byte)8);
            } else if (this.state == 4) {
                this.dereference();
                this.state = (byte)8;
                this.view.rowByPk.remove(this.pk);
            } else if (this.state == 8) {
                throw new IllegalStateException("The row is already deleted: pk=" + this.pk);
            }
        }

        public void nullForeignKey(ForeignKeyConstraint constraint) {
            if (this.fkUpdates == null) {
                this.fkUpdates = new ForeignKeyConstraint[EntityTable.this.fkConstraints.length];
                this.view.addRowWithNullFk(this);
            }
            this.fkUpdates[constraint.index] = constraint;
        }

        public void nonNullForeignKey(ForeignKeyConstraint constraint) {
            if (this.fkUpdates != null) {
                this.fkUpdates[constraint.index] = null;
            }
        }

        private void flushStatus() {
            if (this.state == 4 || this.state == 2) {
                this.updateState((byte)1);
                this.fkUpdates = null;
            } else if (this.state == 8) {
                this.dereference();
            } else if (this.state == 16) {
                this.updateState((byte)1);
                this.fkUpdates = null;
            }
            this.scheduleCacheUpdate();
        }

        private void scheduleCacheUpdate() {
            if (!this.cacheUpdateScheduled) {
                if (this.view.cacheUpdates == null) {
                    this.view.cacheUpdates = this;
                } else {
                    this.nextCacheUpdate = this.view.cacheUpdates;
                    this.view.cacheUpdates = this;
                }
                this.cacheUpdateScheduled = true;
            }
        }

        private void updateState(byte state) {
            this.dereference();
            if (state == 1) {
                if (this.view.clean != null) {
                    this.next = this.view.clean;
                    ((View)this.view).clean.prev = this;
                }
                this.view.clean = this;
            } else if (state == 2) {
                if (this.view.dirty != null) {
                    this.next = this.view.dirty;
                    ((View)this.view).dirty.prev = this;
                }
                this.view.dirty = this;
            } else if (state == 4) {
                if (this.view.created != null) {
                    this.next = this.view.created;
                    ((View)this.view).created.prev = this;
                }
                this.view.created = this;
            } else if (state == 8) {
                if (this.view.deleted != null) {
                    this.next = this.view.deleted;
                    ((View)this.view).deleted.prev = this;
                }
                this.view.deleted = this;
            } else if (state == 16) {
                if (this.view.dirtyRelations != null) {
                    this.next = this.view.dirtyRelations;
                    ((View)this.view).dirtyRelations.prev = this;
                }
                this.view.dirtyRelations = this;
            } else {
                throw new IllegalStateException("Can't update to state: " + state);
            }
            this.state = state;
        }

        private void dereference() {
            if (this.state == 1 && this.view.clean == this) {
                this.view.clean = this.next;
            } else if (this.state == 2 && this.view.dirty == this) {
                this.view.dirty = this.next;
            } else if (this.state == 4 && this.view.created == this) {
                this.view.created = this.next;
            } else if (this.state == 8 && this.view.deleted == this) {
                this.view.deleted = this.next;
            } else if (this.state == 16 && this.view.dirtyRelations == this) {
                this.view.dirtyRelations = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.prev = null;
            this.next = null;
        }

        public void flush() throws SQLException, DuplicateKeyException {
            if (this.state != 4) {
                if (EntityTable.this.log.isTraceEnabled()) {
                    EntityTable.this.log.trace((Object)("The row is already inserted: pk=" + this.pk));
                }
                return;
            }
            Connection con = null;
            Statement duplicatePkPs = null;
            PreparedStatement insertPs = null;
            ResultSet rs = null;
            try {
                try {
                    con = EntityTable.this.dataSource.getConnection();
                    if (EntityTable.this.log.isDebugEnabled()) {
                        EntityTable.this.log.debug((Object)("executing : " + EntityTable.this.insertSql));
                    }
                    insertPs = con.prepareStatement(EntityTable.this.insertSql);
                    int paramInd = 1;
                    JDBCCMPFieldBridge2[] tableFields = (JDBCCMPFieldBridge2[])EntityTable.this.entity.getTableFields();
                    for (int fInd = 0; fInd < tableFields.length; ++fInd) {
                        JDBCCMPFieldBridge2 field = tableFields[fInd];
                        Object fieldValue = this.fields[field.getRowIndex()];
                        paramInd = field.setArgumentParameters(insertPs, paramInd, fieldValue);
                    }
                    insertPs.executeUpdate();
                    this.flushStatus();
                }
                catch (SQLException e) {
                    EntityTable.this.log.error((Object)("Failed to insert new rows: " + e.getMessage()), (Throwable)e);
                    throw e;
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(duplicatePkPs);
                JDBCUtil.safeClose(insertPs);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(duplicatePkPs);
            JDBCUtil.safeClose(insertPs);
            JDBCUtil.safeClose(con);
        }

        private Object loadField(int i) {
            JDBCCMPFieldBridge2 field = (JDBCCMPFieldBridge2)EntityTable.this.entity.getFields().get(i);
            StringBuffer query = new StringBuffer();
            query.append("select ").append(field.getColumnName()).append(" from ").append(EntityTable.this.tableName).append(" where ");
            JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])EntityTable.this.entity.getPrimaryKeyFields();
            for (int pkI = 0; pkI < pkFields.length; ++pkI) {
                if (pkI > 0) {
                    query.append(" and ");
                }
                query.append(pkFields[pkI].getColumnName()).append("=?");
            }
            if (EntityTable.this.log.isDebugEnabled()) {
                EntityTable.this.log.debug((Object)("executing: " + query.toString()));
            }
            Object value = null;
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    con = EntityTable.this.dataSource.getConnection();
                    ps = con.prepareStatement(query.toString());
                    for (int pkI = 0; pkI < pkFields.length; ++pkI) {
                        JDBCCMPFieldBridge2 pkField = pkFields[pkI];
                        Object fieldValue = this.fields[pkField.getRowIndex()];
                        pkField.setArgumentParameters(ps, pkI + 1, fieldValue);
                    }
                    rs = ps.executeQuery();
                    if (!rs.next()) {
                        throw new NoSuchEntityException("Row not found: " + this.pk);
                    }
                    value = field.loadArgumentResults(rs, 1);
                }
                catch (SQLException e) {
                    throw new EJBException("Failed to load field " + EntityTable.this.entity.getEntityName() + "." + field.getFieldName() + ": " + e.getMessage(), (Exception)e);
                }
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                JDBCUtil.safeClose(rs);
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            this.fields[field.getRowIndex()] = value;
            return value;
        }
    }

    public class View
    implements Table.View {
        private final Transaction tx;
        private Map rowByPk = new HashMap();
        private Row created;
        private Row deleted;
        private Row dirty;
        private Row dirtyRelations;
        private Row clean;
        private Row cacheUpdates;
        private List rowsWithNullFks;
        private boolean inFlush;

        public View(Transaction tx) {
            this.tx = tx;
        }

        public Row getRow(Object pk) {
            Row row;
            if (pk == null) {
                row = new Row(this);
            } else {
                row = this.getRowByPk(pk, false);
                if (row == null) {
                    row = this.createCleanRow(pk);
                }
            }
            return row;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Row getRowByPk(Object pk, boolean required) {
            Row row = (Row)this.rowByPk.get(pk);
            if (row == null) {
                Object[] fields;
                Object[] relations = null;
                try {
                    EntityTable.this.cache.lock(pk);
                    fields = EntityTable.this.cache.getFields(pk);
                    if (fields != null && EntityTable.this.relationsTotal > 0 && (relations = EntityTable.this.cache.getRelations(pk)) == null) {
                        relations = new Object[EntityTable.this.relationsTotal];
                    }
                    Object var7_6 = null;
                    EntityTable.this.cache.unlock(pk);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    EntityTable.this.cache.unlock(pk);
                    throw throwable;
                }
                if (fields != null) {
                    row = this.createCleanRow(pk, fields, relations);
                }
            }
            if (row == null && required) {
                throw new IllegalStateException("row not found: pk=" + pk);
            }
            return row;
        }

        public void addClean(Row row) {
            if (this.clean != null) {
                row.next = this.clean;
                this.clean.prev = row;
            }
            this.clean = row;
            row.state = (byte)1;
            this.rowByPk.put(row.pk, row);
        }

        public void addCreated(Row row) throws DuplicateKeyException {
            if (this.created != null) {
                row.next = this.created;
                this.created.prev = row;
            }
            this.created = row;
            row.state = (byte)4;
            this.rowByPk.put(row.pk, row);
            JDBCCMPFieldBridge2 versionField = EntityTable.this.entity.getVersionField();
            if (versionField != null) {
                ((Row)row).fields[versionField.getVersionIndex()] = row.fields[versionField.getRowIndex()];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Row loadRow(ResultSet rs, Object pk, boolean searchableOnly) {
            Row row = this.getRowByPk(pk, false);
            if (row != null) {
                if (EntityTable.this.log.isTraceEnabled()) {
                    EntityTable.this.log.trace((Object)("row is already loaded: pk=" + pk));
                }
                return row;
            }
            if (EntityTable.this.log.isTraceEnabled()) {
                EntityTable.this.log.trace((Object)("reading result set: pk=" + pk));
            }
            row = this.createCleanRow(pk);
            JDBCCMPFieldBridge2[] tableFields = (JDBCCMPFieldBridge2[])EntityTable.this.entity.getTableFields();
            int rsOffset = 1;
            for (int i = 0; i < tableFields.length; ++i) {
                Object columnValue;
                JDBCCMPFieldBridge2 field = tableFields[i];
                if (searchableOnly && !field.getJDBCType().isSearchable()) {
                    ((Row)row).fields[field.getRowIndex()] = NOT_LOADED;
                    --rsOffset;
                    continue;
                }
                ((Row)row).fields[field.getRowIndex()] = columnValue = field.loadArgumentResults(rs, field.getRowIndex() + rsOffset);
                if (field.getVersionIndex() == -1) continue;
                ((Row)row).fields[field.getVersionIndex()] = columnValue;
            }
            Object[] relations = EntityTable.this.relationsTotal > 0 ? new Object[EntityTable.this.relationsTotal] : null;
            try {
                EntityTable.this.cache.lock(row.pk);
                EntityTable.this.cache.put(this.tx, row.pk, row.fields, relations);
                Object var11_11 = null;
                EntityTable.this.cache.unlock(row.pk);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                EntityTable.this.cache.unlock(row.pk);
                throw throwable;
            }
            return row;
        }

        public Object loadPk(ResultSet rs) {
            Object pk = null;
            JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])EntityTable.this.entity.getPrimaryKeyFields();
            for (int i = 0; i < pkFields.length; ++i) {
                JDBCCMPFieldBridge2 field = pkFields[i];
                Object columnValue = field.loadArgumentResults(rs, field.getRowIndex() + 1);
                pk = field.setPrimaryKeyValue(pk, columnValue);
            }
            return pk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasRow(Object id) {
            boolean has = this.rowByPk.containsKey(id);
            if (!has) {
                try {
                    EntityTable.this.cache.lock(id);
                    has = EntityTable.this.cache.contains(this.tx, id);
                    Object var4_3 = null;
                    EntityTable.this.cache.unlock(id);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    EntityTable.this.cache.unlock(id);
                    throw throwable;
                }
            }
            return has;
        }

        public void addRowWithNullFk(Row row) {
            if (this.rowsWithNullFks == null) {
                this.rowsWithNullFks = new ArrayList();
            }
            this.rowsWithNullFks.add(row);
        }

        private Row createCleanRow(Object pk) {
            Row row = new Row(this);
            row.pk = pk;
            this.addClean(row);
            return row;
        }

        private Row createCleanRow(Object pk, Object[] fields, Object[] relations) {
            Row row = new Row(this, fields, relations);
            row.pk = pk;
            this.addClean(row);
            return row;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushDeleted(Schema.Views views) throws SQLException {
            if (this.rowsWithNullFks != null) {
                this.nullifyForeignKeys();
                this.rowsWithNullFks = null;
            }
            if (this.deleted == null) {
                if (EntityTable.this.log.isTraceEnabled()) {
                    EntityTable.this.log.trace((Object)"no rows to delete");
                }
                return;
            }
            if (EntityTable.this.referencedBy != null) {
                if (this.inFlush) {
                    if (EntityTable.this.log.isTraceEnabled()) {
                        EntityTable.this.log.trace((Object)"inFlush, ignoring flushDeleted");
                    }
                    return;
                }
                this.inFlush = true;
                try {
                    for (int i = 0; i < EntityTable.this.referencedBy.length; ++i) {
                        Table.View view = views.entityViews[EntityTable.this.referencedBy[i]];
                        if (view == null) continue;
                        view.flushDeleted(views);
                    }
                    Object var5_4 = null;
                    this.inFlush = false;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.inFlush = false;
                    throw throwable;
                }
            }
            EntityTable.this.delete(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flushCreated(Schema.Views views) throws SQLException {
            if (this.created == null || EntityTable.this.dontFlushCreated) {
                if (EntityTable.this.log.isTraceEnabled()) {
                    EntityTable.this.log.trace((Object)"no rows to insert");
                }
                return;
            }
            if (EntityTable.this.references != null) {
                if (this.inFlush) {
                    if (EntityTable.this.log.isTraceEnabled()) {
                        EntityTable.this.log.trace((Object)"inFlush, ignorning flushCreated");
                    }
                    return;
                }
                if (EntityTable.this.log.isTraceEnabled()) {
                    EntityTable.this.log.trace((Object)"flushing created references");
                }
                this.inFlush = true;
                try {
                    for (int i = 0; i < EntityTable.this.references.length; ++i) {
                        Table.View view = views.entityViews[EntityTable.this.references[i]];
                        if (view == null) continue;
                        view.flushCreated(views);
                    }
                    Object var5_4 = null;
                    this.inFlush = false;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.inFlush = false;
                    throw throwable;
                }
            }
            EntityTable.this.insert(this);
        }

        public void flushUpdated() throws SQLException {
            if (this.dirtyRelations != null) {
                while (this.dirtyRelations != null) {
                    Row row = this.dirtyRelations;
                    row.flushStatus();
                }
            }
            if (this.dirty == null) {
                if (EntityTable.this.log.isTraceEnabled()) {
                    EntityTable.this.log.trace((Object)"no rows to update");
                }
                return;
            }
            EntityTable.this.update(this);
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            if (this.cacheUpdates != null) {
                Row cursor = this.cacheUpdates;
                while (cursor != null) {
                    Object var4_3;
                    EntityTable.this.cache.lock(cursor.pk);
                    try {
                        switch (cursor.state) {
                            case 1: {
                                EntityTable.this.cache.put(this.tx, cursor.pk, cursor.fields, cursor.relations);
                                break;
                            }
                            case 8: {
                                try {
                                    EntityTable.this.cache.remove(this.tx, cursor.pk);
                                }
                                catch (Cache.RemoveException e) {
                                    EntityTable.this.log.warn((Object)e.getMessage());
                                }
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected row state: table=" + EntityTable.this.entity.getQualifiedTableName() + ", pk=" + cursor.pk + ", state=" + cursor.state);
                            }
                        }
                        var4_3 = null;
                        EntityTable.this.cache.unlock(cursor.pk);
                    }
                    catch (Throwable throwable) {
                        var4_3 = null;
                        EntityTable.this.cache.unlock(cursor.pk);
                        throw throwable;
                    }
                    cursor = cursor.nextCacheUpdate;
                }
            }
        }

        public void rolledback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void nullifyForeignKeys() throws SQLException {
            if (EntityTable.this.log.isTraceEnabled()) {
                EntityTable.this.log.trace((Object)"nullifying foreign keys");
            }
            Connection con = null;
            PreparedStatement[] ps = new PreparedStatement[EntityTable.this.fkConstraints.length];
            try {
                JDBCCMPFieldBridge2[] pkFields = (JDBCCMPFieldBridge2[])EntityTable.this.entity.getPrimaryKeyFields();
                con = EntityTable.this.dataSource.getConnection();
                for (int i = 0; i < this.rowsWithNullFks.size(); ++i) {
                    Row row = (Row)this.rowsWithNullFks.get(i);
                    ForeignKeyConstraint[] cons = row.fkUpdates;
                    for (int c = 0; c < EntityTable.this.fkConstraints.length; ++c) {
                        if (cons[c] == null || row.state == 8 && !cons[c].selfReference) continue;
                        PreparedStatement s = ps[c];
                        if (s == null) {
                            if (EntityTable.this.log.isDebugEnabled()) {
                                EntityTable.this.log.debug((Object)("nullifying fk: " + cons[c].nullFkSql));
                            }
                            ps[c] = s = con.prepareStatement(cons[c].nullFkSql);
                        }
                        int paramInd = 1;
                        for (int fInd = 0; fInd < pkFields.length; ++fInd) {
                            JDBCCMPFieldBridge2 pkField = pkFields[fInd];
                            Object fieldValue = row.fields[pkField.getRowIndex()];
                            paramInd = pkField.setArgumentParameters(s, paramInd, fieldValue);
                        }
                        int affected = s.executeUpdate();
                        if (affected == 1) continue;
                        throw new EJBException("Affected " + affected + " rows while expected just one");
                    }
                }
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                for (int i = 0; i < ps.length; ++i) {
                    JDBCUtil.safeClose(ps[i]);
                }
                JDBCUtil.safeClose(con);
                throw throwable;
            }
            for (int i = 0; i < ps.length; ++i) {
                JDBCUtil.safeClose(ps[i]);
            }
            {
            }
            JDBCUtil.safeClose(con);
        }
    }
}

