/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.SimplePrincipal;

public class RolesAuthorization {
    private HashSet requiredRoles = new HashSet();

    public RolesAuthorization() {
        this.requiredRoles.add(new SimplePrincipal("JBossAdmin"));
    }

    public void setRequiredRoles(HashSet requiredRoles) {
        this.requiredRoles = requiredRoles;
    }

    public void authorize(Principal caller, Subject subject, String objectname, String opname) {
        Set<Group> groups = subject.getPrincipals(Group.class);
        Group roles = null;
        for (Group grp : groups) {
            if (!grp.getName().equals("Roles")) continue;
            roles = grp;
            break;
        }
        if (roles == null) {
            throw new SecurityException("Subject has no Roles");
        }
        Iterator<Object> iter = this.requiredRoles.iterator();
        boolean hasRole = false;
        while (iter.hasNext() && !hasRole) {
            Principal p = (Principal)iter.next();
            hasRole = roles.isMember(p);
        }
        if (!hasRole) {
            throw new SecurityException("Authorization failure, requiredRoles=" + this.requiredRoles + ", callerRoles=" + roles);
        }
    }
}

