/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.util.ArrayList;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.javaee.support.IdMetaData;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecurityDeployer<T extends IdMetaData>
extends AbstractDeployer {
    private static final String JACC_ATTACHMENT_NAME = "jboss.jacc";
    private static final String BASE_OBJECT_NAME = "jboss.jacc:service=jacc,id=";
    private static final String XACML_POLICY_FILE_NAME = "jboss-xacml-policy.xml";
    private static final String ACL_POLICY_FILE_NAME = "jboss-acl-policy.xml";
    private PolicyRegistration policyRegistration;

    public PolicyRegistration getPolicyRegistration() {
        return this.policyRegistration;
    }

    public void setPolicyRegistration(PolicyRegistration policyRegistration) {
        this.policyRegistration = policyRegistration;
    }

    public AbstractSecurityDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setInput(this.getMetaDataClassType());
        this.setOutput(ServiceMetaData.class);
        this.addOutput(JACC_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        IdMetaData metaData = (IdMetaData)unit.getAttachment(this.getMetaDataClassType());
        if (metaData == null) {
            return;
        }
        String contextId = unit.getSimpleName();
        if (unit.getParent() == null || this.getParentJaccPolicyBean(unit) == null) {
            this.createTopLevelServiceBeanWithMetaData(contextId, unit, metaData);
        } else {
            ServiceMetaData subjaccPolicy = this.getServiceMetaData();
            String deploymentName = unit.getSimpleName();
            try {
                subjaccPolicy.setObjectName(new ObjectName(this.getObjectName(unit)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ServiceConstructorMetaData serviceConstructor = new ServiceConstructorMetaData();
            serviceConstructor.setSignature(new String[]{String.class.getName(), this.getMetaDataClassType().getName()});
            serviceConstructor.setParameters(new Object[]{deploymentName, metaData});
            subjaccPolicy.setConstructor(serviceConstructor);
            ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
            services.add(subjaccPolicy);
            unit.addAttachment(JACC_ATTACHMENT_NAME, (Object)subjaccPolicy, ServiceMetaData.class);
            ServiceMetaData parentServiceMetaData = this.getParentJaccPolicyBean(unit);
            if (parentServiceMetaData != null) {
                ServiceDependencyMetaData serviceDependencyMetaData = new ServiceDependencyMetaData();
                serviceDependencyMetaData.setIDependOnObjectName(subjaccPolicy.getObjectName());
                parentServiceMetaData.addDependency(serviceDependencyMetaData);
                ServiceAttributeMetaData serviceAttributeMetaData = new ServiceAttributeMetaData();
                serviceAttributeMetaData.setName("PolicyConfigurationFacadeMBean");
                ServiceDependencyValueMetaData dependencyValue = new ServiceDependencyValueMetaData();
                dependencyValue.setDependency(subjaccPolicy.getObjectName().toString());
                dependencyValue.setProxyType("attribute");
                serviceAttributeMetaData.setValue((ServiceValueMetaData)dependencyValue);
                parentServiceMetaData.addAttribute(serviceAttributeMetaData);
            }
        }
        if (this.policyRegistration != null && unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit deploymentUnit = (VFSDeploymentUnit)unit;
            try {
                VirtualFile aclPolicyFile;
                VirtualFile xacmlFile = deploymentUnit.getMetaDataFile(XACML_POLICY_FILE_NAME);
                if (xacmlFile != null) {
                    this.policyRegistration.registerPolicy(contextId, "XACML", xacmlFile.toURL());
                }
                if ((aclPolicyFile = deploymentUnit.getMetaDataFile(ACL_POLICY_FILE_NAME)) != null) {
                    this.policyRegistration.registerPolicy(contextId, "ACL", aclPolicyFile.toURL());
                }
            }
            catch (Exception e) {
                this.log.debug((Object)"Fail to process security configuration file", (Throwable)e);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(JACC_ATTACHMENT_NAME);
        String contextId = unit.getSimpleName();
        if (this.policyRegistration != null) {
            this.policyRegistration.deRegisterPolicy(contextId, "XACML");
            this.policyRegistration.deRegisterPolicy(contextId, "ACL");
        }
    }

    private void createTopLevelServiceBeanWithMetaData(String contextId, DeploymentUnit unit, T deployment) {
        ServiceConstructorMetaData serviceConstructor = new ServiceConstructorMetaData();
        serviceConstructor.setSignature(new String[]{String.class.getName(), this.getMetaDataClassType().getName(), Boolean.class.getName()});
        serviceConstructor.setParameters(new Object[]{contextId, deployment, Boolean.TRUE});
        this.createJaccPolicyBean(serviceConstructor, unit);
    }

    private void createJaccPolicyBean(ServiceConstructorMetaData serviceConstructor, DeploymentUnit unit) {
        ServiceMetaData jaccPolicy = new ServiceMetaData();
        jaccPolicy.setCode(this.getJaccPolicyName());
        try {
            jaccPolicy.setObjectName(new ObjectName(this.getObjectName(unit)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        jaccPolicy.setConstructor(serviceConstructor);
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        services.add(jaccPolicy);
        unit.addAttachment(JACC_ATTACHMENT_NAME, (Object)jaccPolicy, ServiceMetaData.class);
    }

    private ServiceMetaData getParentJaccPolicyBean(DeploymentUnit childDU) {
        for (DeploymentUnit parentDU = childDU.getParent(); parentDU != null; parentDU = parentDU.getParent()) {
            ServiceMetaData parentJacc = (ServiceMetaData)parentDU.getAttachment(JACC_ATTACHMENT_NAME);
            if (parentJacc == null) continue;
            return parentJacc;
        }
        return null;
    }

    protected abstract String getJaccPolicyName();

    protected abstract Class<T> getMetaDataClassType();

    protected abstract ServiceMetaData getServiceMetaData();

    private String getObjectName(DeploymentUnit unit) {
        String deploymentName = unit.getName();
        DeploymentUnit parentDU = unit.getParent();
        String parentDeploymentName = parentDU != null ? ",parent=\"" + parentDU.getSimpleName() + "\"" : "";
        return "jboss.jacc:service=jacc,id=\"" + deploymentName + "\"" + parentDeploymentName;
    }
}

