/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.plugins.AbstractTxInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.tm.TxUtils;

abstract class AbstractTxInterceptorBMT
extends AbstractTxInterceptor {
    private ThreadLocal userTransaction = new ThreadLocal();
    protected boolean stateless = true;

    AbstractTxInterceptorBMT() {
    }

    public void create() throws Exception {
        super.create();
        RefAddr refAddr = new RefAddr("userTransaction"){
            private static final long serialVersionUID = -8228448967597474960L;

            public Object getContent() {
                return AbstractTxInterceptorBMT.this.userTransaction;
            }
        };
        Reference ref = new Reference("javax.transaction.UserTransaction", refAddr, new UserTxFactory().getClass().getName(), null);
        ((Context)new InitialContext().lookup("java:comp/")).bind("UserTransaction", (Object)ref);
    }

    public void stop() {
        try {
            ((Context)new InitialContext().lookup("java:comp/")).unbind("UserTransaction");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invokeNext(Invocation mi) throws Exception {
        oldTransaction = mi.getTransaction();
        oldUserTx = this.userTransaction.get();
        threadTx = this.tm.suspend();
        try {
            ctx = (EnterpriseContext)mi.getEnterpriseContext();
            try {
                AllowedOperationsAssociation.pushInMethodFlag(AbstractTxInterceptorBMT.IN_INTERCEPTOR_METHOD);
                this.userTransaction.set(ctx.getEJBContext().getUserTransaction());
                var7_6 = null;
            }
            catch (Throwable var6_8) {
                var7_7 = null;
                AllowedOperationsAssociation.popInMethodFlag();
                throw var6_8;
            }
            AllowedOperationsAssociation.popInMethodFlag();
            beanTx = ctx.getTransaction();
            if (beanTx != null) {
                this.tm.resume(beanTx);
            }
            mi.setTransaction(beanTx);
            try {
                var7_6 = super.invokeNext(mi, false);
                var9_10 = null;
                ** GOTO lbl-1000
            }
            catch (Throwable var8_20) {
                block16: {
                    var9_11 = null;
                    try {
                        if (this.stateless) {
                            this.checkStatelessDone();
                        } else {
                            this.checkBadStateful();
                        }
                        var11_14 = null;
                    }
                    catch (Throwable var10_17) {
                        var11_15 = null;
                        this.tm.suspend();
                        throw var10_17;
                    }
lbl-1000:
                    // 1 sources

                    try {}
                    catch (Throwable var10_16) {
                        var11_13 = null;
                        this.tm.suspend();
                        throw var10_16;
                    }
                    if (this.stateless) {
                        this.checkStatelessDone();
                    } else {
                        this.checkBadStateful();
                    }
                    var11_12 = null;
                    this.tm.suspend();
                    break block16;
                    this.tm.suspend();
                    throw var8_20;
                }
                var13_18 = null;
                this.userTransaction.set(oldUserTx);
                mi.setTransaction(oldTransaction);
                if (threadTx == null) return var7_6;
            }
        }
        catch (Throwable var12_21) {
            var13_19 = null;
            this.userTransaction.set(oldUserTx);
            mi.setTransaction(oldTransaction);
            if (threadTx == null) throw var12_21;
            this.tm.resume(threadTx);
            throw var12_21;
        }
        this.tm.resume(threadTx);
        return var7_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatelessDone() throws RemoteException {
        Transaction tx2;
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            this.log.error((Object)"Failed to get status", (Throwable)ex);
        }
        try {
            switch (status) {
                case 0: 
                case 1: 
                case 7: 
                case 8: 
                case 9: {
                    try {
                        this.tm.rollback();
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"Failed to rollback", (Throwable)ex);
                    }
                }
                case 2: {
                    String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before" + " returning (ejb1.1 spec, 11.6.1)";
                    this.log.error((Object)msg);
                    throw new RemoteException(msg);
                }
            }
            Object var4_5 = null;
            tx2 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Transaction tx2 = null;
            try {
                tx2 = this.tm.suspend();
            }
            catch (SystemException ex) {
                this.log.error((Object)"Failed to suspend transaction", (Throwable)ex);
            }
            if (tx2 != null) {
                String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before " + " returning (ejb1.1 spec, 11.6.1), suspended tx=" + tx2;
                this.log.error((Object)msg);
                throw new RemoteException(msg);
            }
            throw throwable;
        }
        try {
            tx2 = this.tm.suspend();
        }
        catch (SystemException ex) {
            this.log.error((Object)"Failed to suspend transaction", (Throwable)ex);
        }
        if (tx2 != null) {
            String msg = "Application error: BMT stateless bean " + this.container.getBeanMetaData().getEjbName() + " should complete transactions before " + " returning (ejb1.1 spec, 11.6.1), suspended tx=" + tx2;
            this.log.error((Object)msg);
            throw new RemoteException(msg);
        }
    }

    private void checkBadStateful() throws RemoteException {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            this.log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception ex) {
                    this.log.error((Object)"Failed to rollback", (Throwable)ex);
                }
                String msg = "BMT stateful bean '" + this.container.getBeanMetaData().getEjbName() + "' did not complete user transaction properly status=" + TxUtils.getStatusAsString((int)status);
                this.log.error((Object)msg);
            }
        }
    }

    public static class UserTxFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object ref, Name name, Context nameCtx, Hashtable environment) throws Exception {
            RefAddr refAddr = ((Reference)ref).get(0);
            ThreadLocal threadLocal = (ThreadLocal)refAddr.getContent();
            return threadLocal.get();
        }
    }
}

