/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCInsertPKCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.ejb.plugins.keygenerator.KeyGenerator;
import org.jboss.ejb.plugins.keygenerator.KeyGeneratorFactory;

public class JDBCKeyGeneratorCreateCommand
extends JDBCInsertPKCreateCommand {
    protected KeyGenerator keyGenerator;
    protected JDBCCMPFieldBridge pkField;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
        this.pkField = this.getGeneratedPKField();
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        String factoryName = entityCommand.getAttribute("key-generator-factory");
        if (factoryName == null) {
            throw new DeploymentException("key-generator-factory attribute must be set for entity " + this.entity.getEntityName());
        }
        try {
            KeyGeneratorFactory keyGeneratorFactory = (KeyGeneratorFactory)new InitialContext().lookup(factoryName);
            this.keyGenerator = keyGeneratorFactory.getKeyGenerator();
        }
        catch (NamingException e) {
            throw new DeploymentException("Error: can't find key generator factory: " + factoryName, (Throwable)e);
        }
        catch (Exception e) {
            throw new DeploymentException("Error: can't create key generator instance; key generator factory: " + factoryName, (Throwable)e);
        }
    }

    protected void generateFields(EntityEnterpriseContext ctx) throws CreateException {
        super.generateFields(ctx);
        Object pk = this.keyGenerator.generateKey();
        this.log.debug((Object)("Generated new pk: " + pk));
        this.pkField.setInstanceValue(ctx, pk);
    }
}

