/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.connector.invoker;

import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.jmx.connector.invoker.RolesAuthorization;
import org.jboss.logging.Logger;
import org.jboss.security.SimplePrincipal;

public class ExternalizableRolesAuthorization
extends RolesAuthorization {
    private static Logger log = Logger.getLogger(ExternalizableRolesAuthorization.class);
    private boolean trace = log.isTraceEnabled();

    public ExternalizableRolesAuthorization() {
        Properties props = new Properties();
        try {
            props.load(this.getTCL().getResourceAsStream("jmxinvoker-roles.properties"));
            this.setRequiredRoles(this.getSetOfRoles(props.getProperty("roles")));
        }
        catch (Exception e) {
            log.error((Object)"Error reading roles from jmxinvoker-roles.properties:", (Throwable)e);
        }
    }

    private HashSet getSetOfRoles(String assignedRoles) {
        if (this.trace) {
            log.trace((Object)("AssignedRolesString=" + assignedRoles));
        }
        HashSet<SimplePrincipal> set = new HashSet<SimplePrincipal>();
        StringTokenizer st = new StringTokenizer(assignedRoles, ",");
        while (st.hasMoreTokens()) {
            String aRole = st.nextToken();
            set.add(new SimplePrincipal(aRole));
        }
        if (this.trace) {
            log.trace((Object)("roles set=" + set));
        }
        return set;
    }

    private ClassLoader getTCL() {
        return Thread.currentThread().getContextClassLoader();
    }
}

