/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.auth.Subject;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SecurityUtil;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.javaee.AbstractEJBAuthorizationHelper;
import org.jboss.security.javaee.EJBAuthenticationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.jboss.system.Registry;

public class SecurityInterceptor
extends AbstractInterceptor {
    protected AuthenticationManager securityManager;
    protected RealmMapping realmMapping;
    protected RunAs runAsIdentity;
    protected Map securityRoles;
    protected Map<String, Set<String>> deploymentRoles;
    protected AuthenticationObserver authenticationObserver;
    protected Method ejbTimeout;
    protected String ejbName = null;
    protected CodeSource ejbCS = null;
    protected String appSecurityDomain = null;
    protected String defaultAuthorizationSecurityDomain = "jboss-ejb-policy";
    protected boolean isUseCallerIdentity = false;
    protected ISecurityManagement securityManagement = null;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            this.securityRoles = assemblyDescriptor.getSecurityRoles();
            this.deploymentRoles = assemblyDescriptor.getPrincipalVersusRolesMap();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                if (principalName == null) {
                    principalName = applicationMetaData.getUnauthenticatedPrincipal();
                }
                Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
            if (secMetaData != null && secMetaData.getUseCallerIdentity()) {
                this.isUseCallerIdentity = true;
            }
            this.securityManager = container.getSecurityManager();
            this.realmMapping = container.getRealmMapping();
            try {
                this.ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            if (this.securityManager != null) {
                this.appSecurityDomain = this.securityManager.getSecurityDomain();
                this.appSecurityDomain = SecurityUtil.unprefixSecurityDomain((String)this.appSecurityDomain);
            }
            this.ejbName = beanMetaData.getEjbName();
            this.ejbCS = container.getBeanClass().getProtectionDomain().getCodeSource();
            this.securityManagement = container.getSecurityManagement();
        }
    }

    public void start() throws Exception {
        super.start();
        this.authenticationObserver = (AuthenticationObserver)Registry.lookup((Object)"SecurityInterceptor.AuthenticationObserver");
        if (this.container != null) {
            this.securityManager = this.container.getSecurityManager();
            if (this.securityManager != null) {
                this.appSecurityDomain = this.securityManager.getSecurityDomain();
                this.appSecurityDomain = SecurityUtil.unprefixSecurityDomain((String)this.appSecurityDomain);
            }
        }
    }

    public Object invokeHome(Invocation mi) throws Exception {
        boolean isInvoke = false;
        return this.process(mi, isInvoke);
    }

    public Object invoke(Invocation mi) throws Exception {
        boolean isInvoke = true;
        return this.process(mi, isInvoke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object process(Invocation mi, boolean isInvoke) throws Exception {
        if (this.shouldBypassSecurity(mi)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Bypass security for invoke or invokeHome");
            }
            if (isInvoke) {
                return this.getNext().invoke(mi);
            }
            return this.getNext().invokeHome(mi);
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            throw new IllegalStateException("Security Context is null");
        }
        RunAs callerRunAsIdentity = sc.getIncomingRunAs();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Caller RunAs=" + callerRunAsIdentity + ": useCallerIdentity=" + this.isUseCallerIdentity));
        }
        try {
            this.checkSecurityContext(mi, callerRunAsIdentity);
        }
        catch (Exception e) {
            this.log.error((Object)"Error in Security Interceptor", (Throwable)e);
            throw e;
        }
        if (callerRunAsIdentity != null && this.isUseCallerIdentity) {
            this.runAsIdentity = callerRunAsIdentity;
        }
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            if (isInvoke) {
                Object object = this.getNext().invoke(mi);
                return object;
            }
            Object object = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
        }
    }

    private void checkSecurityContext(Invocation mi, RunAs callerRunAsIdentity) throws Exception {
        boolean isTrusted;
        boolean containerMethod;
        Principal principal = mi.getPrincipal();
        Object credential = mi.getCredential();
        boolean trace = this.log.isTraceEnabled();
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.pushSubjectContext(principal, credential, null);
            return;
        }
        if (this.realmMapping == null) {
            throw new SecurityException("Role mapping manager has not been set");
        }
        SecurityContext sc = SecurityActions.getSecurityContext();
        EJBAuthenticationHelper helper = SecurityHelperFactory.getEJBAuthenticationHelper((SecurityContext)sc);
        boolean bl2 = isTrusted = this.containsTrustableRunAs(sc) || helper.isTrusted();
        if (!isTrusted) {
            Subject subject = new Subject();
            if (!SecurityActions.isValid(helper, subject, m.getName())) {
                if (this.authenticationObserver != null) {
                    this.authenticationObserver.authenticationFailed();
                }
                String msg = "Authentication exception, principal=" + principal;
                throw new SecurityException(msg);
            }
            SecurityActions.pushSubjectContext(principal, credential, subject);
            if (trace) {
                this.log.trace((Object)("Authenticated principal=" + principal + " in security domain=" + sc.getSecurityDomain()));
            }
        } else {
            SecurityActions.pushRunAsIdentity(callerRunAsIdentity);
        }
        Method ejbMethod = mi.getMethod();
        if (ejbMethod == null) {
            return;
        }
        Subject caller = SecurityActions.getContextSubject();
        if (caller == null) {
            throw new IllegalStateException("Authenticated User. But caller subject is null");
        }
        SecurityRolesAssociation.setSecurityRoles(this.deploymentRoles);
        boolean isAuthorized = false;
        Set<Principal> methodRoles = this.container.getMethodPermissions(ejbMethod, mi.getType());
        SecurityContext currentSC = SecurityActions.getSecurityContext();
        if (SecurityActions.getSecurityManagement(currentSC) == null) {
            SecurityActions.setSecurityManagement(currentSC, this.securityManagement);
        }
        AbstractEJBAuthorizationHelper authorizationHelper = SecurityHelperFactory.getEJBAuthorizationHelper((SecurityContext)sc);
        authorizationHelper.setPolicyRegistration(this.container.getPolicyRegistration());
        isAuthorized = SecurityActions.authorize(authorizationHelper, this.ejbName, ejbMethod, mi.getPrincipal(), mi.getType().toInterfaceString(), this.ejbCS, caller, callerRunAsIdentity, this.container.getJaccContextID(), (RoleGroup)new SimpleRoleGroup(methodRoles));
        String msg = "Denied: caller with subject=" + caller + " and security context post-mapping roles=" + SecurityActions.getRolesFromSecurityContext(currentSC) + ": ejbMethod=" + ejbMethod;
        if (!isAuthorized) {
            throw new SecurityException(msg);
        }
    }

    private boolean shouldBypassSecurity(Invocation mi) throws Exception {
        boolean containerMethod;
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), "BYPASSED-SECURITY");
            if (this.runAsIdentity != null) {
                SecurityActions.pushRunAsIdentity(this.runAsIdentity);
            }
            return true;
        }
        return false;
    }

    private boolean containsTrustableRunAs(SecurityContext sc) {
        RunAs incomingRunAs = sc.getIncomingRunAs();
        return incomingRunAs != null && incomingRunAs instanceof RunAsIdentity;
    }

    public static interface AuthenticationObserver {
        public static final String KEY = "SecurityInterceptor.AuthenticationObserver";

        public void authenticationFailed();
    }
}

