/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPermissionMapping {
    static Logger log = Logger.getLogger(WebPermissionMapping.class);
    private static final int PREFIX = 1;
    private static final int EXTENSION = 2;
    private static final int DEFAULT = 3;
    private static final int EXACT = 4;

    public static void createPermissions(JBossWebMetaData metaData, PolicyConfiguration pc) throws PolicyContextException {
        Set servletNames;
        HashMap<String, PatternInfo> patternMap = WebPermissionMapping.qualifyURLPatterns(metaData);
        log.debug((Object)("Qualified url patterns: " + patternMap));
        List constraints = metaData.getSecurityConstraints();
        if (constraints != null) {
            for (SecurityConstraintMetaData sc : constraints) {
                PatternInfo info;
                String url;
                int n;
                int length;
                List urlPatterns;
                List httpMethods;
                WebResourceCollectionsMetaData resources = sc.getResourceCollections();
                TransportGuaranteeType transport = sc.getTransportGuarantee();
                if (sc.isExcluded() || sc.isUnchecked()) {
                    if (resources == null) continue;
                    for (WebResourceCollectionMetaData wrc : resources) {
                        httpMethods = wrc.getHttpMethods();
                        urlPatterns = wrc.getUrlPatterns();
                        length = urlPatterns != null ? urlPatterns.size() : 0;
                        for (n = 0; n < length; ++n) {
                            url = (String)urlPatterns.get(n);
                            info = patternMap.get(url);
                            if (!sc.isExcluded()) continue;
                            info.addExcludedMethods(httpMethods);
                        }
                    }
                    continue;
                }
                if (resources == null) continue;
                for (WebResourceCollectionMetaData wrc : resources) {
                    httpMethods = wrc.getHttpMethods();
                    urlPatterns = wrc.getUrlPatterns();
                    length = urlPatterns != null ? urlPatterns.size() : 0;
                    for (n = 0; n < length; ++n) {
                        url = (String)urlPatterns.get(n);
                        info = patternMap.get(url);
                        HashSet<String> mappedRoles = new HashSet<String>();
                        if (sc.getRoleNames() != null) {
                            for (String role : sc.getRoleNames()) {
                                if (role.equals("*")) {
                                    if (metaData.isJaccAllStoreRole()) {
                                        mappedRoles.add("*");
                                        continue;
                                    }
                                    for (SecurityRoleMetaData srmd : metaData.getSecurityRoles()) {
                                        role = srmd.getRoleName();
                                        mappedRoles.add(role);
                                    }
                                    continue;
                                }
                                mappedRoles.add(role);
                            }
                        }
                        info.addRoles(mappedRoles, httpMethods);
                        info.addTransport(transport.name(), httpMethods);
                        if (sc.getAuthConstraint() != null) continue;
                        info.isMissingAuthConstraint = true;
                    }
                }
            }
        }
        for (PatternInfo info : patternMap.values()) {
            String qurl = info.getQualifiedPattern();
            if (info.isOverriden) {
                log.debug((Object)("Dropping overriden pattern: " + info));
                continue;
            }
            String[] httpMethods = info.getExcludedMethods();
            if (httpMethods != null) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, null);
                pc.addToExcludedPolicy((Permission)wrp);
                pc.addToExcludedPolicy((Permission)wudp);
                String excludedString = "!" + WebPermissionMapping.getCommaSeparatedString(httpMethods);
                WebResourcePermission wrp1 = new WebResourcePermission(info.pattern, excludedString);
                WebUserDataPermission wudp1 = new WebUserDataPermission(info.pattern, excludedString);
                pc.addToUncheckedPolicy((Permission)wrp1);
                pc.addToUncheckedPolicy((Permission)wudp1);
            }
            Iterator<Map.Entry<String, Set<String>>> roles = info.getRoleMethods();
            while (roles.hasNext()) {
                WebResourcePermission wrp;
                Map.Entry<String, Set<String>> roleMethods = roles.next();
                String role = roleMethods.getKey();
                if ("*".equals(role)) {
                    wrp = new WebResourcePermission(qurl, (String)null);
                } else {
                    Set<String> methods = roleMethods.getValue();
                    httpMethods = new String[methods.size()];
                    methods.toArray(httpMethods);
                    wrp = new WebResourcePermission(qurl, httpMethods);
                }
                pc.addToRole(role, (Permission)wrp);
                if (httpMethods == null) continue;
                String pattern = info.pattern;
                String methodsAsString = "!" + WebPermissionMapping.getCommaSeparatedString(httpMethods);
                WebResourcePermission wrpUnchecked = null;
                try {
                    wrpUnchecked = new WebResourcePermission(pattern, methodsAsString);
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException("Could not create resource permission with pattern \"" + pattern + "\" and methods: " + methodsAsString, iae);
                }
                pc.addToUncheckedPolicy((Permission)wrpUnchecked);
            }
            String[] missingHttpMethods = info.getMissingMethods();
            if (missingHttpMethods.length > 0) {
                WebResourcePermission wrp = new WebResourcePermission(qurl, missingHttpMethods);
                pc.addToUncheckedPolicy((Permission)wrp);
            } else {
                pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
            }
            if (info.isMissingAuthConstraint) {
                pc.addToUncheckedPolicy((Permission)new WebResourcePermission(qurl, (String)null));
            }
            Iterator<Map.Entry<String, Set<String>>> transportContraints = info.getTransportMethods();
            while (transportContraints.hasNext()) {
                Map.Entry<String, Set<String>> transportMethods = transportContraints.next();
                String transport = transportMethods.getKey();
                Set<String> methods = transportMethods.getValue();
                httpMethods = new String[methods.size()];
                methods.toArray(httpMethods);
                WebUserDataPermission wudp = new WebUserDataPermission(qurl, httpMethods, transport);
                pc.addToUncheckedPolicy((Permission)wudp);
                if ("NONE".equals(transport)) {
                    WebUserDataPermission wudp1 = new WebUserDataPermission(info.pattern, null);
                    pc.addToUncheckedPolicy((Permission)wudp1);
                    continue;
                }
                if (httpMethods == null) continue;
                WebUserDataPermission wudpNonNull = new WebUserDataPermission(info.pattern, "!" + WebPermissionMapping.getCommaSeparatedString(httpMethods));
                pc.addToUncheckedPolicy((Permission)wudpNonNull);
            }
        }
        JBossServletsMetaData servlets = metaData.getServlets();
        for (JBossServletMetaData servlet : servlets) {
            String servletName = servlet.getServletName();
            SecurityRoleRefsMetaData roleRefs = servlet.getSecurityRoleRefs();
            Set unreferencedRoles = metaData.getSecurityRoleNames();
            if (roleRefs != null) {
                for (SecurityRoleRefMetaData roleRef : roleRefs) {
                    String roleName = roleRef.getRoleLink();
                    WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, roleRef.getName());
                    pc.addToRole(roleName, (Permission)wrrp);
                    wrrp = new WebRoleRefPermission(servletName, roleName);
                    pc.addToRole(roleRef.getName(), (Permission)wrrp);
                    unreferencedRoles.remove(roleName);
                }
            }
            if (unreferencedRoles == null) continue;
            for (String unrefRole : unreferencedRoles) {
                WebRoleRefPermission unrefP = new WebRoleRefPermission(servletName, unrefRole);
                pc.addToRole(unrefRole, (Permission)unrefP);
            }
        }
        Set unreferencedRoles = metaData.getSecurityRoleNames();
        if (unreferencedRoles != null) {
            for (String unreferencedRole : unreferencedRoles) {
                WebRoleRefPermission wrrep = new WebRoleRefPermission("", unreferencedRole);
                pc.addToRole(unreferencedRole, (Permission)wrrep);
            }
        }
        if ((servletNames = servlets.keySet()) != null) {
            for (String servletName : servletNames) {
                if (unreferencedRoles == null) continue;
                for (String role : unreferencedRoles) {
                    WebRoleRefPermission wrrp = new WebRoleRefPermission(servletName, role);
                    pc.addToRole(role, (Permission)wrrp);
                }
            }
        }
        if (unreferencedRoles != null) {
            for (String role : unreferencedRoles) {
                WebRoleRefPermission wrrp = new WebRoleRefPermission("", role);
                pc.addToRole(role, (Permission)wrrp);
            }
        }
    }

    static String getCommaSeparatedString(String[] str) {
        int len = str.length;
        Arrays.sort(str);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(str[i]);
        }
        return buf.toString();
    }

    static int getPatternType(String urlPattern) {
        int type = 4;
        if (urlPattern.startsWith("*.")) {
            type = 2;
        } else if (urlPattern.startsWith("/") && urlPattern.endsWith("/*")) {
            type = 1;
        } else if (urlPattern.equals("/")) {
            type = 3;
        }
        return type;
    }

    static HashMap<String, PatternInfo> qualifyURLPatterns(JBossWebMetaData metaData) {
        PatternInfo other;
        PatternInfo info3;
        int i;
        ArrayList<PatternInfo> prefixList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> extensionList = new ArrayList<PatternInfo>();
        ArrayList<PatternInfo> exactList = new ArrayList<PatternInfo>();
        HashMap<String, PatternInfo> patternMap = new HashMap<String, PatternInfo>();
        PatternInfo defaultInfo = null;
        List constraints = metaData.getSecurityConstraints();
        if (constraints != null) {
            for (SecurityConstraintMetaData sc : constraints) {
                WebResourceCollectionsMetaData resources = sc.getResourceCollections();
                for (WebResourceCollectionMetaData wrc : resources) {
                    List urlPatterns = wrc.getUrlPatterns();
                    int length = urlPatterns != null ? urlPatterns.size() : 0;
                    block8: for (int n = 0; n < length; ++n) {
                        String url = (String)urlPatterns.get(n);
                        int type = WebPermissionMapping.getPatternType(url);
                        PatternInfo info2 = patternMap.get(url);
                        if (info2 != null) continue;
                        info2 = new PatternInfo(url, type);
                        patternMap.put(url, info2);
                        switch (type) {
                            case 1: {
                                prefixList.add(info2);
                                continue block8;
                            }
                            case 2: {
                                extensionList.add(info2);
                                continue block8;
                            }
                            case 4: {
                                exactList.add(info2);
                                continue block8;
                            }
                            case 3: {
                                defaultInfo = info2;
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < prefixList.size(); ++i) {
            int j;
            info3 = (PatternInfo)prefixList.get(i);
            for (j = 0; j < prefixList.size(); ++j) {
                if (i == j || !info3.matches(other = (PatternInfo)prefixList.get(j))) continue;
                info3.addQualifier(other);
            }
            for (j = 0; j < exactList.size(); ++j) {
                other = (PatternInfo)exactList.get(j);
                if (!info3.matches(other)) continue;
                info3.addQualifier(other);
            }
        }
        for (i = 0; i < extensionList.size(); ++i) {
            int j;
            info3 = (PatternInfo)extensionList.get(i);
            for (j = 0; j < prefixList.size(); ++j) {
                other = (PatternInfo)prefixList.get(j);
                info3.addQualifier(other);
            }
            for (j = 0; j < exactList.size(); ++j) {
                other = (PatternInfo)exactList.get(j);
                if (!info3.isExtensionFor(other)) continue;
                info3.addQualifier(other);
            }
        }
        if (defaultInfo == null) {
            defaultInfo = new PatternInfo("/", 3);
            patternMap.put("/", defaultInfo);
        }
        for (PatternInfo info3 : patternMap.values()) {
            if (info3 == defaultInfo) continue;
            defaultInfo.addQualifier(info3);
        }
        return patternMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PatternInfo {
        static final HashMap<String, Set<String>> ALL_TRANSPORTS = new HashMap();
        String pattern;
        String qpattern;
        ArrayList<PatternInfo> qualifiers = new ArrayList();
        int type;
        HashSet<String> excludedMethods;
        HashMap<String, Set<String>> roles;
        HashMap<String, Set<String>> transports;
        HashSet<String> allMethods = new HashSet();
        boolean isOverriden;
        boolean isMissingAuthConstraint;

        PatternInfo(String pattern, int type) {
            this.pattern = pattern;
            this.type = type;
        }

        void addExcludedMethods(List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.excludedMethods == null) {
                this.excludedMethods = new HashSet();
            }
            this.excludedMethods.addAll(methods);
            this.allMethods.addAll(methods);
        }

        public String[] getExcludedMethods() {
            String[] httpMethods = null;
            if (this.excludedMethods != null) {
                httpMethods = new String[this.excludedMethods.size()];
                this.excludedMethods.toArray(httpMethods);
            }
            return httpMethods;
        }

        public void addRoles(HashSet<String> mappedRoles, List<String> httpMethods) {
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            this.allMethods.addAll(methods);
            if (this.roles == null) {
                this.roles = new HashMap();
            }
            for (String role : mappedRoles) {
                Set<String> roleMethods = this.roles.get(role);
                if (roleMethods == null) {
                    roleMethods = new HashSet<String>();
                    this.roles.put(role, roleMethods);
                }
                roleMethods.addAll(methods);
            }
        }

        public Iterator<Map.Entry<String, Set<String>>> getRoleMethods() {
            HashMap<String, Set<String>> tmp = this.roles;
            if (tmp == null) {
                tmp = new HashMap(0);
            }
            Iterator<Map.Entry<String, Set<String>>> iter = tmp.entrySet().iterator();
            return iter;
        }

        void addTransport(String transport, List<String> httpMethods) {
            Set<String> transportMethods;
            Collection<String> methods = httpMethods;
            if (methods.size() == 0) {
                methods = WebResourceCollectionMetaData.ALL_HTTP_METHODS;
            }
            if (this.transports == null) {
                this.transports = new HashMap();
            }
            if ((transportMethods = this.transports.get(transport)) == null) {
                transportMethods = new HashSet<String>();
                this.transports.put(transport, transportMethods);
            }
            transportMethods.addAll(methods);
        }

        public Iterator<Map.Entry<String, Set<String>>> getTransportMethods() {
            HashMap<String, Set<String>> tmp = this.transports;
            if (tmp == null) {
                tmp = ALL_TRANSPORTS;
            }
            Iterator<Map.Entry<String, Set<String>>> iter = tmp.entrySet().iterator();
            return iter;
        }

        public String[] getMissingMethods() {
            String[] httpMethods = new String[]{};
            httpMethods = this.allMethods.size() == 0 ? WebResourceCollectionMetaData.ALL_HTTP_METHOD_NAMES : WebResourceCollectionMetaData.getMissingHttpMethods(this.allMethods);
            return httpMethods;
        }

        void addQualifier(PatternInfo info) {
            if (!this.qualifiers.contains(info)) {
                if (info.type == 1 && info.matches(this)) {
                    this.isOverriden = true;
                }
                this.qualifiers.add(info);
            }
        }

        public String getQualifiedPattern() {
            if (this.qpattern == null) {
                StringBuffer tmp = new StringBuffer(this.pattern);
                for (int n = 0; n < this.qualifiers.size(); ++n) {
                    tmp.append(':');
                    PatternInfo info = this.qualifiers.get(n);
                    tmp.append(info.pattern);
                }
                this.qpattern = tmp.toString();
            }
            return this.qpattern;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object obj) {
            PatternInfo pi = (PatternInfo)obj;
            return this.pattern.equals(pi.pattern);
        }

        public boolean matches(PatternInfo other) {
            int matchLength = this.pattern.length() - 2;
            boolean matches = this.pattern.regionMatches(0, other.pattern, 0, matchLength);
            return matches;
        }

        public boolean isExtensionFor(PatternInfo other) {
            int offset = other.pattern.lastIndexOf(46);
            int length = this.pattern.length() - 1;
            boolean isExtensionFor = false;
            if (offset > 0) {
                isExtensionFor = this.pattern.regionMatches(1, other.pattern, offset, length);
            }
            return isExtensionFor;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer("PatternInfo[");
            tmp.append("pattern=");
            tmp.append(this.pattern);
            tmp.append(",type=");
            tmp.append(this.type);
            tmp.append(",isOverriden=");
            tmp.append(this.isOverriden);
            tmp.append(",qualifiers=");
            tmp.append(this.qualifiers);
            tmp.append("]");
            return tmp.toString();
        }

        static {
            ALL_TRANSPORTS.put("NONE", WebResourceCollectionMetaData.ALL_HTTP_METHODS);
        }
    }
}

