/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.ScanningMetaData;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.web.deployers.HandlesTypesClassFilter;
import org.jboss.web.deployers.MergedJBossWebMetaDataDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContainerInitializerDeployer
extends AbstractDeployer {
    public static final String SCI_ATTACHMENT_NAME = "sci." + WebMetaData.class.getName();
    public static final String SCI_HANDLESTYPES_ATTACHMENT_NAME = "sci.handlestypes." + WebMetaData.class.getName();
    private List<URL> sciJars = null;

    public List<URL> getSciJars() {
        return this.sciJars;
    }

    public void setSciJars(List<URL> sciJars) {
        this.sciJars = sciJars;
    }

    public ServletContainerInitializerDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.setInput(JBossWebMetaData.class);
        this.addInput(ScanningMetaData.class);
        this.addInput(MergedJBossWebMetaDataDeployer.WEB_ORDER_ATTACHMENT_NAME);
        this.addInput(MergedJBossWebMetaDataDeployer.WEB_SCIS_ATTACHMENT_NAME);
        this.addOutput(SCI_ATTACHMENT_NAME);
        this.addOutput(SCI_HANDLESTYPES_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (!unit.getSimpleName().endsWith(".war")) {
            return;
        }
        HashSet<ServletContainerInitializer> scis = new HashSet<ServletContainerInitializer>();
        if (this.sciJars == null) {
            ServiceLoader<ServletContainerInitializer> serviceLoader = ServiceLoader.load(ServletContainerInitializer.class, ((Object)((Object)this)).getClass().getClassLoader());
            for (ServletContainerInitializer service : serviceLoader) {
                scis.add(service);
            }
        } else {
            for (URL jarURL : this.sciJars) {
                try {
                    ServletContainerInitializer service;
                    VFS vfs = VFS.getVFS((URL)jarURL);
                    VirtualFile sci = vfs.getChild("META-INF/services/javax.servlet.ServletContainerInitializer");
                    if (sci == null || (service = this.loadSci(unit, sci, jarURL.getPath(), false)) == null) continue;
                    scis.add(service);
                }
                catch (IOException e) {
                    DeploymentException.rethrowAsDeploymentException((String)("Deployment error processing SCI for JAR: " + jarURL), (Throwable)e);
                }
            }
        }
        List order = (List)unit.getAttachment(MergedJBossWebMetaDataDeployer.WEB_ORDER_ATTACHMENT_NAME);
        Map localScis = (Map)unit.getAttachment(MergedJBossWebMetaDataDeployer.WEB_SCIS_ATTACHMENT_NAME);
        if (order != null && localScis != null) {
            for (String jar : order) {
                ServletContainerInitializer service;
                VirtualFile sci = (VirtualFile)localScis.get(jar);
                if (sci == null || (service = this.loadSci(unit, sci, jar, true)) == null) continue;
                scis.add(service);
            }
        }
        HashMap typesMap = new HashMap();
        HashMap handlesTypes = new HashMap();
        for (ServletContainerInitializer service : scis) {
            HandlesTypes handlesTypesAnnotation;
            Class[] typesArray;
            if (!service.getClass().isAnnotationPresent(HandlesTypes.class) || (typesArray = (handlesTypesAnnotation = service.getClass().getAnnotation(HandlesTypes.class)).value()) == null) continue;
            for (Class type : typesArray) {
                HashSet<ServletContainerInitializer> servicesSet = (HashSet<ServletContainerInitializer>)typesMap.get(type);
                if (servicesSet == null) {
                    servicesSet = new HashSet<ServletContainerInitializer>();
                    typesMap.put(type, servicesSet);
                }
                servicesSet.add(service);
                handlesTypes.put(service, new HashSet());
            }
        }
        ScanningMetaData scanningMetaData = (ScanningMetaData)unit.getAttachment(ScanningMetaData.class);
        Class[] typesArray = typesMap.keySet().toArray(new Class[0]);
        if (typesArray.length > 0 && unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
            List classpath = vfsUnit.getClassPath();
            try {
                for (VirtualFile classpathItem : classpath) {
                    if (scanningMetaData != null && (scanningMetaData.getPaths() == null || !scanningMetaData.getPaths().contains(classpathItem.getName()))) continue;
                    HandlesTypesClassFilter classVisitor = new HandlesTypesClassFilter(vfsUnit, unit.getClassLoader(), classpathItem, typesArray, typesMap, handlesTypes);
                    classpathItem.visit((VirtualFileVisitor)classVisitor);
                }
            }
            catch (Exception e) {
                DeploymentException.rethrowAsDeploymentException((String)"Deployment error scanning HandlesTypes", (Throwable)e);
            }
        }
        unit.addAttachment(SCI_ATTACHMENT_NAME, scis);
        unit.addAttachment(SCI_HANDLESTYPES_ATTACHMENT_NAME, handlesTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletContainerInitializer loadSci(DeploymentUnit unit, VirtualFile sci, String jar, boolean error) throws DeploymentException {
        ServletContainerInitializer service = null;
        InputStream is = null;
        try {
            is = sci.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String servletContainerInitializerClassName = reader.readLine();
            int pos = servletContainerInitializerClassName.indexOf(35);
            if (pos > 0) {
                servletContainerInitializerClassName = servletContainerInitializerClassName.substring(0, pos);
            }
            servletContainerInitializerClassName = servletContainerInitializerClassName.trim();
            service = (ServletContainerInitializer)unit.getClassLoader().loadClass(servletContainerInitializerClassName).newInstance();
        }
        catch (Exception e) {
            if (error) {
                DeploymentException.rethrowAsDeploymentException((String)("Deployment error processing SCI for JAR: " + jar), (Throwable)e);
            } else {
                this.log.info((Object)("Skipped SCI for JAR: " + jar), (Throwable)e);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return service;
    }
}

