/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.deployers.WebModuleMBean;

public class WebModule
implements WebModuleMBean {
    private static Logger log = Logger.getLogger(WebModule.class);
    private DeploymentUnit unit;
    private AbstractWarDeployer container;
    private AbstractWarDeployment deployment;

    public WebModule(DeploymentUnit unit, AbstractWarDeployer container, AbstractWarDeployment deployment) {
        this.unit = unit;
        this.container = container;
        this.deployment = deployment;
        this.deployment.setDeploymentUnit(unit);
    }

    public void setKernel(Kernel kernel) {
        this.deployment.setKernel(kernel);
    }

    public void setPolicyRegistration(PolicyRegistration policyRegistration) {
        this.deployment.setPolicyRegistration(policyRegistration);
    }

    public void setSecurityManagement(ISecurityManagement securityManagement) {
        this.deployment.setSecurityManagement(securityManagement);
    }

    public void create() {
    }

    public void start() throws Exception {
        this.startModule();
    }

    public void stop() throws Exception {
        this.stopModule();
    }

    public void destroy() {
        this.unit = null;
        this.container = null;
        this.deployment = null;
    }

    public synchronized void startModule() throws Exception {
        JBossWebMetaData metaData = (JBossWebMetaData)this.unit.getAttachment(JBossWebMetaData.class);
        WebApplication webApp = this.deployment.start(this.unit, metaData);
        String warURL = this.unit.getName();
        this.container.addDeployedApp(warURL, webApp);
    }

    public synchronized void stopModule() throws DeploymentException {
        String warURL = this.unit.getName();
        try {
            WebApplication webApp = this.container.removeDeployedApp(warURL);
            if (this.deployment != null && webApp != null) {
                this.deployment.stop(this.unit, webApp);
            } else {
                log.debug((Object)("Failed to find deployer/deployment for war: " + warURL));
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Error during stop", (Throwable)e);
        }
    }
}

