/*
 * Decompiled with CFR 0.152.
 */
package org.jboss;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.bootstrap.api.as.server.JBossASServer;

public class Shutdown {
    public static final String PROGRAM_NAME = System.getProperty("program.name", "shutdown");
    public static final String DEFAULT_BASEURL = "service:jmx:rmi:///jndi/rmi://";
    public static final String DEFAULT_RMIOBJECTNAME = "/jmxrmi";
    public static final String DEFAULT_JMXSERVICEURL = "service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_PORT = "1090";

    protected static void displayUsage() {
        System.out.println("A JMX client to shutdown (exit or halt) a remote JBoss server.");
        System.out.println();
        System.out.println("usage: " + PROGRAM_NAME + " [options] <operation>");
        System.out.println();
        System.out.println("options:");
        System.out.println("    -h, --help                Show this help message (default)");
        System.out.println("    -D<name>[=<value>]        Set a system property");
        System.out.println("    --                        Stop processing options");
        System.out.println("    -s, --server=<url>        The JMX service URL of the remote server (e.g. service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi) ");
        System.out.println("    -o, --host=<HOSTNAME>     The name of the remote server (e.g. localhost) ");
        System.out.println("    -r, --port=<PORTNUMBER>   The rmiRegistryPort of the remote server (e.g. 1090) ");
        System.out.println("    -n, --serverName=<url>    Specify the JMX name of the ServerImpl");
        System.out.println("    -a, --adapter=<name>      Specify JNDI name of the MBeanServerConnection to use");
        System.out.println("    -u, --user=<name>         Specify the username for authentication");
        System.out.println("    -p, --password=<name>     Specify the password for authentication");
        System.out.println("    -v, --verbose             Be noisy");
        System.out.println();
        System.out.println("operations:");
        System.out.println("    -S, --shutdown            Shutdown the server");
        System.out.println();
        System.out.println("for convenience, you can specify --host and --port but not with the --server=<url> which overrides host + port. ");
    }

    public static void main(String[] args) throws Exception {
        int code;
        if (args.length == 0) {
            Shutdown.displayUsage();
            System.exit(0);
        }
        String sopts = "-:hD:s:n:a:u:p:S::v::o:r:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("server", 1, null, 115), new LongOpt("adapter", 1, null, 97), new LongOpt("serverName", 1, null, 110), new LongOpt("shutdown", 0, null, 83), new LongOpt("user", 1, null, 117), new LongOpt("verbose", 0, null, 118), new LongOpt("password", 1, null, 112), new LongOpt("host", 1, null, 111), new LongOpt("port", 1, null, 114)};
        Getopt getopt = new Getopt(PROGRAM_NAME, args, sopts, lopts);
        String serverURL = null;
        String username = null;
        String password = null;
        ObjectName serverJMXName = new ObjectName("jboss.system:type=Server");
        String hostname = null;
        String port = null;
        boolean verbose = false;
        while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: 
                case 63: {
                    System.exit(1);
                    break;
                }
                case 1: {
                    System.err.println(PROGRAM_NAME + ": unused non-option argument: " + getopt.getOptarg());
                    break;
                }
                case 104: {
                    Shutdown.displayUsage();
                    System.exit(0);
                    break;
                }
                case 68: {
                    String value;
                    String name;
                    String arg = getopt.getOptarg();
                    int i = arg.indexOf("=");
                    if (i == -1) {
                        name = arg;
                        value = "true";
                    } else {
                        name = arg.substring(0, i);
                        value = arg.substring(i + 1, arg.length());
                    }
                    System.setProperty(name, value);
                    break;
                }
                case 115: {
                    serverURL = getopt.getOptarg();
                    break;
                }
                case 110: {
                    serverJMXName = new ObjectName(getopt.getOptarg());
                    break;
                }
                case 83: {
                    break;
                }
                case 97: {
                    String adapterName = getopt.getOptarg();
                    System.out.println("adapter name is ignored " + adapterName);
                    break;
                }
                case 117: {
                    username = getopt.getOptarg();
                    break;
                }
                case 112: {
                    password = getopt.getOptarg();
                    break;
                }
                case 111: {
                    hostname = getopt.getOptarg();
                    break;
                }
                case 114: {
                    port = getopt.getOptarg();
                    break;
                }
                case 118: {
                    verbose = true;
                }
            }
        }
        if (username != null && password == null) {
            System.out.print("Enter password for " + username + ": ");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            password = br.readLine();
        }
        if (serverURL == null) {
            serverURL = DEFAULT_BASEURL + (hostname != null ? hostname : DEFAULT_HOSTNAME) + ":" + (port != null ? port : DEFAULT_PORT) + DEFAULT_RMIOBJECTNAME;
        }
        if (verbose) {
            System.out.println("JMX server url=" + serverURL);
        }
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (username != null && password != null) {
            if (verbose) {
                System.out.println("will connect with username=" + username);
            }
            String[] creds = new String[]{username, password};
            env.put("jmx.remote.credentials", creds);
        }
        JMXServiceURL url = new JMXServiceURL(serverURL);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
        MBeanServerConnection adaptor = jmxc.getMBeanServerConnection();
        ServerProxyHandler handler = new ServerProxyHandler(adaptor, serverJMXName);
        Class[] ifaces = new Class[]{JBossASServer.class};
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        JBossASServer server = (JBossASServer)Proxy.newProxyInstance(tcl, ifaces, (InvocationHandler)handler);
        server.shutdown();
        System.out.println("Shutdown message has been posted to the server.");
        System.out.println("Server shutdown may take a while - check logfiles for completion");
    }

    private static class ServerProxyHandler
    implements InvocationHandler {
        ObjectName serverName;
        MBeanServerConnection server;

        ServerProxyHandler(MBeanServerConnection server, ObjectName serverName) {
            this.server = server;
            this.serverName = serverName;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?>[] sigTypes = method.getParameterTypes();
            ArrayList<String> sigStrings = new ArrayList<String>();
            for (int s = 0; s < sigTypes.length; ++s) {
                sigStrings.add(sigTypes[s].getName());
            }
            String[] sig = new String[sigTypes.length];
            sigStrings.toArray(sig);
            Object value = null;
            try {
                value = this.server.invoke(this.serverName, methodName, args, sig);
            }
            catch (UndeclaredThrowableException e) {
                System.out.println("getUndeclaredThrowable: " + e.getUndeclaredThrowable());
                throw e.getUndeclaredThrowable();
            }
            return value;
        }
    }
}

