/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.inflow;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.plugins.inflow.GetTCLAction;
import org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactory;
import org.jboss.ejb.plugins.inflow.SetTCLAction;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;
import org.jboss.proxy.Interceptor;

public class MessageEndpointInterceptor
extends Interceptor {
    private static final long serialVersionUID = -8740717288847385688L;
    private static final Logger log = Logger.getLogger(MessageEndpointInterceptor.class);
    public static final String MESSAGE_ENDPOINT_FACTORY = "MessageEndpoint.Factory";
    public static final String MESSAGE_ENDPOINT_XARESOURCE = "MessageEndpoint.XAResource";
    private boolean trace = log.isTraceEnabled();
    private String cachedProxyString = null;
    protected AtomicBoolean released = new AtomicBoolean(false);
    protected AtomicBoolean delivered = new AtomicBoolean(false);
    protected Thread inUseThread = null;
    protected ClassLoader oldClassLoader = null;
    protected Transaction transaction = null;
    protected Transaction suspended = null;
    protected boolean beforeDeliveryInvoked = false;
    private JBossMessageEndpointFactory endpointFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Throwable {
        if (this.released.get()) {
            throw new IllegalStateException("This message endpoint + " + this.getProxyString(mi) + " has been released");
        }
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            Thread currentThread = Thread.currentThread();
            if (this.inUseThread != null && !this.inUseThread.equals(currentThread)) {
                throw new IllegalStateException("This message endpoint + " + this.getProxyString(mi) + " is already in use by another thread " + this.inUseThread);
            }
            this.inUseThread = currentThread;
        }
        String method = mi.getMethod().getName();
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " in use by " + method + " " + this.inUseThread));
        }
        if (method.equals("release")) {
            this.release(mi);
            return null;
        }
        if (method.equals("beforeDelivery")) {
            this.before(mi);
            return null;
        }
        if (method.equals("afterDelivery")) {
            this.after(mi);
            return null;
        }
        return this.delivery(mi);
    }

    protected void release(Invocation mi) throws Throwable {
        this.released.set(true);
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " released"));
        }
        if (this.getOldClassLoader() != null) {
            try {
                this.finish("release", mi, false);
            }
            catch (Throwable t) {
                log.warn((Object)"Error in release ", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void before(Invocation mi) throws Throwable {
        if (this.getBeforeDeliveryInvoke()) {
            throw new IllegalStateException("Missing afterDelivery from the previous beforeDelivery for message endpoint " + this.getProxyString(mi));
        }
        MessageDrivenContainer container = this.getContainer(mi);
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            this.oldClassLoader = GetTCLAction.getContextClassLoader(this.inUseThread);
            SetTCLAction.setContextClassLoader(this.inUseThread, container.getClassLoader());
        }
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " set context classloader to " + container.getClassLoader()));
        }
        try {
            this.startTransaction("beforeDelivery", mi, container);
            this.setBeforeDeliveryInvoke(true);
        }
        catch (Throwable t) {
            this.setBeforeDeliveryInvoke(false);
            this.resetContextClassLoader(mi);
            throw new ResourceException(t);
        }
    }

    protected void after(Invocation mi) throws Throwable {
        if (!this.getBeforeDeliveryInvoke()) {
            throw new IllegalStateException("afterDelivery without a previous beforeDelivery for message endpoint " + this.getProxyString(mi));
        }
        try {
            this.finish("afterDelivery", mi, true);
        }
        catch (Throwable t) {
            throw new ResourceException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object delivery(Invocation mi) throws Throwable {
        if (this.delivered.get()) {
            throw new IllegalStateException("Multiple message delivery between before and after delivery is not allowed for message endpoint " + this.getProxyString(mi));
        }
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " delivering"));
        }
        if (this.getOldClassLoader() != null) {
            this.delivered.set(true);
        }
        MessageDrivenContainer container = this.getContainer(mi);
        boolean commit = true;
        try {
            if (this.getOldClassLoader() == null) {
                this.startTransaction("delivery", mi, container);
            }
            Object object = this.getNext().invoke(mi);
            return object;
        }
        catch (Throwable t) {
            if (this.trace) {
                log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " delivery error"), t);
            }
            if (t instanceof Error || t instanceof RuntimeException) {
                Transaction transaction = this.getTransaction();
                if (transaction != null) {
                    transaction.setRollbackOnly();
                }
                commit = false;
            }
            throw t;
        }
        finally {
            if (this.getOldClassLoader() == null) {
                try {
                    this.endTransaction(mi, commit);
                }
                finally {
                    this.releaseThreadLock(mi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish(String context, Invocation mi, boolean commit) throws Throwable {
        try {
            this.endTransaction(mi, commit);
        }
        finally {
            this.setBeforeDeliveryInvoke(false);
            this.delivered.set(false);
            this.resetContextClassLoader(mi);
            this.releaseThreadLock(mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTransaction(String context, Invocation mi, MessageDrivenContainer container) throws Throwable {
        XAResource resource = (XAResource)mi.getInvocationContext().getValue(MESSAGE_ENDPOINT_XARESOURCE);
        Method method = null;
        method = "delivery".equals(context) ? mi.getMethod() : (Method)mi.getArguments()[0];
        boolean isTransacted = this.getMessageEndpointFactory(mi).isDeliveryTransacted(method);
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " " + context + " method=" + method + " xaResource=" + resource + " transacted=" + isTransacted));
        }
        TransactionManager tm = container.getTransactionManager();
        Transaction tx = tm.suspend();
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            this.suspended = tx;
        }
        if (this.trace) {
            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " " + context + " currentTx=" + this.suspended));
        }
        if (isTransacted) {
            if (this.suspended == null) {
                tm.begin();
                tx = tm.getTransaction();
                messageEndpointInterceptor = this;
                synchronized (messageEndpointInterceptor) {
                    this.transaction = tx;
                }
                if (this.trace) {
                    log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " started transaction=" + this.transaction));
                }
                if (resource != null) {
                    this.transaction.enlistResource(resource);
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " enlisted=" + resource));
                    }
                }
            } else {
                try {
                    tm.resume(this.suspended);
                }
                finally {
                    messageEndpointInterceptor = this;
                    synchronized (messageEndpointInterceptor) {
                        this.suspended = null;
                    }
                    if (this.trace) {
                        log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " transaction=" + this.suspended + " already active, IGNORED=" + resource));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTransaction(Invocation mi, boolean commit) throws Throwable {
        block30: {
            Object transaction;
            TransactionManager tm = null;
            Transaction currentTx = null;
            try {
                Transaction suspended;
                transaction = this.getTransaction();
                if (transaction != null) {
                    tm = this.getContainer(mi).getTransactionManager();
                    currentTx = tm.getTransaction();
                    if (currentTx != null && !currentTx.equals(transaction)) {
                        log.warn((Object)("Current transaction " + currentTx + " is not the expected transaction."));
                        tm.suspend();
                        tm.resume(transaction);
                    } else {
                        currentTx = null;
                    }
                    if (!commit || transaction.getStatus() == 1) {
                        if (this.trace) {
                            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " rollback"));
                        }
                        tm.rollback();
                    } else {
                        if (this.trace) {
                            log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " commit"));
                        }
                        tm.commit();
                    }
                }
                if ((suspended = this.getSuspended()) == null) break block30;
                try {
                    tm = this.getContainer(mi).getTransactionManager();
                    tm.resume(suspended);
                }
                finally {
                    MessageEndpointInterceptor messageEndpointInterceptor = this;
                    synchronized (messageEndpointInterceptor) {
                        this.suspended = null;
                    }
                }
            }
            finally {
                transaction = this;
                synchronized (transaction) {
                    this.transaction = null;
                }
                if (currentTx != null) {
                    try {
                        tm.resume(currentTx);
                    }
                    catch (Throwable t) {
                        log.warn((Object)("MessageEndpoint " + this.getProxyString(mi) + " failed to resume old transaction " + currentTx));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetContextClassLoader(Invocation mi) {
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            if (this.trace) {
                log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " reset classloader " + this.oldClassLoader));
            }
            SetTCLAction.setContextClassLoader(this.inUseThread, this.oldClassLoader);
            this.oldClassLoader = null;
        }
    }

    protected void setBeforeDeliveryInvoke(boolean bdi) {
        this.beforeDeliveryInvoked = bdi;
    }

    protected boolean getBeforeDeliveryInvoke() {
        return this.beforeDeliveryInvoked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseThreadLock(Invocation mi) {
        MessageEndpointInterceptor messageEndpointInterceptor = this;
        synchronized (messageEndpointInterceptor) {
            if (this.trace) {
                log.trace((Object)("MessageEndpoint " + this.getProxyString(mi) + " no longer in use by " + this.inUseThread));
            }
            this.inUseThread = null;
        }
    }

    protected String getProxyString(Invocation mi) {
        if (this.cachedProxyString == null) {
            this.cachedProxyString = mi.getInvocationContext().getCacheId().toString();
        }
        return this.cachedProxyString;
    }

    protected JBossMessageEndpointFactory getMessageEndpointFactory(Invocation mi) {
        if (this.endpointFactory == null) {
            this.endpointFactory = (JBossMessageEndpointFactory)mi.getInvocationContext().getValue(MESSAGE_ENDPOINT_FACTORY);
        }
        if (this.endpointFactory == null) {
            throw new IllegalStateException("No message endpoint factory in " + mi.getInvocationContext().context);
        }
        return this.endpointFactory;
    }

    protected MessageDrivenContainer getContainer(Invocation mi) {
        JBossMessageEndpointFactory messageEndpointFactory = this.getMessageEndpointFactory(mi);
        MessageDrivenContainer container = messageEndpointFactory.getContainer();
        if (container == null) {
            throw new IllegalStateException("No container associated with message endpoint factory: " + messageEndpointFactory.getServiceName());
        }
        return container;
    }

    protected synchronized ClassLoader getOldClassLoader() {
        return this.oldClassLoader;
    }

    protected synchronized Transaction getTransaction() {
        return this.transaction;
    }

    protected synchronized Transaction getSuspended() {
        return this.suspended;
    }
}

