/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.plugin;

import java.util.Map;
import org.jboss.deployment.dependency.ContainerDependencyMetaData;
import org.jboss.deployment.spi.DeploymentEndpointResolver;
import org.jboss.deployment.spi.EndpointInfo;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedDeploymentEndpointResolver
implements DeploymentEndpointResolver {
    private static Logger log = Logger.getLogger(MappedDeploymentEndpointResolver.class);
    private Map<String, ContainerDependencyMetaData> endpointMap;
    private Map<String, String> endpointAlternateMap;

    public MappedDeploymentEndpointResolver(Map<String, ContainerDependencyMetaData> endpointMap, Map<String, String> endpointAlternateMap, String unitPath) {
        this.endpointMap = endpointMap;
        this.endpointAlternateMap = endpointAlternateMap;
    }

    public EndpointInfo getEndpointInfo(Class businessIntf, String type, String vfsContext) {
        String altKey = "ejb/" + vfsContext + "@" + businessIntf.getName();
        String key = this.endpointAlternateMap.get(altKey);
        if (key == null) {
            altKey = "ejb@" + businessIntf.getName();
            key = this.endpointAlternateMap.get(altKey);
        }
        EndpointInfo info = null;
        if (key != null) {
            ContainerDependencyMetaData cdmd = this.endpointMap.get(key);
            info = new EndpointInfo(cdmd.getDeploymentPath(), cdmd.getComponentName(), type);
        }
        return info;
    }

    public EndpointInfo getEndpointInfo(String ref, String type, String vfsContext) {
        String prefix = type;
        String unitPath = vfsContext;
        String endpointName = ref;
        if (ref.indexOf(35) != -1) {
            String path = ref.substring(0, ref.indexOf(35));
            if (path.startsWith("../")) {
                String[] deploymentPaths = unitPath.split("/");
                int count = 0;
                while (path.startsWith("../")) {
                    path = path.substring(3);
                    ++count;
                }
                String rootPath = "";
                for (int n = 0; n < deploymentPaths.length - count; ++n) {
                    rootPath = rootPath + deploymentPaths + "/";
                }
                unitPath = rootPath + path;
            } else {
                unitPath = path;
            }
            endpointName = ref.substring(ref.indexOf(35) + 1);
        }
        EndpointInfo info = null;
        String key = prefix + "/" + unitPath + "#" + endpointName;
        ContainerDependencyMetaData cdmd = this.endpointMap.get(key);
        if (cdmd != null) {
            info = new EndpointInfo(unitPath, endpointName, type);
            return info;
        }
        if (ref.indexOf(35) == -1) {
            if (type.equals("ejb")) {
                key = "ejb/" + ref;
            } else if (type.equals("message-destination")) {
                key = "message-destination/" + ref;
            }
            String ejbCompID = this.endpointAlternateMap.get(key);
            if (ejbCompID != null) {
                cdmd = this.endpointMap.get(ejbCompID);
                if (cdmd == null) {
                    throw new IllegalStateException("endpoint mapping is corrupt, can't find '" + ejbCompID + "' in " + this.endpointMap);
                }
                info = new EndpointInfo(cdmd.getDeploymentPath(), cdmd.getComponentName(), type);
                return info;
            }
        } else {
            log.debug((Object)("Failed to find mapping for ref: " + ref + " path: " + vfsContext));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Available keys: " + this.endpointMap.keySet()));
            }
        }
        return info;
    }
}

