/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.executor;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.dependency.plugins.AbstractController;
import org.jboss.dependency.spi.ControllerContext;

public class ControllerExecutorInstaller
implements Executor {
    ControllerContext context;
    volatile Executor bootstrapExecutor;
    volatile Executor mainExecutor;

    public ControllerContext getContext() {
        return this.context;
    }

    public void setContext(ControllerContext context) {
        this.context = context;
    }

    public Executor getBootstrapExecutor() {
        return this.bootstrapExecutor;
    }

    public void setBootstrapExecutor(Executor executor) {
        this.bootstrapExecutor = executor;
    }

    public Executor getMainExecutor() {
        return this.mainExecutor;
    }

    public void setMainExecutor(Executor mainExecutor) {
        this.mainExecutor = mainExecutor;
    }

    public void start() {
        ((AbstractController)this.context.getController()).setExecutor((Executor)this);
    }

    public void stop() {
        ((AbstractController)this.context.getController()).setExecutor(null);
    }

    public void execute(Runnable command) {
        Executor exec = this.mainExecutor;
        if (exec != null) {
            exec.execute(command);
            return;
        }
        exec = this.bootstrapExecutor;
        if (exec != null) {
            exec.execute(command);
            return;
        }
        throw new RejectedExecutionException("No executor available in " + this.getClass().getName());
    }
}

