/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.deployment.AnnotationMetaDataDeployer;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.IdMetaDataImpl;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AbsoluteOrderingMetaData;
import org.jboss.metadata.web.spec.OrderingElementMetaData;
import org.jboss.metadata.web.spec.Web25MetaData;
import org.jboss.metadata.web.spec.Web30MetaData;
import org.jboss.metadata.web.spec.WebCommonMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedJBossWebMetaDataDeployer
extends AbstractDeployer {
    public static final String WEB_ORDER_ATTACHMENT_NAME = "order." + WebMetaData.class.getName();
    public static final String WEB_NOORDER_ATTACHMENT_NAME = "noOrder." + WebMetaData.class.getName();
    public static final String WEB_OVERLAYS_ATTACHMENT_NAME = "overlays." + WebMetaData.class.getName();
    public static final String WEB_SCIS_ATTACHMENT_NAME = "localscis." + WebMetaData.class.getName();
    private boolean metaDataCompleteIsDefault = false;

    public boolean isMetaDataCompleteIsDefault() {
        return this.metaDataCompleteIsDefault;
    }

    public void setMetaDataCompleteIsDefault(boolean metaDataCompleteIsDefault) {
        this.metaDataCompleteIsDefault = metaDataCompleteIsDefault;
    }

    public MergedJBossWebMetaDataDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        this.addInput(WebMetaData.class);
        this.addInput(JBossWebMetaData.class);
        this.addInput(AnnotationMetaDataDeployer.WEB_ANNOTATED_ATTACHMENT_NAME);
        this.setOutput(JBossWebMetaData.class);
        this.addOutput(WEB_ORDER_ATTACHMENT_NAME);
        this.addOutput(WEB_OVERLAYS_ATTACHMENT_NAME);
        this.addOutput(WEB_SCIS_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        WebMetaData jarAnnotatedMetaData;
        WebFragmentMetaData webFragmentMetaData;
        String key;
        WebMetaData webMetaData;
        WebMetaData specMetaData = (WebMetaData)unit.getAttachment(WebMetaData.class);
        JBossWebMetaData metaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (specMetaData == null && metaData == null) {
            return;
        }
        boolean isComplete = this.isMetaDataCompleteIsDefault();
        if (specMetaData != null) {
            isComplete = specMetaData instanceof Web25MetaData ? (isComplete |= ((Web25MetaData)specMetaData).isMetadataComplete()) : (specMetaData instanceof Web30MetaData ? (isComplete |= ((Web30MetaData)specMetaData).isMetadataComplete()) : true);
        }
        LinkedList<String> order = new LinkedList<String>();
        ArrayList<WebOrdering> orderings = new ArrayList<WebOrdering>();
        HashSet<String> jarsSet = new HashSet<String>();
        HashSet<VirtualFile> overlays = new HashSet<VirtualFile>();
        HashMap<String, VirtualFile> scis = new HashMap<String, VirtualFile>();
        VirtualFile webInfLib = null;
        boolean fragmentFound = false;
        HashMap<String, WebFragmentMetaData> webFragments = new HashMap<String, WebFragmentMetaData>();
        if (unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
            webInfLib = vfsUnit.getFile("WEB-INF/lib");
            if (webInfLib != null) {
                List jars = webInfLib.getChildren();
                for (VirtualFile virtualFile : jars) {
                    VirtualFile sci;
                    jarsSet.add(virtualFile.getName());
                    VirtualFile overlay = virtualFile.getChild("META-INF/resources");
                    if (overlay.exists()) {
                        overlays.add(overlay);
                    }
                    if (!(sci = virtualFile.getChild("META-INF/services/javax.servlet.ServletContainerInitializer")).exists()) continue;
                    scis.put(virtualFile.getName(), sci);
                }
            }
            if (!isComplete) {
                String base = unit.getName();
                int pos = base.indexOf(58);
                if (pos > 0) {
                    base = base.substring(pos);
                }
                Iterator iterator = unit.getAttachments().keySet().iterator();
                HashSet<String> jarsWithoutFragmentsSet = new HashSet<String>();
                jarsWithoutFragmentsSet.addAll(jarsSet);
                while (iterator.hasNext()) {
                    String location = (String)iterator.next();
                    Object attachement = unit.getAttachment(location);
                    if (attachement == null || !(attachement instanceof WebFragmentMetaData) || !location.startsWith(WebFragmentMetaData.class.getName() + ":")) continue;
                    String relativeLocation = "/" + location.substring(WebFragmentMetaData.class.getName().length() + 1);
                    String jarName = null;
                    if (relativeLocation.startsWith("/WEB-INF/lib/") && (pos = (jarName = relativeLocation.substring("/WEB-INF/lib/".length())).indexOf(47)) > 0) {
                        jarName = jarName.substring(0, pos);
                    }
                    if (jarName == null) continue;
                    fragmentFound = true;
                    WebFragmentMetaData fragmentMetaData = (WebFragmentMetaData)attachement;
                    webFragments.put(jarName, fragmentMetaData);
                    WebOrdering webOrdering = new WebOrdering();
                    webOrdering.setName(fragmentMetaData.getName());
                    webOrdering.setJar(jarName);
                    jarsWithoutFragmentsSet.remove(jarName);
                    if (fragmentMetaData.getOrdering() != null) {
                        if (fragmentMetaData.getOrdering().getAfter() != null) {
                            for (OrderingElementMetaData orderingElementMetaData : fragmentMetaData.getOrdering().getAfter().getOrdering()) {
                                if (orderingElementMetaData.isOthers()) {
                                    webOrdering.setAfterOthers(true);
                                    continue;
                                }
                                webOrdering.addAfter(orderingElementMetaData.getName());
                            }
                        }
                        if (fragmentMetaData.getOrdering().getBefore() != null) {
                            for (OrderingElementMetaData orderingElementMetaData : fragmentMetaData.getOrdering().getBefore().getOrdering()) {
                                if (orderingElementMetaData.isOthers()) {
                                    webOrdering.setBeforeOthers(true);
                                    continue;
                                }
                                webOrdering.addBefore(orderingElementMetaData.getName());
                            }
                        }
                    }
                    orderings.add(webOrdering);
                }
                for (String jarName : jarsWithoutFragmentsSet) {
                    WebOrdering ordering = new WebOrdering();
                    ordering.setJar(jarName);
                    orderings.add(ordering);
                }
            }
        }
        if (!fragmentFound) {
            orderings.clear();
        }
        AbsoluteOrderingMetaData absoluteOrderingMetaData = null;
        if (!isComplete && specMetaData instanceof Web30MetaData) {
            absoluteOrderingMetaData = ((Web30MetaData)specMetaData).getAbsoluteOrdering();
        }
        if (absoluteOrderingMetaData != null) {
            int otherPos = -1;
            int i = 0;
            for (OrderingElementMetaData orderingElementMetaData : absoluteOrderingMetaData.getOrdering()) {
                if (orderingElementMetaData.isOthers()) {
                    if (otherPos >= 0) {
                        throw new DeploymentException("Duplicate others in absolute ordering");
                    }
                    otherPos = i;
                } else {
                    boolean found = false;
                    for (WebOrdering ordering : orderings) {
                        if (!orderingElementMetaData.getName().equals(ordering.getName())) continue;
                        order.add(ordering.getJar());
                        jarsSet.remove(ordering.getJar());
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new DeploymentException("Could not resolve name in absolute ordering: " + orderingElementMetaData.getName());
                    }
                }
                ++i;
            }
            if (otherPos >= 0) {
                order.addAll(otherPos, jarsSet);
                jarsSet.clear();
            }
        } else if (orderings.size() > 0) {
            try {
                MergedJBossWebMetaDataDeployer.resolveOrder(orderings, order);
            }
            catch (IllegalStateException e) {
                DeploymentException.rethrowAsDeploymentException((String)"Invalid ordering", (Throwable)e);
            }
            jarsSet.clear();
        } else {
            order.addAll(jarsSet);
            jarsSet.clear();
            unit.addAttachment(WEB_NOORDER_ATTACHMENT_NAME, (Object)Boolean.TRUE);
        }
        if (this.log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Resolved order: [ ");
            for (String string : order) {
                builder.append(string).append(' ');
            }
            builder.append(']');
            this.log.debug((Object)builder.toString());
        }
        unit.addAttachment(WEB_ORDER_ATTACHMENT_NAME, order);
        unit.addAttachment(WEB_OVERLAYS_ATTACHMENT_NAME, overlays);
        unit.addAttachment(WEB_SCIS_ATTACHMENT_NAME, scis);
        WebCommonMetaData mergedFragmentMetaData = new WebCommonMetaData();
        if (specMetaData == null) {
            specMetaData = new WebMetaData();
        }
        if ((webMetaData = (WebMetaData)unit.getAttachment(key = AnnotationMetaDataDeployer.WEB_ANNOTATED_ATTACHMENT_NAME + ":classes", WebMetaData.class)) != null) {
            if (isComplete) {
                webMetaData.setFilters(null);
                webMetaData.setFilterMappings(null);
                webMetaData.setListeners(null);
                webMetaData.setServlets(null);
                webMetaData.setServletMappings(null);
            }
            specMetaData.augment((WebCommonMetaData)webMetaData, null, true);
        }
        for (String jar : order) {
            webFragmentMetaData = (WebFragmentMetaData)webFragments.get(jar);
            if (webFragmentMetaData == null) {
                webFragmentMetaData = new WebFragmentMetaData();
                webFragmentMetaData.setDistributable(new EmptyMetaData());
            }
            key = AnnotationMetaDataDeployer.WEB_ANNOTATED_ATTACHMENT_NAME + ":" + jar;
            jarAnnotatedMetaData = (WebMetaData)unit.getAttachment(key, WebMetaData.class);
            if ((isComplete || webFragmentMetaData.isMetadataComplete()) && jarAnnotatedMetaData != null) {
                jarAnnotatedMetaData.setFilters(null);
                jarAnnotatedMetaData.setFilterMappings(null);
                jarAnnotatedMetaData.setListeners(null);
                jarAnnotatedMetaData.setServlets(null);
                jarAnnotatedMetaData.setServletMappings(null);
            }
            if (jarAnnotatedMetaData != null) {
                webFragmentMetaData.augment((WebCommonMetaData)jarAnnotatedMetaData, null, true);
            }
            try {
                mergedFragmentMetaData.augment((WebCommonMetaData)webFragmentMetaData, (WebCommonMetaData)specMetaData, false);
            }
            catch (Exception e) {
                DeploymentException.rethrowAsDeploymentException((String)("Deployment error processing fragment for JAR: " + jar), (Throwable)e);
            }
        }
        for (String jar : jarsSet) {
            webFragmentMetaData = new WebFragmentMetaData();
            webFragmentMetaData.setDistributable(new EmptyMetaData());
            key = AnnotationMetaDataDeployer.WEB_ANNOTATED_ATTACHMENT_NAME + ":" + jar;
            jarAnnotatedMetaData = (WebMetaData)unit.getAttachment(key, WebMetaData.class);
            if (jarAnnotatedMetaData != null) {
                jarAnnotatedMetaData.setFilters(null);
                jarAnnotatedMetaData.setFilterMappings(null);
                jarAnnotatedMetaData.setListeners(null);
                jarAnnotatedMetaData.setServlets(null);
                jarAnnotatedMetaData.setServletMappings(null);
            }
            if (jarAnnotatedMetaData != null) {
                webFragmentMetaData.augment((WebCommonMetaData)jarAnnotatedMetaData, null, true);
            }
            try {
                mergedFragmentMetaData.augment((WebCommonMetaData)webFragmentMetaData, (WebCommonMetaData)specMetaData, false);
            }
            catch (Exception e) {
                DeploymentException.rethrowAsDeploymentException((String)("Deployment error processing fragment for JAR: " + jar), (Throwable)e);
            }
        }
        specMetaData.augment(mergedFragmentMetaData, null, true);
        JBossWebMetaData mergedMetaData = new JBossWebMetaData();
        mergedMetaData.merge(metaData, specMetaData);
        DeploymentUnit topUnit = unit.getTopLevel();
        if (topUnit != null && topUnit.getAttachment(JBossAppMetaData.class) != null) {
            SecurityRolesMetaData earSecurityRolesMetaData;
            JBossAppMetaData earMetaData = (JBossAppMetaData)topUnit.getAttachment(JBossAppMetaData.class);
            String securityDomain = earMetaData.getSecurityDomain();
            if (securityDomain != null && mergedMetaData.getSecurityDomain() == null) {
                mergedMetaData.setSecurityDomain(securityDomain);
            }
            if ((earSecurityRolesMetaData = earMetaData.getSecurityRoles()) != null) {
                SecurityRolesMetaData mergedSecurityRolesMetaData = mergedMetaData.getSecurityRoles();
                if (mergedSecurityRolesMetaData == null) {
                    mergedMetaData.setSecurityRoles(earSecurityRolesMetaData);
                }
                if (mergedSecurityRolesMetaData != null) {
                    mergedSecurityRolesMetaData.merge((IdMetaDataImpl)mergedSecurityRolesMetaData, (IdMetaDataImpl)earSecurityRolesMetaData);
                }
            }
        }
        unit.getTransientManagedObjects().addAttachment(JBossWebMetaData.class, (Object)mergedMetaData);
    }

    protected static void resolveOrder(List<WebOrdering> webOrderings, List<String> order) {
        ArrayList<Ordering> work = new ArrayList<Ordering>();
        for (WebOrdering webOrdering : webOrderings) {
            Ordering ordering = new Ordering();
            ordering.ordering = webOrdering;
            ordering.afterOthers = webOrdering.isAfterOthers();
            ordering.beforeOthers = webOrdering.isBeforeOthers();
            if (ordering.afterOthers && ordering.beforeOthers) {
                throw new IllegalStateException("Ordering includes both before and after others in JAR: " + webOrdering.getJar());
            }
            work.add(ordering);
        }
        for (Ordering ordering : work) {
            WebOrdering webOrdering = ordering.ordering;
            for (String name : webOrdering.getAfter()) {
                Iterator workIterator2 = work.iterator();
                boolean found = false;
                while (workIterator2.hasNext()) {
                    Ordering ordering2 = (Ordering)workIterator2.next();
                    if (!name.equals(ordering2.ordering.getName())) continue;
                    if (found) {
                        throw new IllegalStateException("Duplicate name declared in JAR: " + webOrdering.getJar());
                    }
                    ordering.addAfter(ordering2);
                    ordering2.addBefore(ordering);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException("Unknown name declared in JAR: " + webOrdering.getJar());
            }
            for (String name : webOrdering.getBefore()) {
                Iterator workIterator2 = work.iterator();
                boolean found = false;
                while (workIterator2.hasNext()) {
                    Ordering ordering2 = (Ordering)workIterator2.next();
                    if (!name.equals(ordering2.ordering.getName())) continue;
                    if (found) {
                        throw new IllegalStateException("Duplicate name declared in JAR: " + webOrdering.getJar());
                    }
                    ordering.addBefore(ordering2);
                    ordering2.addAfter(ordering);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException("Unknown name declared in JAR: " + webOrdering.getJar());
            }
        }
        Iterator workIterator = work.iterator();
        while (workIterator.hasNext()) {
            ((Ordering)workIterator.next()).validate();
        }
        ArrayList<Ordering> tempOrder = new ArrayList<Ordering>();
        for (Ordering ordering : work) {
            int pos;
            int i;
            int insertAfter;
            if (ordering.beforeOthers) {
                insertAfter = -1;
                boolean last = ordering.isLastBeforeOthers();
                int lastBeforeOthers = -1;
                for (i = 0; i < tempOrder.size(); ++i) {
                    if (ordering.isAfter((Ordering)tempOrder.get(i))) {
                        insertAfter = i;
                    }
                    if (!((Ordering)tempOrder.get((int)i)).beforeOthers) continue;
                    lastBeforeOthers = i;
                }
                pos = insertAfter;
                if (last && lastBeforeOthers > insertAfter) {
                    pos = lastBeforeOthers;
                }
                tempOrder.add(pos + 1, ordering);
                continue;
            }
            if (ordering.afterOthers) {
                int insertBefore = tempOrder.size();
                boolean first = ordering.isFirstAfterOthers();
                int firstAfterOthers = tempOrder.size();
                for (i = tempOrder.size() - 1; i >= 0; --i) {
                    if (ordering.isBefore((Ordering)tempOrder.get(i))) {
                        insertBefore = i;
                    }
                    if (!((Ordering)tempOrder.get((int)i)).afterOthers) continue;
                    firstAfterOthers = i;
                }
                pos = insertBefore;
                if (first && firstAfterOthers < insertBefore) {
                    pos = firstAfterOthers;
                }
                tempOrder.add(pos, ordering);
                continue;
            }
            insertAfter = -1;
            int insertBefore = tempOrder.size();
            for (int i2 = 0; i2 < tempOrder.size(); ++i2) {
                if (ordering.isAfter((Ordering)tempOrder.get(i2)) || ((Ordering)tempOrder.get((int)i2)).beforeOthers) {
                    insertAfter = i2;
                }
                if (!ordering.isBefore((Ordering)tempOrder.get(i2)) && !((Ordering)tempOrder.get((int)i2)).afterOthers) continue;
                insertBefore = i2;
            }
            if (insertAfter > insertBefore) {
                throw new IllegalStateException("Fragment ordering conflict with JAR: " + ordering.ordering.getJar());
            }
            tempOrder.add(insertAfter + 1, ordering);
        }
        for (Ordering ordering : tempOrder) {
            order.add(ordering.ordering.getJar());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Ordering {
        protected WebOrdering ordering;
        protected Set<Ordering> after = new HashSet<Ordering>();
        protected Set<Ordering> before = new HashSet<Ordering>();
        protected boolean afterOthers = false;
        protected boolean beforeOthers = false;

        protected Ordering() {
        }

        public boolean addAfter(Ordering ordering) {
            return this.after.add(ordering);
        }

        public boolean addBefore(Ordering ordering) {
            return this.before.add(ordering);
        }

        public void validate() {
            this.isBefore(new Ordering());
            this.isAfter(new Ordering());
        }

        public boolean isBefore(Ordering ordering) {
            return this.isBeforeInternal(ordering, new HashSet<Ordering>());
        }

        protected boolean isBeforeInternal(Ordering ordering, Set<Ordering> checked) {
            checked.add(this);
            if (this.before.contains(ordering)) {
                return true;
            }
            for (Ordering check : this.before) {
                if (checked.contains(check)) {
                    throw new IllegalStateException("Ordering conflict with JAR: " + this.ordering.getJar());
                }
                if (!check.isBeforeInternal(ordering, checked)) continue;
                return false;
            }
            return false;
        }

        public boolean isAfter(Ordering ordering) {
            return this.isAfterInternal(ordering, new HashSet<Ordering>());
        }

        protected boolean isAfterInternal(Ordering ordering, Set<Ordering> checked) {
            checked.add(this);
            if (this.after.contains(ordering)) {
                return true;
            }
            for (Ordering check : this.after) {
                if (checked.contains(check)) {
                    throw new IllegalStateException("Ordering conflict with JAR: " + this.ordering.getJar());
                }
                if (!check.isAfterInternal(ordering, checked)) continue;
                return false;
            }
            return false;
        }

        public boolean isLastBeforeOthers() {
            if (!this.beforeOthers) {
                throw new IllegalStateException();
            }
            for (Ordering check : this.before) {
                if (!check.beforeOthers) {
                    return true;
                }
                if (!check.isLastBeforeOthers()) continue;
                return true;
            }
            return false;
        }

        public boolean isFirstAfterOthers() {
            if (!this.afterOthers) {
                throw new IllegalStateException();
            }
            for (Ordering check : this.after) {
                if (!check.afterOthers) {
                    return true;
                }
                if (!check.isFirstAfterOthers()) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WebOrdering
    implements Serializable {
        private static final long serialVersionUID = 5603203103871892211L;
        protected String jar = null;
        protected String name = null;
        protected List<String> after = new ArrayList<String>();
        protected List<String> before = new ArrayList<String>();
        protected boolean afterOthers = false;
        protected boolean beforeOthers = false;

        protected WebOrdering() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getAfter() {
            return this.after;
        }

        public void addAfter(String name) {
            this.after.add(name);
        }

        public List<String> getBefore() {
            return this.before;
        }

        public void addBefore(String name) {
            this.before.add(name);
        }

        public String getJar() {
            return this.jar;
        }

        public void setJar(String jar) {
            this.jar = jar;
        }

        public boolean isAfterOthers() {
            return this.afterOthers;
        }

        public void setAfterOthers(boolean afterOthers) {
            this.afterOthers = afterOthers;
        }

        public boolean isBeforeOthers() {
            return this.beforeOthers;
        }

        public void setBeforeOthers(boolean beforeOthers) {
            this.beforeOthers = beforeOthers;
        }
    }
}

