/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.deployer.helpers.AttachmentLocator;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.structure.spi.main.MainDeployerInternals;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.injection.injector.EEInjector;
import org.jboss.injection.injector.metadata.EnvironmentEntryType;
import org.jboss.injection.injector.metadata.JndiEnvironmentRefsGroup;
import org.jboss.injection.manager.spi.InjectionManager;
import org.jboss.injection.manager.spi.Injector;
import org.jboss.injection.mc.metadata.JndiEnvironmentImpl;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ManagementPropertyFactory;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceContextReferencesMetaData;
import org.jboss.metadata.web.jboss.ClassLoadingMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.switchboard.spi.Barrier;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceInjectionValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.metadata.ServiceMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.system.microcontainer.ServiceControllerContext;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.deployers.WarDeployment;
import org.jboss.web.deployers.WebModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWarDeployer
extends AbstractSimpleRealDeployer<JBossWebMetaData>
implements ManagedObjectCreator {
    public static final String DEPLOYER = "org.jboss.web.AbstractWebContainer.deployer";
    public static final String WEB_APP = "org.jboss.web.AbstractWebContainer.webApp";
    public static final String WEB_MODULE = "org.jboss.web.AbstractWebContainer.webModule";
    public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
    protected HashMap deploymentMap = new HashMap();
    protected boolean java2ClassLoadingCompliance = false;
    protected boolean unpackWars = true;
    protected boolean acceptNonWarDirs = false;
    protected boolean lenientEjbLink = false;
    protected String defaultSecurityDomain = "java:/jaas/other";
    private String subjectAttributeName = null;
    private MBeanServer server;
    private MainDeployerInternals mainDeployer;
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;
    private JavaEEComponentInformer componentInformer;

    public AbstractWarDeployer() {
        super(JBossWebMetaData.class);
        this.addInput(Barrier.class);
        this.addInput(InjectionManager.class);
        this.setOutput(ServiceMetaData.class);
        this.setOutput(WarDeployment.class);
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean flag) {
        this.unpackWars = flag;
    }

    public boolean getAcceptNonWarDirs() {
        return this.acceptNonWarDirs;
    }

    public void setAcceptNonWarDirs(boolean flag) {
        this.acceptNonWarDirs = flag;
    }

    public boolean getLenientEjbLink() {
        return this.lenientEjbLink;
    }

    public void setLenientEjbLink(boolean flag) {
        this.lenientEjbLink = flag;
    }

    public String getDefaultSecurityDomain() {
        return this.defaultSecurityDomain;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    @Inject
    public void setPersistenceUnitDependencyResolver(PersistenceUnitDependencyResolver resolver) {
        this.persistenceUnitDependencyResolver = resolver;
    }

    @Inject
    public void setJavaEEComponentInformer(JavaEEComponentInformer informer) {
        this.componentInformer = informer;
    }

    public String getSubjectAttributeName() {
        return this.subjectAttributeName;
    }

    public void setSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeName = subjectAttributeName;
    }

    public void start() throws Exception {
        this.server = MBeanServerLocator.locateJBoss();
    }

    public void stop() throws Exception {
    }

    public abstract AbstractWarDeployment getDeployment(DeploymentUnit var1, JBossWebMetaData var2) throws Exception;

    public void deploy(DeploymentUnit unit, JBossWebMetaData metaData) throws DeploymentException {
        this.log.debug((Object)("Begin deploy, " + metaData));
        JBossAppMetaData earMetaData = (JBossAppMetaData)AttachmentLocator.search((DeploymentUnit)unit, JBossAppMetaData.class);
        if (earMetaData != null) {
            String path = unit.getRelativePath();
            ModuleMetaData webModule = earMetaData.getModule(path);
            if (webModule != null) {
                String contextRoot = metaData.getContextRoot();
                if (contextRoot == null) {
                    WebModuleMetaData wmodule = (WebModuleMetaData)webModule.getValue();
                    contextRoot = wmodule.getContextRoot();
                    metaData.setContextRoot(contextRoot);
                }
                metaData.setAlternativeDD(webModule.getAlternativeDD());
            }
            if (metaData.getSecurityDomain() == null && earMetaData.getSecurityDomain() != null) {
                metaData.setSecurityDomain(earMetaData.getSecurityDomain());
            }
            metaData.mergeSecurityRoles(earMetaData.getSecurityRoles());
        }
        try {
            ClassLoadingMetaData classLoading;
            String warName = unit.getName();
            if (warName.startsWith("jboss:") && warName.contains("id=")) {
                return;
            }
            if (unit instanceof VFSDeploymentUnit) {
                File file;
                VirtualFile altDD;
                List classpathVFs;
                VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
                VirtualFile root = vfsUnit.getRoot();
                URL expWarUrl = this.getExplodedWarUrl(root);
                String warPathName = root.getPathName();
                if (!warPathName.endsWith("/")) {
                    warPathName = warPathName + "/";
                }
                if ((classpathVFs = vfsUnit.getClassPath()) != null) {
                    ArrayList<URL> classpath = new ArrayList<URL>();
                    for (VirtualFile vf : classpathVFs) {
                        try {
                            String path = vf.getPathName();
                            if (path.startsWith(warPathName)) {
                                path = path.substring(warPathName.length());
                                URL pathURL = new URL(expWarUrl, path);
                                classpath.add(pathURL);
                                continue;
                            }
                            this.log.debug((Object)("Ignoring path element: " + vf));
                        }
                        catch (Exception e) {
                            this.log.debug((Object)("Ignoring path element: " + vf), (Throwable)e);
                        }
                    }
                    unit.addAttachment("org.jboss.web.expandedWarClasspath", classpath);
                }
                unit.addAttachment("org.jboss.web.expandedWarURL", (Object)expWarUrl, URL.class);
                String altDDPath = metaData.getAlternativeDD();
                if (!(altDDPath == null || (altDD = vfsUnit.getMetaDataFile(altDDPath)) != null || (file = new File(altDDPath)).exists() && file.isAbsolute())) {
                    VFSDeploymentUnit topUnit = vfsUnit.getTopLevel();
                    if (topUnit == unit) {
                        throw new DeploymentException("Unable to resolve " + altDDPath + " as WEB-INF path");
                    }
                    altDD = topUnit.getFile(altDDPath);
                    if (altDD == null) {
                        throw new DeploymentException("Unable to resolve " + altDDPath + " as a deployment path");
                    }
                    VirtualFile altDDFile = root.getChild("WEB-INF/" + altDD.getName());
                    this.log.debug((Object)("Copying the altDD to: " + altDDFile));
                    VFSUtils.writeFile((VirtualFile)altDDFile, (InputStream)altDD.openStream());
                    metaData.setAlternativeDD(altDDFile.getPathName());
                }
            }
            if ((classLoading = metaData.getClassLoading()) == null) {
                classLoading = new ClassLoadingMetaData();
            }
            if (!classLoading.wasJava2ClassLoadingComplianceSet()) {
                classLoading.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
            }
            metaData.setClassLoading(classLoading);
            String webContext = metaData.getContextRoot();
            webContext = this.buildWebContext(webContext, warName, metaData, unit);
            metaData.setContextRoot(webContext);
            AbstractWarDeployment deployment = this.getDeployment(unit, metaData);
            deployment.setMainDeployer(this.mainDeployer);
            deployment.setPersistenceUnitDependencyResolver(this.persistenceUnitDependencyResolver);
            this.deployWebModule(unit, metaData, deployment);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to create web module", (Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit unit, JBossWebMetaData metaData) {
        try {
            URL warURL = (URL)unit.getAttachment("org.jboss.web.expandedWarURL", URL.class);
            if (warURL != null) {
                VirtualFile file = VFS.getChild((URL)warURL);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)"Failed to remove expanded war", (Throwable)e);
        }
    }

    public void addDeployedApp(String warURL, WebApplication webApp) {
        this.deploymentMap.put(warURL, webApp);
    }

    public WebApplication getDeployedApp(String warUrl) {
        return (WebApplication)this.deploymentMap.get(warUrl);
    }

    public WebApplication removeDeployedApp(String warURL) {
        return (WebApplication)this.deploymentMap.remove(warURL);
    }

    public Iterator getDeployedApplications() {
        return this.deploymentMap.values().iterator();
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Object[] args;
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
            if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getURLs = cl.getClass().getMethod("getAllURLs", parameterTypes)).getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    protected String buildWebContext(String ctxPath, String warName, JBossWebMetaData metaData, DeploymentUnit unit) {
        String webContext = ctxPath;
        if (webContext == null) {
            char c;
            int index;
            int suffix;
            int prefix;
            webContext = warName;
            if ((webContext = webContext.replace('\\', '/')).endsWith("/")) {
                webContext = webContext.substring(0, webContext.length() - 1);
            }
            if ((prefix = webContext.lastIndexOf(47)) > 0) {
                webContext = webContext.substring(prefix + 1);
            }
            if ((suffix = webContext.lastIndexOf(".war")) > 0) {
                webContext = webContext.substring(0, suffix);
            }
            for (index = 0; index < webContext.length() && (Character.isDigit(c = webContext.charAt(index)) || c == '.'); ++index) {
            }
            webContext = webContext.substring(index);
        }
        if (webContext.length() > 0 && webContext.charAt(0) != '/') {
            webContext = "/" + webContext;
        } else if (webContext.equals("/")) {
            webContext = "";
        }
        return webContext;
    }

    @Deprecated
    protected MBeanServer getServer() {
        return this.server;
    }

    public MainDeployerInternals getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployerInternals mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    protected String getObjectName(JBossWebMetaData metaData) {
        String ctxPath;
        String virtualHost = "";
        List hosts = metaData.getVirtualHosts();
        if (hosts != null && hosts.size() > 0) {
            virtualHost = (String)hosts.get(0);
        }
        if ((ctxPath = metaData.getContextRoot()) == null || ctxPath.length() == 0) {
            ctxPath = "/";
        }
        return "jboss.web.deployment:war=" + virtualHost + ctxPath;
    }

    protected void deployWebModule(DeploymentUnit unit, JBossWebMetaData metaData, AbstractWarDeployment deployment) throws Exception {
        this.log.debug((Object)("deployWebModule: " + unit.getName()));
        try {
            PersistenceContextReferencesMetaData pcRefs;
            InjectionManager injectionManager;
            Barrier switchBoard;
            ServiceMetaData webModule = new ServiceMetaData();
            String name = this.getObjectName(metaData);
            ObjectName objectName = new ObjectName(name);
            webModule.setObjectName(objectName);
            webModule.setCode(WebModule.class.getName());
            ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
            constructor.setSignature(new String[]{DeploymentUnit.class.getName(), AbstractWarDeployer.class.getName(), AbstractWarDeployment.class.getName()});
            constructor.setParameters(new Object[]{unit, this, deployment});
            webModule.setConstructor(constructor);
            ArrayList<ServiceAttributeMetaData> attrs = new ArrayList<ServiceAttributeMetaData>();
            ServiceAttributeMetaData attr = new ServiceAttributeMetaData();
            attr.setName("SecurityManagement");
            ServiceInjectionValueMetaData injectionValue = new ServiceInjectionValueMetaData((Object)deployment.getSecurityManagementName());
            attr.setValue((ServiceValueMetaData)injectionValue);
            attrs.add(attr);
            ServiceAttributeMetaData attrPR = new ServiceAttributeMetaData();
            attrPR.setName("PolicyRegistration");
            ServiceInjectionValueMetaData injectionValuePR = new ServiceInjectionValueMetaData((Object)deployment.getPolicyRegistrationName());
            attrPR.setValue((ServiceValueMetaData)injectionValuePR);
            attrs.add(attrPR);
            ServiceAttributeMetaData attrKernel = new ServiceAttributeMetaData();
            attrKernel.setName("Kernel");
            ServiceInjectionValueMetaData injectionValueKernel = new ServiceInjectionValueMetaData((Object)"jboss.kernel:service=Kernel");
            attrKernel.setValue((ServiceValueMetaData)injectionValueKernel);
            attrs.add(attrKernel);
            webModule.setAttributes(attrs);
            List depends = metaData.getDepends();
            ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
            if (depends != null && !depends.isEmpty()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(name + " has dependencies: " + depends));
                }
                for (String iDependOn : depends) {
                    ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
                    sdmd.setIDependOn(iDependOn);
                    dependencies.add(sdmd);
                }
            }
            if ((switchBoard = (Barrier)unit.getAttachment(Barrier.class)) != null) {
                AnyStateServiceDependencyMetaData switchBoardDependency = new AnyStateServiceDependencyMetaData(switchBoard.getId(), ControllerState.START, ControllerState.INSTALLED);
                dependencies.add(switchBoardDependency);
                this.log.debug((Object)("Added switchboard dependency: " + switchBoard.getId() + " for web module: " + name));
            }
            if ((injectionManager = (InjectionManager)unit.getAttachment(InjectionManager.class)) != null) {
                JndiEnvironmentImpl jndiEnvironment;
                deployment.setInjectionManager(injectionManager);
                Environment webEnvironment = metaData.getJndiEnvironmentRefsGroup();
                if (webEnvironment != null && this.hasInjectionTargets((JndiEnvironmentRefsGroup)(jndiEnvironment = new JndiEnvironmentImpl(webEnvironment, unit.getClassLoader())))) {
                    EEInjector eeInjector = new EEInjector((JndiEnvironmentRefsGroup)jndiEnvironment);
                    injectionManager.addInjector((Injector)eeInjector);
                    String injectorMCBeanName = this.getInjectorMCBeanName(unit);
                    BeanMetaData injectorBMD = this.createInjectorBMD(injectorMCBeanName, eeInjector, switchBoard);
                    unit.addAttachment(BeanMetaData.class + ":" + injectorMCBeanName, (Object)injectorBMD);
                    ServiceDependencyMetaData injectorDepdendency = new ServiceDependencyMetaData();
                    injectorDepdendency.setIDependOn(injectorMCBeanName);
                    dependencies.add(injectorDepdendency);
                    this.log.debug((Object)("Added Injector dependency: " + injectorMCBeanName + " for web module: " + name));
                }
            }
            if ((pcRefs = metaData.getPersistenceContextRefs()) != null) {
                for (PersistenceContextReferenceMetaData pcRef : metaData.getPersistenceContextRefs()) {
                    String persistenceUnitName = pcRef.getPersistenceUnitName();
                    String beanName = this.persistenceUnitDependencyResolver.resolvePersistenceUnitSupplier(unit, persistenceUnitName);
                    ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
                    sdmd.setIDependOn(beanName);
                    dependencies.add(sdmd);
                }
            }
            webModule.setDependencies(dependencies);
            unit.addAttachment("WarServiceMetaData", (Object)webModule, ServiceMetaData.class);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error creating web module " + unit.getName()), (Throwable)e);
        }
    }

    public void build(DeploymentUnit unit, Set<String> outputs, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        JBossWebMetaData meta = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (meta == null) {
            return;
        }
        ManagedObject mo = ManagedObjectFactory.getInstance().createManagedObject(ContextMO.class);
        if (mo == null) {
            throw new DeploymentException("could not create managed object");
        }
        mo.getProperty("contextRoot").setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)meta.getContextRoot())));
        managedObjects.put("ContextMO", mo);
    }

    private URL getExplodedWarUrl(VirtualFile virtualFile) throws MalformedURLException, IOException {
        if (virtualFile.isDirectory()) {
            VirtualFileVisitor visitor = new VirtualFileVisitor(){

                public void visit(VirtualFile virtualFile) {
                    try {
                        virtualFile.getPhysicalFile();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to force explosion of VirtualFile: " + virtualFile, e);
                    }
                }

                public VisitorAttributes getAttributes() {
                    return VisitorAttributes.RECURSE_LEAVES_ONLY;
                }
            };
            virtualFile.visit(visitor);
            return virtualFile.getPhysicalFile().toURI().toURL();
        }
        return virtualFile.toURL();
    }

    protected BeanMetaData createInjectorBMD(String injectorMCBeanName, EEInjector injector, Barrier barrier) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)injectorMCBeanName, (String)injector.getClass().getName());
        builder.setConstructorValue((Object)injector);
        builder.addDemand((Object)barrier.getId(), ControllerState.CREATE, ControllerState.START, null);
        return builder.getBeanMetaData();
    }

    protected String getInjectorMCBeanName(DeploymentUnit unit) {
        StringBuilder sb = new StringBuilder("jboss-injector:");
        String appName = this.componentInformer.getApplicationName(unit);
        if (appName != null) {
            sb.append("appName=");
            sb.append(appName);
            sb.append(",");
        }
        String moduleName = this.componentInformer.getModuleName(unit);
        sb.append("module=");
        sb.append(moduleName);
        return sb.toString();
    }

    private boolean hasInjectionTargets(JndiEnvironmentRefsGroup jndiEnv) {
        Collection envEntries = jndiEnv.getEntries();
        if (envEntries == null || envEntries.isEmpty()) {
            return false;
        }
        for (EnvironmentEntryType envEntry : envEntries) {
            Collection injectionTargets = envEntry.getInjectionTargets();
            if (injectionTargets == null || injectionTargets.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private class AnyStateServiceDependencyMetaData
    extends ServiceDependencyMetaData {
        private ControllerState whenRequired;
        private ControllerState dependentState;

        public AnyStateServiceDependencyMetaData(String iDependOn, ControllerState whenRequired, ControllerState dependentState) {
            this.setIDependOn(iDependOn);
            this.whenRequired = whenRequired;
            this.dependentState = dependentState;
        }

        public void visit(ServiceMetaDataVisitor visitor) {
            ServiceControllerContext context = visitor.getControllerContext();
            Object name = context.getName();
            String dependency = this.getIDependOn();
            try {
                dependency = this.getIDependOnObjectName().getCanonicalName();
            }
            catch (MalformedObjectNameException ignored) {
                // empty catch block
            }
            visitor.addDependency((DependencyItem)new AbstractDependencyItem(name, (Object)dependency, this.whenRequired, this.dependentState));
            visitor.visit((ServiceMetaDataVisitorNode)this);
        }
    }

    @ManagementObject(name="ContextMO", componentType=@ManagementComponent(type="WAR", subtype="Context"))
    public static class ContextMO {
        @ManagementPropertyFactory(value=ManagedPropertyImpl.class)
        @ManagementProperty(use={ViewUse.RUNTIME}, readOnly=true)
        public String getContextRoot() {
            return "";
        }
    }
}

