/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap.api.as.server;

import org.jboss.bootstrap.api.as.config.JBossASServerConfig;
import org.jboss.bootstrap.api.as.config.JBossASServerConfigFactory;
import org.jboss.bootstrap.api.as.server.JBossASBasedServer;
import org.jboss.bootstrap.api.as.server.JBossASServer;
import org.jboss.bootstrap.api.as.server.SecurityActions;
import org.jboss.bootstrap.api.factory.ServerFactory;
import org.jboss.bootstrap.api.server.Server;

public class JBossASServerFactory {
    public static final String DEFAULT_AS_SERVER_IMPL_CLASS_NAME = "org.jboss.bootstrap.impl.as.server.JBossASServerImpl";

    private JBossASServerFactory() {
    }

    public static JBossASServer createServer() {
        return JBossASServerFactory.createServer(SecurityActions.getTccl());
    }

    public static JBossASServer createServer(ClassLoader cl) throws IllegalArgumentException {
        try {
            return JBossASServerFactory.createServer(DEFAULT_AS_SERVER_IMPL_CLASS_NAME, cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in creating the Server", e);
        }
    }

    public static JBossASServer createServer(String implClassName, ClassLoader cl) throws IllegalArgumentException, Exception {
        return JBossASServerFactory.createServer(implClassName, cl, JBossASServer.class);
    }

    public static <T extends JBossASBasedServer<T, JBossASServerConfig>> T createServer(String implClassName, ClassLoader cl, Class<T> expectedType) throws IllegalArgumentException, InstantiationException {
        JBossASBasedServer asServer;
        if (cl == null) {
            throw new IllegalArgumentException(ClassLoader.class.getSimpleName() + " is required.");
        }
        if (implClassName == null || implClassName.length() == 0) {
            throw new IllegalArgumentException("Implementation class name must be specified");
        }
        Server<?, ?> server = ServerFactory.createServer(implClassName, cl);
        try {
            asServer = (JBossASBasedServer)expectedType.cast(server);
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Specified server implementation class, " + implClassName + " must be assignable to " + expectedType.getName());
        }
        JBossASServerConfig config = JBossASServerConfigFactory.createServerConfig(cl);
        asServer.setConfiguration(config);
        return (T)asServer;
    }
}

