/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.TimerTask;
import javax.ejb.EJBException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GlobalTxEntityMap;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.LRUEnterpriseContextCachePolicy;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.util.NestedRuntimeException;

public class EntitySynchronizationInterceptor
extends AbstractInterceptor {
    private ValidContextsRefresher vcr;
    protected int commitOption;
    protected long optionDRefreshRate;
    protected EntityContainer container;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = (EntityContainer)container;
    }

    public void create() throws Exception {
        try {
            ConfigurationMetaData configuration = this.container.getBeanMetaData().getContainerConfiguration();
            this.commitOption = configuration.getCommitOption();
            this.optionDRefreshRate = configuration.getOptionDRefreshRate();
        }
        catch (Exception e) {
            this.log.warn((Object)e.getMessage());
        }
    }

    public void start() {
        try {
            if (this.commitOption == 3) {
                this.vcr = new ValidContextsRefresher();
                LRUEnterpriseContextCachePolicy.tasksTimer.schedule((TimerTask)this.vcr, this.optionDRefreshRate, this.optionDRefreshRate);
                this.log.debug((Object)("Scheduled a cache flush every " + this.optionDRefreshRate / 1000L + " seconds"));
            }
        }
        catch (Exception e) {
            this.vcr = null;
            this.log.warn((Object)"problem scheduling valid contexts refresher", (Throwable)e);
        }
    }

    public void stop() {
        if (this.vcr != null) {
            ValidContextsRefresher temp = this.vcr;
            this.vcr = null;
            temp.cancel();
        }
    }

    protected Synchronization createSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
        return new InstanceSynchronization(tx, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(EntityEnterpriseContext ctx, Transaction tx) {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("register, ctx=" + ctx + ", tx=" + tx));
        }
        EntityContainer ctxContainer = null;
        try {
            ctxContainer = (EntityContainer)ctx.getContainer();
            if (!ctx.hasTxSynchronization()) {
                Synchronization synch = this.createSynchronization(tx, ctx);
                tx.registerSynchronization(synch);
                ctx.hasTxSynchronization(true);
            }
            if (!ctxContainer.isReadOnly()) {
                ctx.getTxAssociation().scheduleSync(tx, ctx);
            }
        }
        catch (RollbackException e) {
            EntityEnterpriseContext entityEnterpriseContext = ctx;
            synchronized (entityEnterpriseContext) {
                ctx.setValid(false);
                ctx.hasTxSynchronization(false);
                ctx.setTransaction(null);
                ctx.setTxAssociation(GlobalTxEntityMap.NONE);
            }
            throw new EJBException((Exception)((Object)e));
        }
        catch (Throwable t) {
            ctx.hasTxSynchronization(false);
            ctx.setTxAssociation(GlobalTxEntityMap.NONE);
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw new EJBException((Exception)t);
            }
            throw new NestedRuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        Transaction tx = mi.getTransaction();
        Object rtn = this.getNext().invokeHome(mi);
        if (ctx.getId() != null) {
            ctx.setValid(true);
            if (tx != null) {
                BeanLock lock = this.container.getLockManager().getLock(ctx.getCacheKey());
                try {
                    lock.schedule(mi);
                    this.register(ctx, tx);
                    lock.endInvocation(mi);
                }
                finally {
                    this.container.getLockManager().removeLockRef(lock.getId());
                }
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Object invoke(Invocation mi) throws Exception {
        ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        tx = mi.getTransaction();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("invoke called for ctx " + ctx + ", tx=" + tx));
        }
        if (!ctx.isValid()) {
            this.container.getPersistenceManager().loadEntity(ctx);
            ctx.setValid(true);
        }
        didSetReadOnly = false;
        if (!ctx.isReadOnly() && (this.container.isReadOnly() || this.container.getBeanMetaData().isMethodReadOnly(mi.getMethod()))) {
            ctx.setReadOnly(true);
            didSetReadOnly = true;
        }
        if (tx != null && tx.getStatus() != 6) {
            isReadOnly = this.container.isReadOnly();
            if (!isReadOnly && (method = mi.getMethod()) != null) {
                isReadOnly = this.container.getBeanMetaData().isMethodReadOnly(method.getName());
            }
            try {
                if (!isReadOnly) {
                    this.register(ctx, tx);
                }
                retVal = this.getNext().invoke(mi);
                if (!isReadOnly) {
                    this.register(ctx, tx);
                }
                var7_10 = retVal;
                return var7_10;
            }
            finally {
                if (isReadOnly && !ctx.hasTxSynchronization()) {
                    switch (this.commitOption) {
                        case 1: {
                            ctx.setValid(false);
                            break;
                        }
                        case 2: {
                            try {
                                if (ctx.getId() == null) break;
                                this.container.getInstanceCache().remove(ctx.getId());
                                break;
                            }
                            catch (Exception e) {
                                this.log.debug((Object)"Exception releasing context", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        ** try [egrp 5[TRYBLOCK] [5, 6 : 418->467)] { 
lbl-1000:
        // 1 sources

        {
            result = this.getNext().invoke(mi);
            if (ctx.getId() != null && !this.container.isReadOnly()) {
                this.container.invokeEjbStore(ctx);
                this.container.storeEntity(ctx);
            }
            var6_9 = result;
            return var6_9;
        }
lbl46:
        // 1 sources

        catch (Exception e) {
            ctx.setValid(false);
            throw e;
        }
lbl-1000:
        // 1 sources

        {
            finally {
                switch (this.commitOption) {
                    case 1: {
                        ctx.setValid(false);
                        break;
                    }
                    case 2: {
                        try {
                            if (ctx.getId() == null) break;
                            this.container.getInstanceCache().remove(ctx.getId());
                            break;
                        }
                        catch (Exception e) {
                            this.log.debug((Object)"Exception releasing context", (Throwable)e);
                        }
                    }
                }
            }
        }
        {
            catch (Throwable var13_17) {
                throw var13_17;
            }
        }
        finally {
            if (didSetReadOnly) {
                ctx.setReadOnly(false);
            }
        }
    }

    class ValidContextsRefresher
    extends TimerTask {
        public void run() {
            if (EntitySynchronizationInterceptor.this.container == null) {
                this.cancel();
                return;
            }
            if (EntitySynchronizationInterceptor.this.log.isTraceEnabled()) {
                EntitySynchronizationInterceptor.this.log.trace((Object)("Flushing the valid contexts " + EntitySynchronizationInterceptor.this.container.getBeanMetaData().getEjbName()));
            }
            EntityCache cache = (EntityCache)EntitySynchronizationInterceptor.this.container.getInstanceCache();
            try {
                if (cache != null) {
                    cache.flush();
                }
            }
            catch (Throwable t) {
                EntitySynchronizationInterceptor.this.log.debug((Object)"Ignored error while trying to flush() entity cache", t);
            }
        }
    }

    protected class InstanceSynchronization
    implements Synchronization {
        protected Transaction tx;
        protected EntityEnterpriseContext ctx;
        protected BeanLock lock;

        InstanceSynchronization(Transaction tx, EntityEnterpriseContext ctx) {
            this.tx = tx;
            this.ctx = ctx;
            this.lock = EntitySynchronizationInterceptor.this.container.getLockManager().getLock(ctx.getCacheKey());
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterCompletion(int status) {
            boolean setCl;
            boolean trace = EntitySynchronizationInterceptor.this.log.isTraceEnabled();
            ClassLoader oldCl = SecurityActions.getContextClassLoader();
            boolean bl = setCl = !oldCl.equals(EntitySynchronizationInterceptor.this.container.getClassLoader());
            if (setCl) {
                SecurityActions.setContextClassLoader(EntitySynchronizationInterceptor.this.container.getClassLoader());
            }
            EntitySynchronizationInterceptor.this.container.pushENC();
            int commitOption = this.ctx.isPassivateAfterCommit() ? 2 : EntitySynchronizationInterceptor.this.commitOption;
            this.lock.sync();
            this.ctx.hasTxSynchronization(false);
            this.ctx.setTxAssociation(GlobalTxEntityMap.NONE);
            this.ctx.setTransaction(null);
            try {
                try {
                    if (status == 4) {
                        EntitySynchronizationInterceptor.this.container.getInstanceCache().remove(this.ctx.getCacheKey());
                        return;
                    }
                    switch (commitOption) {
                        case 0: 
                        case 3: {
                            this.ctx.setValid(true);
                            return;
                        }
                        case 1: {
                            this.ctx.setValid(false);
                            return;
                        }
                        case 2: {
                            try {
                                if (this.ctx.getId() != null) {
                                    EntitySynchronizationInterceptor.this.container.getInstanceCache().remove(this.ctx.getId());
                                    EntitySynchronizationInterceptor.this.container.getPersistenceManager().passivateEntity(this.ctx);
                                }
                                EntitySynchronizationInterceptor.this.container.getInstancePool().free(this.ctx);
                                return;
                            }
                            catch (Exception e) {
                                EntitySynchronizationInterceptor.this.log.debug((Object)"Exception releasing context", (Throwable)e);
                                return;
                            }
                        }
                    }
                    return;
                }
                finally {
                    if (trace) {
                        EntitySynchronizationInterceptor.this.log.trace((Object)("afterCompletion, clear tx for ctx=" + this.ctx + ", tx=" + this.tx));
                    }
                    this.lock.endTransaction(this.tx);
                    if (trace) {
                        EntitySynchronizationInterceptor.this.log.trace((Object)("afterCompletion, sent notify on TxLock for ctx=" + this.ctx));
                    }
                }
            }
            finally {
                this.lock.releaseSync();
                EntitySynchronizationInterceptor.this.container.getLockManager().removeLockRef(this.lock.getId());
                EntitySynchronizationInterceptor.this.container.popENC();
                if (setCl) {
                    SecurityActions.setContextClassLoader(oldCl);
                }
            }
        }
    }
}

