/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.unified.server;

import java.rmi.MarshalledObject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.unified.interfaces.UnifiedInvokerProxy;
import org.jboss.invocation.unified.server.UnifiedInvokerMBean;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.ConnectorMBean;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;

public class UnifiedInvoker
extends ServiceMBeanSupport
implements ServerInvocationHandler,
UnifiedInvokerMBean {
    private ConnectorMBean connector;
    private ServerInvoker serverInvoker;
    private MBeanServer mbServer;
    private boolean strictRMIException = false;
    private UnifiedInvokerProxy proxy;
    private String subsystem = "invoker";

    public void setStrictRMIException(boolean isStrict) {
        this.strictRMIException = isStrict;
    }

    public boolean getStrictRMIException() {
        return this.strictRMIException;
    }

    public String getSubSystem() {
        return this.subsystem;
    }

    public void setSubSystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public void setConnector(ConnectorMBean connector) {
        this.connector = connector;
    }

    protected void createService() throws Exception {
        if (this.connector != null) {
            try {
                this.connector.addInvocationHandler(this.getSubSystem(), (ServerInvocationHandler)this);
            }
            catch (Exception e) {
                this.log.error((Object)"Error adding unified invoker as handler upon connector being set.", (Throwable)e);
            }
        }
    }

    protected void startService() throws Exception {
        this.log.debug((Object)"Starting unified invoker service.");
        InvokerLocator locator = null;
        if (this.serverInvoker != null) {
            locator = this.serverInvoker.getLocator();
            if (!this.serverInvoker.isStarted()) {
                this.serverInvoker.start();
            }
        } else if (this.connector != null) {
            locator = this.connector.getLocator();
        } else {
            this.log.error((Object)"Error referencing either remoting connector or server invoker to be used.  Please check configuration to make sure proper dependancies are set.");
            throw new RuntimeException("Error getting locator because server invoker is null.");
        }
        this.proxy = new UnifiedInvokerProxy(locator, this.strictRMIException);
        this.jmxBind();
    }

    protected void jmxBind() {
        Registry.bind((Object)this.getServiceName(), (Object)this.proxy);
    }

    public void stopService() throws Exception {
    }

    public String getName() {
        return "Unified-Invoker";
    }

    public String getInvokerLocator() {
        if (this.serverInvoker != null) {
            return this.serverInvoker.getLocator().getLocatorURI();
        }
        return null;
    }

    public Object invoke(InvocationRequest invocationReq) throws Throwable {
        Invocation invocation = (Invocation)invocationReq.getParameter();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCl = currentThread.getContextClassLoader();
        ObjectName mbean = null;
        try {
            mbean = (ObjectName)Registry.lookup((Object)invocation.getObjectName());
            Object obj = this.getServer().invoke(mbean, "invoke", new Object[]{invocation}, Invocation.INVOKE_SIGNATURE);
            MarshalledObject<Object> marshalledObject = new MarshalledObject<Object>(obj);
            return marshalledObject;
        }
        catch (Exception e) {
            Throwable th = JMXExceptionDecoder.decode((Throwable)e);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Failed to invoke on mbean: " + mbean), th);
            }
            if (th instanceof Exception) {
                e = (Exception)th;
            }
            throw e;
        }
        finally {
            currentThread.setContextClassLoader(oldCl);
            Thread.interrupted();
        }
    }

    public void setMBeanServer(MBeanServer server) {
        this.mbServer = server;
    }

    public MBeanServer getServer() {
        return this.mbServer;
    }

    public void setInvoker(ServerInvoker invoker) {
        this.serverInvoker = invoker;
    }

    protected ServerInvoker getInvoker() {
        return this.serverInvoker;
    }

    public void addListener(InvokerCallbackHandler callbackHandler) {
    }

    public void removeListener(InvokerCallbackHandler callbackHandler) {
    }
}

