/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.metadata.spi.factory.AbstractBeanFactory;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.spring.facade.ControllerBeanFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;

public class KernelControllerListableBeanFactory
extends ControllerBeanFactory
implements ListableBeanFactory {
    private KernelController kernelController;

    public KernelControllerListableBeanFactory(KernelController kernelController) {
        super((Controller)kernelController);
        this.kernelController = kernelController;
    }

    public KernelControllerListableBeanFactory(Kernel kernel) {
        super((Controller)(kernel != null ? kernel.getController() : null));
        this.kernelController = kernel.getController();
    }

    public boolean containsBeanDefinition(String name) {
        return this.getContext(name, null) != null;
    }

    public int getBeanDefinitionCount() {
        int count = 0;
        ControllerStateModel stateModel = this.kernelController.getStates();
        for (ControllerState state : stateModel) {
            Set byState = this.kernelController.getContextsByState(state);
            count += byState.size();
        }
        return count;
    }

    public String[] getBeanDefinitionNames() {
        ArrayList<String> result = new ArrayList<String>();
        ControllerStateModel stateModel = this.kernelController.getStates();
        for (ControllerState state : stateModel) {
            Set byState = this.kernelController.getContextsByState(state);
            for (ControllerContext context : byState) {
                result.add(context.getName().toString());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getBeanNamesForType(Class clazz) {
        return this.getBeanNamesForType(clazz, true, true);
    }

    public String[] getBeanNamesForType(Class clazz, boolean includePrototypes, boolean allowEagerInit) {
        Set factories;
        ArrayList<String> result = new ArrayList<String>();
        Set contexts = this.kernelController.getInstantiatedContexts(clazz);
        if (contexts != null && !contexts.isEmpty()) {
            for (KernelControllerContext context : contexts) {
                result.add(context.getName().toString());
            }
        }
        if (includePrototypes && (factories = this.kernelController.getInstantiatedContexts(AbstractBeanFactory.class)) != null && !factories.isEmpty()) {
            for (KernelControllerContext kcc : factories) {
                Object bean;
                Class<?> prototypeClass = this.getPrototypeClass(kcc);
                if (prototypeClass != null) {
                    if (!clazz.isAssignableFrom(prototypeClass)) continue;
                    result.add(kcc.getName().toString());
                    continue;
                }
                if (!allowEagerInit || !clazz.isInstance(bean = this.createBean(kcc.getTarget()))) continue;
                result.add(kcc.getName().toString());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public Map getBeansOfType(Class clazz) throws BeansException {
        return this.getBeansOfType(clazz, true, true);
    }

    public Map getBeansOfType(Class clazz, boolean includePrototypes, boolean allowEagerInit) throws BeansException {
        Set factories;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set contexts = this.kernelController.getContexts(clazz, ControllerState.INSTALLED);
        for (KernelControllerContext context : contexts) {
            Object target = context.getTarget();
            result.put(context.getName().toString(), target);
        }
        if (includePrototypes && (factories = this.kernelController.getInstantiatedContexts(AbstractBeanFactory.class)) != null && !factories.isEmpty()) {
            for (KernelControllerContext kcc : factories) {
                Object bean;
                Class<?> prototypeClass = this.getPrototypeClass(kcc);
                if (prototypeClass != null) {
                    if (!clazz.isAssignableFrom(prototypeClass)) continue;
                    result.put(kcc.getName().toString(), this.createBean(kcc.getTarget()));
                    continue;
                }
                if (!allowEagerInit || !clazz.isInstance(bean = this.createBean(kcc.getTarget()))) continue;
                result.put(kcc.getName().toString(), bean);
            }
        }
        return result;
    }
}

