/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.factory;

import java.io.IOException;
import org.jboss.spring.factory.Nameable;
import org.jboss.spring.factory.NamedXmlBeanDefinitionReader;
import org.jboss.spring.io.VFSResourcePatternResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.xml.sax.EntityResolver;

public class NamedXmlApplicationContext
extends ClassPathXmlApplicationContext
implements Nameable {
    private String defaultName;
    private Resource resource;
    private NamedXmlBeanDefinitionReader beanDefinitionReader;

    public NamedXmlApplicationContext(String defaultName, Resource resource) throws BeansException {
        this(defaultName, resource, true);
    }

    public NamedXmlApplicationContext(String defaultName, Resource resource, boolean refresh) throws BeansException {
        super(new String[0], false);
        this.defaultName = defaultName;
        this.resource = resource;
        if (refresh) {
            this.refresh();
        }
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.beanDefinitionReader = new NamedXmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        this.beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        if (this.getClassLoader() != null) {
            this.beanDefinitionReader.setBeanClassLoader(this.getClassLoader());
        }
        this.beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        this.initBeanDefinitionReader(this.beanDefinitionReader);
        this.loadBeanDefinitions(this.beanDefinitionReader);
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        reader.loadBeanDefinitions(this.resource);
    }

    public String getName() {
        String name;
        String string = name = this.beanDefinitionReader.getName() != null ? this.beanDefinitionReader.getName() : this.defaultName;
        if (name == null) {
            throw new IllegalArgumentException("Bean factory JNDI name must be set!");
        }
        return name;
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new VFSResourcePatternResolver(this.getClassLoader());
    }
}

