/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.io;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.spring.io.VFSResource;
import org.jboss.spring.io.VFSResourceLoader;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSResourcePatternResolver
extends PathMatchingResourcePatternResolver {
    private Logger log = Logger.getLogger(VFSResourcePatternResolver.class);

    public VFSResourcePatternResolver() {
        super((ResourceLoader)new VFSResourceLoader());
    }

    public VFSResourcePatternResolver(ClassLoader classLoader) {
        super((ResourceLoader)new VFSResourceLoader(classLoader));
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        if (locationPattern.startsWith("classpath*:")) {
            locationPattern = locationPattern.substring("classpath*:".length());
        }
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        if (rootDirPath.startsWith("/")) {
            rootDirPath = rootDirPath.substring(1);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Enumeration<URL> urls = this.getClassLoader().getResources(rootDirPath);
        while (urls.hasMoreElements()) {
            resources.addAll(this.getVFSResources(urls.nextElement(), subPattern));
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    protected List<Resource> getVFSResources(URL rootURL, String subPattern) throws IOException {
        this.log.debug((Object)("Scanning url: " + rootURL + ", sub-pattern: " + subPattern));
        VirtualFile root = VFS.getRoot((URL)rootURL);
        PatternVirtualFileVisitor visitor = new PatternVirtualFileVisitor(subPattern);
        root.visit((VirtualFileVisitor)visitor);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Found resources: " + visitor));
        }
        return visitor.getResources();
    }

    protected Resource convertClassLoaderURL(URL url) {
        try {
            VirtualFile file = VFS.getRoot((URL)url);
            return new VFSResource(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected VisitorAttributes getVisitorAttributes() {
        return VisitorAttributes.RECURSE_LEAVES_ONLY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PatternVirtualFileVisitor
    implements VirtualFileVisitor {
        private String subPattern;
        private List<Resource> resources = new ArrayList<Resource>();

        private PatternVirtualFileVisitor(String subPattern) {
            this.subPattern = subPattern;
        }

        public VisitorAttributes getAttributes() {
            return VFSResourcePatternResolver.this.getVisitorAttributes();
        }

        public void visit(VirtualFile vf) {
            if (VFSResourcePatternResolver.this.getPathMatcher().match(this.subPattern, vf.getPathName())) {
                this.resources.add(new VFSResource(vf));
            }
        }

        public List<Resource> getResources() {
            return this.resources;
        }

        public int size() {
            return this.resources.size();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sub-pattern: ").append(this.subPattern);
            buffer.append(", resources: ").append(this.resources);
            return buffer.toString();
        }
    }
}

