/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.bootstrap.api.as.config.JBossASBasedServerConfig;
import org.jboss.bootstrap.spi.as.JBossASBootstrap;
import org.jboss.bootstrap.spi.as.server.JBossASBasedServerProvider;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.client.spi.IncompleteDeploymentException;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedDeploymentCreator;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.deployer.kernel.KernelDeploymentDeployer;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.registry.BeanKernelRegistryEntry;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedOperationImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.ArrayValueSupport;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.EnumValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.spi.MutableProfile;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.types.ControllerStateMetaType;
import org.jboss.system.server.profileservice.BootstrapDeployment;
import org.jboss.system.server.profileservice.repository.AbstractBootstrapProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceBootstrap<K extends JBossASBasedServerProvider<K, T>, T extends JBossASBasedServerConfig<T>>
implements JBossASBootstrap<K, T>,
KernelRegistryPlugin {
    private static final Logger log = Logger.getLogger(ProfileServiceBootstrap.class);
    protected ProfileKey profileKey;
    private List<ProfileKey> bootstrapProfiles = new ArrayList<ProfileKey>();
    protected MainDeployer mainDeployer;
    protected ProfileService profileService;
    private ManagedDeploymentCreator mgtDeploymentCreator = null;
    private ManagedObjectFactory mof;
    private Map<String, ManagedDeployment> bootstrapMDs = new HashMap<String, ManagedDeployment>();
    private AbstractBootstrapProfileFactory profileFactory;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Map<Object, KernelRegistryEntry> bootstrapEntries = new HashMap<Object, KernelRegistryEntry>();
    private KernelConfigurator configurator;

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public KernelConfigurator getConfigurator() {
        return this.configurator;
    }

    public void setConfigurator(KernelConfigurator configurator) {
        this.configurator = configurator;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public ProfileKey getProfileKey() {
        return this.profileKey;
    }

    public void setProfileKey(ProfileKey profileKey) {
        this.profileKey = profileKey;
    }

    public ManagedObjectFactory getMof() {
        return this.mof;
    }

    public void setMof(ManagedObjectFactory mof) {
        this.mof = mof;
    }

    public ManagedDeploymentCreator getMgtDeploymentCreator() {
        return this.mgtDeploymentCreator;
    }

    public void setMgtDeploymentCreator(ManagedDeploymentCreator mgtDeploymentCreator) {
        this.mgtDeploymentCreator = mgtDeploymentCreator;
    }

    public AbstractBootstrapProfileFactory getBootstrapProfileFactory() {
        return this.profileFactory;
    }

    public void setBootstrapProfileFactory(AbstractBootstrapProfileFactory profileFactory) {
        this.profileFactory = profileFactory;
    }

    public Map<String, ManagedDeployment> getBootstrapMDs() {
        return this.bootstrapMDs;
    }

    public void setBootstrapMDs(Map<String, ManagedDeployment> bootstrapMDs) {
        this.bootstrapMDs = bootstrapMDs;
    }

    public void start(K server) throws Exception {
        this.shutdown.set(false);
        if (this.profileService == null) {
            throw new IllegalStateException("The ProfileService has not been injected");
        }
        log.debug((Object)("Using ProfileService: " + this.profileService));
        if (this.mainDeployer == null) {
            throw new IllegalStateException("The MainDeployer has not been injected");
        }
        log.debug((Object)("Using MainDeployer: " + this.mainDeployer));
        this.mainDeployer.checkComplete();
        this.initBootstrapMDs(server);
        if (this.profileKey == null) {
            this.profileKey = new ProfileKey(((JBossASBasedServerConfig)server.getConfiguration()).getServerName());
        }
        Collection<Profile> bootstrapProfiles = this.profileFactory.createProfiles(this.profileKey, null);
        for (Profile profile : bootstrapProfiles) {
            this.profileService.registerProfile(profile);
            if (this.profileKey.equals((Object)profile.getKey())) continue;
            this.bootstrapProfiles.add(0, profile.getKey());
        }
        log.info((Object)("Loading profile: " + this.profileKey));
        this.profileService.activateProfile(this.profileKey);
        this.profileService.validateProfile(this.profileKey);
        try {
            this.mainDeployer.checkComplete();
        }
        catch (IncompleteDeploymentException e) {
            log.error((Object)("Failed to load profile: " + e.getMessage()));
        }
        catch (Exception e) {
            log.error((Object)"Failed to load profile: ", (Throwable)e);
        }
        for (ProfileKey key : this.profileService.getActiveProfileKeys()) {
            try {
                Profile profile = this.profileService.getActiveProfile(key);
                if (!profile.isMutable() || !(profile instanceof MutableProfile)) continue;
                ((MutableProfile)profile).enableModifiedDeploymentChecks(true);
            }
            catch (NoSuchProfileException ignore) {}
        }
    }

    public void prepareShutdown(K server) {
        this.shutdown.set(true);
        for (ProfileKey key : this.profileService.getActiveProfileKeys()) {
            try {
                Profile profile = this.profileService.getActiveProfile(key);
                if (!profile.isMutable() || !(profile instanceof MutableProfile)) continue;
                ((MutableProfile)profile).enableModifiedDeploymentChecks(false);
            }
            catch (NoSuchProfileException ignore) {}
        }
        if (this.mainDeployer != null) {
            this.mainDeployer.prepareShutdown();
        }
    }

    public void shutdown(K server) {
        try {
            if (this.profileService.getActiveProfileKeys().contains(this.profileKey)) {
                this.profileService.deactivateProfile(this.profileKey);
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Error deactivating profile: " + this.profileKey), t);
        }
        try {
            if (this.profileService.getProfileKeys().contains(this.profileKey)) {
                this.profileService.unregisterProfile(this.profileKey);
            }
        }
        catch (Throwable t) {
            log.warn((Object)("Error unregistering profile: " + this.profileKey), t);
        }
        this.deactivateProfiles(this.bootstrapProfiles);
        this.deactivateProfiles(this.profileService.getActiveProfileKeys());
        for (ProfileKey key : this.profileService.getProfileKeys()) {
            try {
                this.profileService.unregisterProfile(key);
            }
            catch (Throwable t) {}
        }
        try {
            this.mainDeployer.shutdown();
        }
        catch (Throwable t) {
            log.warn((Object)"Error shutting down the main deployer", t);
        }
    }

    public KernelRegistryEntry getEntry(Object name) {
        KernelRegistryEntry entry = this.bootstrapEntries.get(name);
        return entry;
    }

    protected void deactivateProfiles(Collection<ProfileKey> profiles) {
        if (profiles != null && !profiles.isEmpty()) {
            for (ProfileKey key : profiles) {
                try {
                    this.profileService.deactivateProfile(key);
                }
                catch (NoSuchProfileException e) {
                }
                catch (Throwable t) {
                    log.warn((Object)("Error unloading profile: " + this.profileKey), t);
                }
            }
        }
    }

    protected void initBootstrapMDs(K server) {
        if (this.mof == null || this.mgtDeploymentCreator == null) {
            log.warn((Object)"Skipping ManagedDeployment creation due to missing mof, mgtDeploymentCreator");
            return;
        }
        Map serverDeployments = null;
        Kernel kernel = server.getKernel();
        serverDeployments = server.getDeployments();
        ManagedDeployment firstDeployment = null;
        for (KernelDeployment kd : serverDeployments.values()) {
            Map moAnns;
            BootstrapDeployment deploymentUnit = new BootstrapDeployment(kd);
            KernelDeploymentDeployer.KernelDeploymentVisitor visitor = new KernelDeploymentDeployer.KernelDeploymentVisitor();
            try {
                visitor.deploy((DeploymentUnit)deploymentUnit, (Object)kd);
            }
            catch (DeploymentException e) {
                log.debug((Object)("Failed to build ManagedDeployment for: " + kd), (Throwable)e);
                continue;
            }
            HashSet kdProperties = new HashSet();
            HashSet ops = null;
            ManagedObjectImpl kdMO = new ManagedObjectImpl(kd.getName(), "", KernelDeployment.class.getName(), kdProperties, ops, (Serializable)kd);
            HashMap<String, Object> kdMOs = new HashMap<String, Object>();
            kdMOs.put(kd.getName(), kdMO);
            for (DeploymentUnit compUnit : deploymentUnit.getComponents()) {
                BeanMetaData bmd = (BeanMetaData)compUnit.getAttachment(BeanMetaData.class);
                ManagedObject bmdMO = this.mof.initManagedObject((Object)bmd, compUnit.getMetaData());
                if (bmdMO == null) continue;
                moAnns = bmdMO.getAnnotations();
                ManagementObject mo = (ManagementObject)moAnns.get(ManagementObject.class.getName());
                if (bmdMO instanceof MutableManagedObject) {
                    MutableManagedObject mmo = (MutableManagedObject)bmdMO;
                    if (mmo.getName().equals(mmo.getAttachmentName())) {
                        mmo.setName(bmd.getName());
                    }
                    mmo.setParent((ManagedObject)kdMO);
                    Set bmdAliases = bmd.getAliases();
                    Map oldProps = mmo.getProperties();
                    HashMap<String, ManagedPropertyImpl> newProps = new HashMap<String, ManagedPropertyImpl>(oldProps);
                    if (bmdAliases != null && bmdAliases.size() > 0) {
                        ArrayMetaType aliasType = new ArrayMetaType(SimpleMetaType.STRING, false);
                        DefaultFieldsImpl fields = this.getFields("alias", (MetaType)aliasType);
                        fields.setDescription("Aliases of the bean");
                        String[] aliases = new String[bmdAliases.size()];
                        Iterator i = bmdAliases.iterator();
                        int n = 0;
                        while (i.hasNext()) {
                            aliases[n] = i.next().toString();
                            ++n;
                        }
                        ArrayValueSupport value = new ArrayValueSupport(aliasType, (Object)aliases);
                        fields.setValue((MetaValue)value);
                        ManagedPropertyImpl aliasesMP = new ManagedPropertyImpl(bmdMO, (Fields)fields);
                        newProps.put("alias", aliasesMP);
                    }
                    DefaultFieldsImpl stateFields = this.getFields("state", (MetaType)ControllerStateMetaType.TYPE);
                    stateFields.setViewUse(new ViewUse[]{ViewUse.STATISTIC});
                    EnumValue stateValue = this.getState(bmd.getName(), kernel);
                    stateFields.setValue((MetaValue)stateValue);
                    stateFields.setDescription("The bean controller state");
                    ManagedPropertyImpl stateMP = new ManagedPropertyImpl((ManagedObject)mmo, (Fields)stateFields);
                    newProps.put("state", stateMP);
                    mmo.setProperties(newProps);
                }
                log.debug((Object)("Created ManagedObject: " + bmdMO + " for bean: " + bmd.getName()));
                kdMOs.put(bmd.getName(), bmdMO);
            }
            ManagedDeployment md = this.mgtDeploymentCreator.build((DeploymentUnit)deploymentUnit, kdMOs, null);
            if (firstDeployment == null) {
                firstDeployment = md;
            }
            for (ManagedObject bmdMO : kdMOs.values()) {
                if (bmdMO.getAttachmentName().equals(KernelDeployment.class.getName())) continue;
                ComponentType type = KnownComponentTypes.MCBean.Any.getType();
                moAnns = bmdMO.getAnnotations();
                ManagementComponent mc = (ManagementComponent)moAnns.get(ManagementComponent.class.getName());
                if (mc != null) {
                    type = new ComponentType(mc.type(), mc.subtype());
                }
                ManagedComponentImpl comp = new ManagedComponentImpl(type, md, bmdMO);
                md.addComponent(bmdMO.getName(), (ManagedComponent)comp);
                log.debug((Object)("Created ManagedComponent(" + comp.getName() + ") of type: " + type + " for MO: " + bmdMO.getName() + ", componentName: " + bmdMO.getComponentName()));
            }
            if (md == null) continue;
            this.bootstrapMDs.put(kd.getName(), md);
        }
        if (firstDeployment != null) {
            ComponentType type = new ComponentType("MCBean", "MCServer");
            ManagedObject serverMO = this.mof.initManagedObject(server, null);
            if (serverMO.getOperations() != null && serverMO.getOperations().size() == 0) {
                ManagedOperationImpl shutdown = new ManagedOperationImpl("Shutdown the server", "shutdown");
                if (serverMO instanceof MutableManagedObject) {
                    HashSet<ManagedOperationImpl> ops = new HashSet<ManagedOperationImpl>();
                    ops.add(shutdown);
                    MutableManagedObject mmo = (MutableManagedObject)MutableManagedObject.class.cast(serverMO);
                    mmo.setOperations(ops);
                }
            }
            ManagedComponentImpl serverComp = new ManagedComponentImpl(type, firstDeployment, serverMO);
            firstDeployment.addComponent("MCServer", (ManagedComponent)serverComp);
            try {
                BeanInfo mcserverInfo = this.configurator.getBeanInfo(server.getClass());
                BeanKernelRegistryEntry entry = new BeanKernelRegistryEntry(server, mcserverInfo);
                this.bootstrapEntries.put(serverComp.getComponentName(), (KernelRegistryEntry)entry);
            }
            catch (Throwable t) {
                log.error((Object)("Failed to create BeanInfo for: " + serverComp), t);
            }
            type = new ComponentType("MCBean", "ServerConfig");
            JBossASBasedServerConfig config = (JBossASBasedServerConfig)server.getConfiguration();
            ManagedObject mo = this.mof.initManagedObject((Object)config, null);
            ManagedComponentImpl configComp = new ManagedComponentImpl(type, firstDeployment, mo);
            firstDeployment.addComponent("ServerConfig", (ManagedComponent)configComp);
            log.debug((Object)("Created ManagedComponent of type: " + type + " for ServerConfig"));
        }
    }

    protected DefaultFieldsImpl getFields(String name, MetaType type) {
        DefaultFieldsImpl fields = new DefaultFieldsImpl();
        fields.setMetaType(type);
        fields.setName(name);
        fields.setField("mappedName", (Object)name);
        fields.setMandatory(false);
        return fields;
    }

    protected EnumValue getState(Object name, Kernel kernel) {
        KernelController controller = kernel.getController();
        ControllerContext context = controller.getContext(name, null);
        if (context == null) {
            throw new IllegalStateException("Context not installed: " + name);
        }
        ControllerState state = context.getState();
        return new EnumValueSupport(ControllerStateMetaType.TYPE, state.getStateString());
    }
}

