/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.logging.Logger;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.util.JBossObject;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VFSScanner
extends JBossObject {
    private static final Logger log = Logger.getLogger(VFSScanner.class);
    private ProfileService profileService;
    private ProfileKey profileKey;
    private URI serverHomeURI;
    private List<URI> uriList = new CopyOnWriteArrayList<URI>();
    private List<VirtualFile> vdfList = new CopyOnWriteArrayList<VirtualFile>();
    private VirtualFileFilter filter;
    private boolean doRecursiveSearch = true;
    private Map<VirtualFile, String> deployedSet = new ConcurrentHashMap<VirtualFile, String>();
    private VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();

    protected VFSScanner() {
        super(log);
    }

    public ProfileKey getProfileKey() {
        return this.profileKey;
    }

    public void setProfileKey(ProfileKey profileKey) {
        this.profileKey = profileKey;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setURIs(String listspec) throws URISyntaxException, IOException {
        if (listspec == null) {
            throw new NullPointerException("listspec argument cannot be null");
        }
        LinkedList<URI> list = new LinkedList<URI>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urispec = stok.nextToken().trim();
            log.debug((Object)("Adding URI from spec: " + urispec));
            URI uri = this.makeURI(urispec);
            log.debug((Object)("URI: " + uri));
            list.add(uri);
        }
        this.setURIList(list);
    }

    public void setURIList(List<URI> list) throws IOException {
        if (list == null) {
            throw new NullPointerException("list argument cannot be null");
        }
        this.uriList.clear();
        for (int n = 0; n < list.size(); ++n) {
            URI uri = list.get(n);
            if (uri == null) {
                throw new IllegalArgumentException("list element[" + n + "] is null");
            }
            this.addURI(uri);
        }
        log.debug((Object)("URI list: " + this.uriList));
    }

    public List<URI> getURIList() {
        return new ArrayList<URI>(this.uriList);
    }

    public void setRecursiveSearch(boolean recurse) {
        this.doRecursiveSearch = recurse;
    }

    public boolean getRecursiveSearch() {
        return this.doRecursiveSearch;
    }

    public void setFilter(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> filterClass = loader.loadClass(classname);
        this.filter = (VirtualFileFilter)filterClass.newInstance();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getClass().getName();
    }

    public void setFilterInstance(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public VirtualFileFilter getFilterInstance() {
        return this.filter;
    }

    public void addURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        if (this.uriList.add(uri)) {
            log.debug((Object)("Added URI: " + uri));
            VirtualFile vf = this.getVFforURI(uri);
            this.vdfList.add(vf);
        }
    }

    public void removeURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        VirtualFile vf = this.getVFforURI(uri);
        this.vdfList.remove(vf);
        boolean success = this.uriList.remove(uri);
        if (success) {
            log.debug((Object)("Removed URI: " + uri));
        }
    }

    public boolean hasURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        return this.uriList.contains(uri);
    }

    public void start() throws Exception {
        this.vdfList.clear();
        for (URI uri : this.uriList) {
            VirtualFile vf = this.getVFforURI(uri);
            this.vdfList.add(vf);
        }
        if (this.profileKey == null) {
            this.profileKey = new ProfileKey("default");
        }
        this.scan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() throws Exception {
        if (this.vdfList == null) {
            throw new IllegalStateException("not initialized");
        }
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Scanning for new deployments");
        }
        LinkedList<VirtualFile> toDeployList = new LinkedList<VirtualFile>();
        List<VirtualFile> list = this.vdfList;
        synchronized (list) {
            for (VirtualFile component : this.vdfList) {
                if (component.isLeaf()) {
                    toDeployList.add(component);
                    continue;
                }
                this.addDeployments(toDeployList, component);
            }
        }
        if (trace) {
            log.trace((Object)"toDeployList");
            Iterator i = toDeployList.iterator();
            while (i.hasNext()) {
                log.trace(i.next());
            }
        }
        LinkedList<VirtualFile> toRemoveList = new LinkedList<VirtualFile>();
        Iterator i = this.deployedSet;
        synchronized (i) {
            for (VirtualFile deployedComponent : this.deployedSet.keySet()) {
                if (toDeployList.contains(deployedComponent)) continue;
                toRemoveList.add(deployedComponent);
            }
        }
        for (VirtualFile deployedComponent : toRemoveList) {
            this.undeploy(deployedComponent);
        }
        i = toDeployList.iterator();
        while (i.hasNext()) {
            VirtualFile component;
            component = (VirtualFile)i.next();
            if (!this.deployedSet.containsKey(component)) {
                this.deploy(component);
            }
            i.remove();
        }
    }

    private URI makeURI(String urispec) throws URISyntaxException {
        urispec = StringPropertyReplacer.replaceProperties((String)urispec);
        return this.serverHomeURI.resolve(urispec);
    }

    private void addDeployments(List<VirtualFile> list, VirtualFile root) throws IOException {
        List components = root.getChildren();
        for (VirtualFile component : components) {
            if (this.filter != null && !this.filter.accepts(component)) continue;
            if (component.isLeaf()) {
                list.add(component);
                continue;
            }
            if (component.getName().indexOf(46) == -1 && this.doRecursiveSearch) {
                this.addDeployments(list, component);
                continue;
            }
            list.add(component);
        }
    }

    private void deploy(VirtualFile component) {
        if (this.profileService == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deploying: " + component));
        }
        VFSDeployment deployment = null;
        try {
            Profile profile = this.profileService.getProfile(this.profileKey);
            deployment = this.add(profile, component);
        }
        catch (Exception e) {
            log.debug((Object)("Failed to deploy: " + component), (Throwable)e);
        }
        if (deployment != null && !this.deployedSet.containsKey(component)) {
            this.deployedSet.put(component, deployment.getName());
        }
    }

    private void undeploy(VirtualFile component) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Undeploying: " + component));
            }
            String name = this.deployedSet.remove(component);
            Profile profile = this.profileService.getProfile(this.profileKey);
            this.remove(profile, name);
        }
        catch (Exception e) {
            log.error((Object)("Failed to undeploy: " + component), (Throwable)e);
        }
    }

    protected abstract VFSDeployment add(Profile var1, VirtualFile var2) throws Exception;

    protected abstract void remove(Profile var1, String var2) throws Exception;

    protected VFSDeployment createDeployment(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        return this.deploymentFactory.createVFSDeployment(file);
    }

    private VirtualFile getVFforURI(URI uri) throws IOException {
        return VFS.getRoot((URI)uri);
    }
}

