/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.ProfileSourceMetaData;
import org.jboss.profileservice.spi.metadata.SubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.AbstractProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.BasicSubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.EmptyProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.FilteredProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.HotDeploymentProfileSourceMetaData;
import org.jboss.system.server.profile.repository.metadata.ImmutableProfileSourceMetaData;
import org.jboss.system.server.profileservice.repository.AbstractBootstrapProfileFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticProfileFactory
extends AbstractBootstrapProfileFactory {
    private String bindingsName = "bindings";
    private String bootstrapName = "bootstrap";
    private String deployersName = "deployers";
    private String applicationsName = "applications";
    private URI bindingsURI;
    private URI bootstrapURI;
    private URI deployersURI;
    private File attachmentStoreRoot;
    private List<URI> applicationURIs;

    public String getBootstrapName() {
        return this.bootstrapName;
    }

    public void setBootstrapName(String bootstrapName) {
        this.bootstrapName = bootstrapName;
    }

    public String getDeployersName() {
        return this.deployersName;
    }

    public void setDeployersName(String deployersName) {
        this.deployersName = deployersName;
    }

    public String getApplicationsName() {
        return this.applicationsName;
    }

    public void setApplicationsName(String applicationsName) {
        this.applicationsName = applicationsName;
    }

    public URI getBindingsURI() {
        return this.bindingsURI;
    }

    public void setBindingsURI(URI bindingsURI) {
        this.bindingsURI = bindingsURI;
    }

    public URI getBootstrapURI() {
        return this.bootstrapURI;
    }

    public void setBootstrapURI(URI bootstrapURI) {
        this.bootstrapURI = bootstrapURI;
    }

    public URI getDeployersURI() {
        return this.deployersURI;
    }

    public void setDeployersURI(URI deployersURI) {
        this.deployersURI = deployersURI;
    }

    public File getAttachmentStoreRoot() {
        return this.attachmentStoreRoot;
    }

    public void setAttachmentStoreRoot(File attachmentStoreRoot) {
        this.attachmentStoreRoot = attachmentStoreRoot;
    }

    public List<URI> getApplicationURIs() {
        if (this.applicationURIs == null) {
            return Collections.emptyList();
        }
        return this.applicationURIs;
    }

    public void setApplicationURIs(List<URI> applicationURIs) {
        this.applicationURIs = applicationURIs;
    }

    public void create() throws Exception {
        if (this.deployersURI == null) {
            throw new IllegalStateException("Null deployers uri.");
        }
        if (this.applicationURIs == null) {
            throw new IllegalStateException("Null application uris.");
        }
    }

    @Override
    protected void createProfileMetaData(ProfileKey rootKey, URL url) throws Exception {
        if (rootKey == null) {
            throw new IllegalArgumentException("Null root profile key.");
        }
        String[] subprofileNames = new String[]{};
        if (this.bindingsURI != null) {
            ProfileKey bindingsKey = new ProfileKey(this.bindingsName);
            FilteredProfileMetaData bindings = new FilteredProfileMetaData(null, null, this.bindingsName);
            bindings.setSource(this.createSource(new URI[]{this.bindingsURI}, false));
            this.addProfile(bindingsKey, bindings);
            subprofileNames = new String[]{this.bindingsName};
        }
        if (this.bootstrapURI != null) {
            ProfileKey bootstrapKey = new ProfileKey(this.bootstrapName);
            ProfileMetaData bootstrap = this.createProfileMetaData(this.bootstrapName, false, new URI[]{this.bootstrapURI}, subprofileNames);
            this.addProfile(bootstrapKey, bootstrap);
            subprofileNames = StaticProfileFactory.createSubprofileNames(subprofileNames, this.bootstrapName);
        }
        ProfileKey deployersKey = new ProfileKey(this.deployersName);
        ProfileMetaData deployers = this.createProfileMetaData(this.deployersName, false, new URI[]{this.deployersURI}, subprofileNames);
        this.addProfile(deployersKey, deployers);
        subprofileNames = StaticProfileFactory.createSubprofileNames(subprofileNames, this.deployersName);
        String[] rootSubProfiles = this.createApplicationProfiles(subprofileNames);
        EmptyProfileMetaData root = new EmptyProfileMetaData(null, null, rootKey.getName(), this.createSubProfileMetaData(rootSubProfiles));
        this.addProfile(rootKey, root);
    }

    protected String[] createApplicationProfiles(String[] applicationsSubProfiles) {
        return new String[]{this.createApplicationProfile(applicationsSubProfiles)};
    }

    protected String createApplicationProfile(String[] applicationsSubProfiles) {
        ProfileKey applicationsKey = new ProfileKey(this.applicationsName);
        URI[] applicationURIs = this.getApplicationURIs().toArray(new URI[this.getApplicationURIs().size()]);
        ProfileMetaData applications = this.createProfileMetaData(this.applicationsName, true, applicationURIs, applicationsSubProfiles);
        this.addProfile(applicationsKey, applications);
        return this.applicationsName;
    }

    protected ProfileMetaData createProfileMetaData(String name, boolean isHotDeployment, URI[] uris, String[] subProfiles) {
        BasicProfileMetaData metaData = new BasicProfileMetaData(null, null, name);
        metaData.setSource(this.createSource(uris, isHotDeployment));
        metaData.setSubprofiles(this.createSubProfileMetaData(subProfiles));
        return metaData;
    }

    protected List<SubProfileMetaData> createSubProfileMetaData(String[] subProfiles) {
        ArrayList<SubProfileMetaData> subProfileList = new ArrayList<SubProfileMetaData>();
        if (subProfiles != null && subProfiles.length > 0) {
            for (String profileName : subProfiles) {
                subProfileList.add(new BasicSubProfileMetaData(null, null, profileName));
            }
        }
        return subProfileList;
    }

    protected ProfileSourceMetaData createSource(URI[] uris, boolean isHotDeployment) {
        AbstractProfileSourceMetaData source = null;
        source = isHotDeployment ? new HotDeploymentProfileSourceMetaData() : new ImmutableProfileSourceMetaData();
        ArrayList<String> sources = new ArrayList<String>();
        for (URI uri : uris) {
            sources.add(uri.toString());
        }
        source.setSources(sources);
        return source;
    }

    private static String[] createSubprofileNames(String[] existing, String toAdd) {
        String[] subprofileNames = new String[existing.length + 1];
        System.arraycopy(existing, 0, subprofileNames, 0, existing.length);
        subprofileNames[subprofileNames.length - 1] = toAdd;
        return subprofileNames;
    }
}

