/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */ 
package org.jboss.system.server.profileservice.repository;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.vfs.VirtualFile;

/**
 * Basic ProfileDeploymentFactory.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 101688 $
 */
public class DefaultProfileDeploymentFactory extends AutoUnmounter
{

   /** The instance. */
   private static final DefaultProfileDeploymentFactory INSTANCE = new DefaultProfileDeploymentFactory();

   public static String createDeploymentName(VirtualFile original) throws URISyntaxException
   {
      return createDeploymentName(original.toURI());
   }
   
   public static String createDeploymentName(URI uri)
   {
      // Always use the name without the "/"
      String name = uri.toString();
      if(name.endsWith("/"))
         return name.substring(0, name.length() -1);
      return name;
   }
   
   protected DefaultProfileDeploymentFactory()
   {
      //
   }
   
   public static DefaultProfileDeploymentFactory getInstance()
   {
      return INSTANCE;
   }
   
   public ProfileDeployment createProfileDeployment(String name)
   {
      return new AbstractProfileDeployment(name);
   }
   
   @Deprecated
   public ProfileDeployment createProfileDeployment(VirtualFile vf) throws URISyntaxException 
   {
      String name = createDeploymentName(vf);
      return new AbstractProfileDeployment(name, vf);
   }
   
   public ProfileDeployment createProfileDeployment(String profileName, String name, VirtualFile original) throws IOException
   {
      VirtualFile copy = backup(profileName, name, original);
      return new AbstractProfileDeployment(name, copy);
   }

   /**
    * Cleanup the deployment
    */
   public void cleanup(String deploymentName) throws IOException
   {
      super.cleanup(deploymentName);
   }
   
}

