/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import java.util.ArrayList;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;

public class InconsistentRepositoryStructureException
extends Exception {
    private static final long serialVersionUID = 8104994059142991240L;

    public InconsistentRepositoryStructureException(RepositoryContentMetadata base, RepositoryContentMetadata other) {
        super(InconsistentRepositoryStructureException.buildExceptionMessage(base, other));
    }

    private static String buildExceptionMessage(RepositoryContentMetadata base, RepositoryContentMetadata other) {
        ArrayList<String> missing = new ArrayList<String>();
        for (RepositoryRootMetadata root : base.getRepositories()) {
            RepositoryRootMetadata otherRoot = other.getRepositoryRootMetadata(root.getName());
            if (otherRoot != null) continue;
            missing.add(root.getName());
        }
        ArrayList<String> extra = new ArrayList<String>();
        for (RepositoryRootMetadata root : other.getRepositories()) {
            RepositoryRootMetadata baseRoot = base.getRepositoryRootMetadata(root.getName());
            if (baseRoot != null) continue;
            extra.add(root.getName());
        }
        StringBuilder sb = new StringBuilder("Inconsistent structure between repositories");
        if (missing.size() > 0) {
            sb.append("; Other repository is missing roots ");
            boolean first = true;
            for (String name : missing) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(name);
            }
        }
        if (extra.size() > 0) {
            sb.append("; Other repository has extra roots ");
            boolean first = true;
            for (String name : extra) {
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(name);
            }
        }
        return sb.toString();
    }
}

