/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.JBossSecurityMgrRealm;
import org.jboss.web.tomcat.security.JaccContextValve;
import org.jboss.web.tomcat.security.SecurityAssociationActions;
import org.jboss.web.tomcat.security.SecurityAssociationValve;

public class JaccAuthorizationRealm
extends JBossSecurityMgrRealm {
    static Logger log = Logger.getLogger(JaccAuthorizationRealm.class);
    private static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
    private static ThreadLocal activeRequest = new ThreadLocal();
    private boolean trace;
    private Policy policy = Policy.getPolicy();
    private boolean unprotectedResourceDelegation = false;
    private String securityConstraintProviderClass = "";

    public JaccAuthorizationRealm() {
        this.trace = log.isTraceEnabled();
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] securityConstraints, Context context) throws IOException {
        Wrapper servlet = request.getWrapper();
        if (servlet != null) {
            activeRequest.set(this.getServletName(servlet));
        }
        Principal requestPrincipal = request.getPrincipal();
        HttpServletRequest httpRequest = request.getRequest();
        String uri = JaccAuthorizationRealm.requestURI(request);
        WebResourcePermission perm = new WebResourcePermission(uri, httpRequest.getMethod());
        boolean allowed = this.checkSecurityAssociation((Permission)perm, requestPrincipal);
        if (this.trace) {
            log.trace((Object)("hasResourcePermission, perm=" + perm + ", allowed=" + allowed));
        }
        if (!allowed) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return allowed;
    }

    public boolean hasRole(Principal principal, String name) {
        String servletName = (String)activeRequest.get();
        JBossWebMetaData metaData = SecurityAssociationValve.activeWebMetaData.get();
        SecurityRoleRefsMetaData roleRefs = metaData.getSecurityRoleRefs(servletName);
        String roleName = name;
        if (roleRefs != null) {
            for (SecurityRoleRefMetaData ref : roleRefs) {
                if (!ref.getRoleLink().equals(name)) continue;
                roleName = ref.getName();
                break;
            }
        }
        WebRoleRefPermission perm = new WebRoleRefPermission(servletName, roleName);
        Principal[] principals = new Principal[]{principal};
        Set roles = this.getPrincipalRoles(principal);
        if (roles != null) {
            principals = new Principal[roles.size()];
            roles.toArray(principals);
        }
        boolean allowed = this.checkSecurityAssociation((Permission)perm, principals);
        if (this.trace) {
            log.trace((Object)("hasRole, perm=" + perm + ", allowed=" + allowed));
        }
        return allowed;
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        boolean ok;
        block4: {
            HttpServletRequest httpRequest = request.getRequest();
            Principal requestPrincpal = request.getPrincipal();
            this.establishSubjectContext(requestPrincpal);
            String uri = JaccAuthorizationRealm.requestURI(request);
            WebUserDataPermission perm = new WebUserDataPermission(uri, httpRequest.getMethod());
            if (this.trace) {
                log.trace((Object)("hasUserDataPermission, p=" + perm));
            }
            ok = false;
            try {
                Principal[] principals = null;
                ok = this.checkSecurityAssociation((Permission)perm, principals);
            }
            catch (Exception e) {
                if (!this.trace) break block4;
                log.trace((Object)"Failed to checkSecurityAssociation", (Throwable)e);
            }
        }
        if (!ok) {
            ok = super.hasUserDataPermission(request, response, constraints);
        }
        return ok;
    }

    public String getSecurityConstraintProviderClass() {
        return this.securityConstraintProviderClass;
    }

    public void setSecurityConstraintProviderClass(String securityConstraintProviderClass) {
        this.securityConstraintProviderClass = securityConstraintProviderClass;
    }

    public boolean isUnprotectedResourceDelegation() {
        return this.unprotectedResourceDelegation;
    }

    public void setUnprotectedResourceDelegation(boolean unprotectedResourceDelegation) {
        this.unprotectedResourceDelegation = unprotectedResourceDelegation;
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        SecurityConstraint[] scarr = super.findSecurityConstraints(request, context);
        if ((scarr == null || scarr.length == 0) && this.unprotectedResourceDelegation) {
            scarr = this.getSecurityConstraintsFromProvider(request, context);
        }
        return scarr;
    }

    private boolean checkSecurityAssociation(Permission perm, Principal requestPrincpal) {
        Subject caller = this.establishSubjectContext(requestPrincpal);
        Principal[] principals = null;
        if (caller != null) {
            if (this.trace) {
                log.trace((Object)"No active subject found, using ");
            }
            Set<Principal> principalsSet = caller.getPrincipals();
            principals = new Principal[principalsSet.size()];
            principalsSet.toArray(principals);
        }
        return this.checkSecurityAssociation(perm, principals);
    }

    private boolean checkSecurityAssociation(Permission perm, Principal[] principals) {
        CodeSource webCS = JaccContextValve.activeCS.get();
        ProtectionDomain pd = new ProtectionDomain(webCS, null, null, principals);
        boolean allowed = this.policy.implies(pd, perm);
        if (this.trace) {
            String msg = (allowed ? "Allowed: " : "Denied: ") + perm;
            log.trace((Object)msg);
        }
        return allowed;
    }

    private Subject establishSubjectContext(Principal principal) {
        Subject caller;
        block4: {
            caller = null;
            try {
                caller = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
            }
            catch (PolicyContextException e) {
                if (!this.trace) break block4;
                log.trace((Object)"Failed to get subject from PolicyContext", (Throwable)e);
            }
        }
        if (caller == null && principal instanceof JBossGenericPrincipal) {
            JBossGenericPrincipal jgp = (JBossGenericPrincipal)((Object)principal);
            caller = jgp.getSubject();
            if (this.trace) {
                log.trace((Object)"Restoring principal info from cache");
            }
            SecurityAssociationActions.setPrincipalInfo(jgp.getAuthPrincipal(), jgp.getCredentials(), jgp.getSubject());
        }
        return caller;
    }

    private String getServletName(Wrapper servlet) {
        String[] mappings = servlet.findMappings();
        if (this.trace) {
            log.trace((Object)("[getServletName:servletmappings=" + mappings + ":servlet.getName()=" + servlet.getName() + "]"));
        }
        if ("jsp".equals(servlet.getName()) && mappings != null && mappings[0].indexOf("*.jsp") > -1) {
            return "";
        }
        return servlet.getName();
    }

    private SecurityConstraint[] getSecurityConstraintsFromProvider(Request request, Context context) {
        Method findsc;
        Object[] args;
        Class[] sig;
        SecurityConstraint[] scarr;
        block9: {
            scarr = null;
            sig = new Class[]{Request.class, Context.class};
            args = new Object[]{request, context};
            findsc = null;
            try {
                findsc = this.policy.getClass().getMethod("findSecurityConstraints", sig);
                scarr = (SecurityConstraint[])findsc.invoke((Object)this.policy, args);
            }
            catch (Throwable t) {
                if (!this.trace) break block9;
                log.error((Object)"Error obtaining security constraints from policy", t);
            }
        }
        if (scarr == null || scarr.length == 0) {
            if (this.securityConstraintProviderClass == "" || this.securityConstraintProviderClass.length() == 0) {
                if (this.trace) {
                    log.trace((Object)"unprotectedResourceDelegation is true but securityConstraintProviderClass is empty");
                }
            } else {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.securityConstraintProviderClass);
                    Object obj = clazz.newInstance();
                    findsc = clazz.getMethod("findSecurityConstraints", sig);
                    if (this.trace) {
                        log.trace((Object)"findSecurityConstraints method found in securityConstraintProviderClass");
                    }
                    scarr = (SecurityConstraint[])findsc.invoke(obj, args);
                }
                catch (Throwable t) {
                    log.error((Object)("Error instantiating " + this.securityConstraintProviderClass), t);
                }
            }
        }
        return scarr;
    }

    static String requestURI(Request request) {
        String uri = request.getMappingData().requestPath.getString();
        if (uri == null || uri.equals("/")) {
            uri = "";
        }
        return uri;
    }
}

