/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.InstanceManager;
import org.apache.catalina.Context;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.deployers.JBoss5DependencyPolicy;
import org.jboss.ejb3.enc.DeploymentPersistenceUnitResolver;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.javaee.AbstractJavaEEComponent;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.ejb3.javaee.SimpleJavaEEModule;
import org.jboss.injection.DependsHandler;
import org.jboss.injection.EJBHandler;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.PersistenceContextHandler;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.injection.ResourceHandler;
import org.jboss.injection.WebServiceRefHandler;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.WebApplication;
import org.jboss.web.tomcat.service.WarEjbResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatInjectionContainer
extends AbstractJavaEEComponent
implements InjectionContainer,
InstanceManager {
    private static final Logger log = Logger.getLogger(TomcatInjectionContainer.class);
    protected EncMap encInjectors = new EncMap();
    protected Map<String, Map<AccessibleObject, Injector>> encInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    protected Map<String, Map<AccessibleObject, Injector>> resolvedClassInjections = new HashMap<String, Map<AccessibleObject, Injector>>();
    protected List<PersistenceUnitDeployment> persistenceUnitDeployments = new ArrayList<PersistenceUnitDeployment>();
    protected LinkedHashMap ejbContainers = new LinkedHashMap();
    protected DeploymentPersistenceUnitResolver persistenceUnitResolver;
    protected WarEjbResolver ejbResolver;
    protected DependencyPolicy dependencyPolicy = new JBoss5DependencyPolicy((JavaEEComponent)this);
    protected Collection<InjectionHandler<Environment>> handlers;
    protected VFSDeploymentUnit unit;
    protected ClassLoader webLoader;
    protected WebApplication appInfo;
    protected JBossWebMetaData webDD;
    protected Context catalinaContext;

    public TomcatInjectionContainer(WebApplication appInfo, VFSDeploymentUnit unit, Context catalinaContext, MainDeployerStructure mainDeployer) {
        super((JavaEEModule)new SimpleJavaEEModule(appInfo.getName()));
        this.unit = unit;
        DeploymentScope deploymentScope = null;
        this.appInfo = appInfo;
        this.catalinaContext = catalinaContext;
        this.persistenceUnitResolver = new DeploymentPersistenceUnitResolver(this.persistenceUnitDeployments, deploymentScope, this.ejbContainers);
        this.ejbResolver = new WarEjbResolver(deploymentScope, unit, mainDeployer);
        this.webDD = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        assert (this.webDD != null) : "webDD is null (no JBossWebMetaData attachment in VFSDeploymentUnit)";
    }

    public Environment getEnvironmentRefGroup() {
        return this.webDD.getJndiEnvironmentRefsGroup();
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        ClassLoader loader = this.catalinaContext.getLoader().getClassLoader();
        Class<?> clazz = loader.loadClass(className);
        Object instance = clazz.newInstance();
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.processAnnotations(instance);
            this.postConstruct(instance);
        }
        return instance;
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        Object instance = clazz.newInstance();
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.processAnnotations(instance);
            this.postConstruct(instance);
        }
        return instance;
    }

    public void newInstance(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.processAnnotations(instance);
            this.postConstruct(instance);
        }
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        if (!this.catalinaContext.getIgnoreAnnotations()) {
            this.preDestroy(instance);
        }
    }

    public void postConstruct(Object object) throws IllegalAccessException, InvocationTargetException {
    }

    public void preDestroy(Object object) throws IllegalAccessException, InvocationTargetException {
    }

    public void processAnnotations(Object object) throws IllegalAccessException, InvocationTargetException, NamingException {
        Map injectors;
        if (log.isTraceEnabled()) {
            log.trace((Object)("**************** Processing annotations for: " + object.getClass().getName()));
        }
        if ((injectors = this.resolvedClassInjections.get(object.getClass().getName())) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"-- there was no prior annotation preprocessing done");
            }
            this.encInjectors.recordAdded();
            injectors = InjectionUtil.processAnnotations((InjectionContainer)this, this.handlers, object.getClass());
            this.resolvedClassInjections.put(object.getClass().getName(), injectors);
            if (this.encInjectors.getAdded().size() > 0) {
                for (EncInjector encInjector : this.encInjectors.getAdded().values()) {
                    encInjector.inject((InjectionContainer)this);
                }
                this.encInjectors.clearAdded();
            }
        }
        if (injectors == null || injectors.size() == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("-- no injectors found: " + injectors));
            }
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"-- doing injections");
        }
        for (Injector injector : injectors.values()) {
            injector.inject(object);
        }
    }

    public void populateEnc(ClassLoader loader) {
        for (EncInjector injector : this.encInjectors.values()) {
            injector.inject((InjectionContainer)this);
        }
    }

    private void processClass(String className, ClassLoader webLoader) throws ClassNotFoundException {
        if (this.resolvedClassInjections.containsKey(className)) {
            return;
        }
        Class<?> cls = webLoader.loadClass(className);
        Map tmp = InjectionUtil.processAnnotations((InjectionContainer)this, this.handlers, cls);
        this.resolvedClassInjections.put(className, tmp);
    }

    private void processFilters(FiltersMetaData filters, ClassLoader webLoader) {
        if (filters == null) {
            return;
        }
        for (FilterMetaData filter : filters) {
            try {
                this.processClass(filter.getFilterClass(), webLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("could not find filter class in classpath", e);
            }
        }
    }

    private void processListeners(List<ListenerMetaData> listeners, ClassLoader webLoader) {
        if (listeners == null) {
            return;
        }
        for (ListenerMetaData listener : listeners) {
            try {
                this.processClass(listener.getListenerClass(), webLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("could not find listener class in classpath", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMetadata() {
        this.handlers = new ArrayList<InjectionHandler<Environment>>();
        this.handlers.add((InjectionHandler<Environment>)new EJBHandler());
        this.handlers.add((InjectionHandler<Environment>)new DependsHandler());
        this.handlers.add((InjectionHandler<Environment>)new PersistenceContextHandler());
        this.handlers.add((InjectionHandler<Environment>)new PersistenceUnitHandler());
        this.handlers.add((InjectionHandler<Environment>)new ResourceHandler());
        this.handlers.add((InjectionHandler<Environment>)new WebServiceRefHandler());
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ClassLoader webLoader = this.getClassloader();
        Thread.currentThread().setContextClassLoader(webLoader);
        try {
            for (InjectionHandler<Environment> handler : this.handlers) {
                handler.loadXml((RemoteEnvironment)this.webDD.getJndiEnvironmentRefsGroup(), (InjectionContainer)this);
            }
            this.processServlets(this.webDD.getServlets(), webLoader);
            this.processFilters(this.webDD.getFilters(), webLoader);
            this.processListeners(this.webDD.getListeners(), webLoader);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void processServlets(JBossServletsMetaData servlets, ClassLoader webLoader) {
        if (servlets == null) {
            return;
        }
        for (JBossServletMetaData servlet : servlets) {
            try {
                if (servlet.getServletClass() == null) continue;
                this.processClass(servlet.getServletClass(), webLoader);
            }
            catch (ClassNotFoundException e) {
                log.warn((Object)("could not find servlet class " + servlet.getServletClass() + " in classpath when processing annotations."));
            }
        }
    }

    public Map<String, EncInjector> getEncInjectors() {
        return this.encInjectors;
    }

    public Map<String, Map<AccessibleObject, Injector>> getEncInjections() {
        return this.encInjections;
    }

    public List<Injector> getInjectors() {
        return new ArrayList<Injector>();
    }

    public VirtualFile getRootFile() {
        return this.unit.getRoot();
    }

    public String getIdentifier() {
        return this.unit.getSimpleName();
    }

    public String getDeploymentDescriptorType() {
        return "web.xml";
    }

    public ClassLoader getClassloader() {
        return this.webLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.webLoader = loader;
    }

    public javax.naming.Context getEnc() {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClassloader());
            try {
                javax.naming.Context context = (javax.naming.Context)new InitialContext().lookup("java:comp");
                return context;
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        return this.persistenceUnitResolver.getPersistenceUnitDeployment(unitName);
    }

    public boolean hasJNDIBinding(String jndiName) {
        return false;
    }

    public Container resolveEjbContainer(String link, Class<?> businessIntf) {
        return this.ejbResolver.getEjbContainer(link, businessIntf);
    }

    public Container resolveEjbContainer(Class<?> businessIntf) throws NameNotFoundException {
        return this.ejbResolver.getEjbContainer(businessIntf);
    }

    public String getEjbJndiName(Class<?> businessInterface) throws NameNotFoundException {
        return this.ejbResolver.getEjbJndiName(businessInterface);
    }

    public String getEjbJndiName(String link, Class<?> businessInterface) {
        return this.ejbResolver.getEjbJndiName(link, businessInterface);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz) {
        return clazz.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Method method) {
        return method.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Method method) {
        return method.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Class<?> clazz, Field field) {
        return field.getAnnotation(annotationType);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType, Field field) {
        return field.getAnnotation(annotationType);
    }

    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    public String resolveMessageDestination(String link) {
        if (this.webDD.getMessageDestinationReferences() == null) {
            return null;
        }
        for (MessageDestinationReferenceMetaData current : this.webDD.getMessageDestinationReferences()) {
            if (!link.equals(current.getLink())) continue;
            return current.getMessageDestinationRefName();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EncMap
    extends HashMap<String, EncInjector> {
        private HashMap<String, EncInjector> added;

        private EncMap() {
        }

        public void recordAdded() {
            this.added = new HashMap();
        }

        public void clearAdded() {
            this.added = null;
        }

        public Map<String, EncInjector> getAdded() {
            return this.added;
        }

        @Override
        public EncInjector put(String key, EncInjector value) {
            if (this.added != null) {
                this.added.put(key, value);
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends EncInjector> m) {
            if (this.added != null) {
                this.added.putAll(m);
            }
            super.putAll(m);
        }
    }
}

