/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.util.ArrayList;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.ReplicationConfig;

public class ClusteringDependencyDeployer
extends AbstractDeployer {
    private String clusterCacheDependency;

    public ClusteringDependencyDeployer() {
        this.setStage(DeploymentStages.DESCRIBE);
        this.setInput(JBossWebMetaData.class);
        this.setOutput(JBossWebMetaData.class);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        JBossWebMetaData metaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (metaData != null && metaData.getDistributable() != null) {
            String cacheName;
            ReplicationConfig rpcfg = metaData.getReplicationConfig();
            String string = cacheName = rpcfg == null ? null : rpcfg.getCacheName();
            if (cacheName == null) {
                cacheName = this.clusterCacheDependency;
            }
            this.log.debug((Object)("Adding dependency on " + cacheName + " to " + unit.getName()));
            ArrayList<String> depends = metaData.getDepends();
            if (depends == null) {
                depends = new ArrayList<String>();
            }
            if (!depends.contains(cacheName)) {
                depends.add(cacheName);
            }
            metaData.setDepends(depends);
        }
    }

    public String getClusterCacheDependency() {
        return this.clusterCacheDependency;
    }

    public void setClusterCacheDependency(String clusterDependency) {
        this.clusterCacheDependency = clusterDependency;
    }
}

