/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.apache.catalina.Container;
import org.jboss.aspects.patterns.observable.Observer;
import org.jboss.aspects.patterns.observable.Subject;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheAlreadyDetachedException;
import org.jboss.cache.pojo.jmx.PojoCacheJmxWrapperMBean;
import org.jboss.cache.transaction.BatchModeTransactionManager;
import org.jboss.invocation.MarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.serial.io.MarshalledObject;
import org.jboss.web.tomcat.service.session.CacheListener;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.JBossCacheWrapper;
import org.jboss.web.tomcat.service.session.PassivationListener;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.service.session.SessionSerializationFactory;
import org.jboss.web.tomcat.service.session.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheService {
    protected static Logger log_ = Logger.getLogger(JBossCacheService.class);
    public static final String BUDDY_BACKUP = "_BUDDY_BACKUP_";
    public static final Fqn BUDDY_BACKUP_FQN = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN;
    public static final String SESSION = "JSESSION";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    static final String VERSION_KEY = "VERSION";
    static final String FQN_DELIMITER = "/";
    private PojoCache pojoCache_;
    private Cache plainCache_;
    private ObjectName cacheServiceName_;
    private String hostName_;
    private String webAppPath_;
    private TransactionManager tm;
    private JBossCacheManager manager_;
    private CacheListener cacheListener_;
    private JBossCacheWrapper cacheWrapper_;
    private boolean useTreeCacheMarshalling_ = false;
    private boolean usePassivation_ = false;
    private WeakHashMap typeMap = new WeakHashMap();

    public JBossCacheService(PojoCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        this.pojoCache_ = cache;
        this.init();
    }

    public JBossCacheService(String treeCacheObjectName) throws ClusteringNotSupportedException {
        try {
            this.cacheServiceName_ = new ObjectName(treeCacheObjectName);
            PojoCacheJmxWrapperMBean mbean = (PojoCacheJmxWrapperMBean)MBeanProxyExt.create(PojoCacheJmxWrapperMBean.class, (ObjectName)this.cacheServiceName_);
            if (mbean != null) {
                this.pojoCache_ = mbean.getPojoCache();
            }
        }
        catch (Throwable t) {
            String str = "Could not access TreeCache service " + (this.cacheServiceName_ == null ? "<null>" : this.cacheServiceName_.toString()) + " for Tomcat clustering";
            log_.debug((Object)str);
            throw new ClusteringNotSupportedException(str, t);
        }
        if (this.pojoCache_ == null) {
            String str = "Could not access TreeCache service " + (this.cacheServiceName_ == null ? "<null>" : this.cacheServiceName_.toString()) + " for Tomcat clustering";
            log_.debug((Object)str);
            throw new ClusteringNotSupportedException(str);
        }
        this.init();
    }

    private void init() {
        this.plainCache_ = this.pojoCache_.getCache();
        this.cacheWrapper_ = new JBossCacheWrapper(this.pojoCache_);
        this.useTreeCacheMarshalling_ = this.plainCache_.getConfiguration().isUseRegionBasedMarshalling();
        CacheLoaderConfig clc = this.plainCache_.getConfiguration().getCacheLoaderConfig();
        if (clc != null) {
            this.usePassivation_ = clc.isPassivation() && !clc.isShared();
        }
    }

    public void start(ClassLoader tcl, JBossCacheManager manager) {
        this.manager_ = manager;
        Container webapp = this.manager_.getContainer();
        String path = webapp.getName();
        this.webAppPath_ = path.length() == 0 || path.equals(FQN_DELIMITER) ? "ROOT" : (path.startsWith(FQN_DELIMITER) ? path.substring(1) : path);
        this.webAppPath_ = this.webAppPath_.replace('/', '?');
        log_.debug((Object)("Old and new web app path are: " + path + ", " + this.webAppPath_));
        String host = webapp.getParent().getName();
        this.hostName_ = host == null || host.length() == 0 ? "localhost" : host;
        log_.debug((Object)("Old and new virtual host name are: " + host + ", " + this.hostName_));
        this.cacheListener_ = new CacheListener(this.cacheWrapper_, this.manager_, this.hostName_, this.webAppPath_);
        this.plainCache_.addCacheListener((Object)this.cacheListener_);
        if (this.useTreeCacheMarshalling_) {
            try {
                Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
                Fqn pathFqn = new Fqn(objs);
                log_.debug((Object)("UseMarshalling is true. We will register the fqn: " + pathFqn + " with class loader" + tcl + " and activate the webapp's Region"));
                Region region = this.plainCache_.getRegion(pathFqn, true);
                region.registerContextClassLoader(tcl);
                region.activate();
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't register class loader", ex);
            }
        }
        this.tm = this.plainCache_.getConfiguration().getRuntimeConfig().getTransactionManager();
        if (!(this.tm instanceof BatchModeTransactionManager)) {
            throw new RuntimeException("JBossCacheService.start(): JBossCacheAop transaction manager is not of type BatchModeTransactionManager. Please check the jboss-web-cluster-service.xml TransactionManagerClassLookup field.");
        }
        if (this.manager_.isPassivationEnabled()) {
            log_.debug((Object)"Passivation is enabled");
            PassivationListener pl = new PassivationListener(this.manager_, this.hostName_, this.webAppPath_);
            this.plainCache_.addCacheListener((Object)pl);
            this.initializeFieldGranularityEviction();
        } else {
            log_.debug((Object)"Passivation is disabled");
        }
    }

    public void stop() {
        this.plainCache_.removeCacheListener((Object)this.cacheListener_);
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        Fqn pathFqn = new Fqn(objs);
        if (this.useTreeCacheMarshalling_) {
            log_.debug((Object)("UseMarshalling is true. We will inactivate the fqn: " + pathFqn + " and un-register its classloader"));
            try {
                Region region = this.plainCache_.getRegion(pathFqn, false);
                if (region != null) {
                    region.deactivate();
                    region.unregisterContextClassLoader();
                }
            }
            catch (Exception e) {
                log_.error((Object)("Exception during inactivation of webapp region " + pathFqn + " or un-registration of its class loader"), (Throwable)e);
            }
        }
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean isMarshallingAvailable() {
        return this.useTreeCacheMarshalling_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredSession loadSession(String realId, ClusteredSession toLoad) {
        Integer ver;
        Fqn fqn = this.getSessionFqn(realId);
        Object sessionData = this.cacheWrapper_.get(fqn, realId, true);
        if (sessionData == null) {
            return null;
        }
        boolean firstLoad = toLoad.getVersion() == 0;
        byte[] sessionBytes = (byte[])sessionData;
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.manager_.getWebappClassLoader());
        try {
            ObjectInputStream input = SessionSerializationFactory.createObjectInputStream(sessionBytes);
            toLoad.readExternal(input);
            input.close();
        }
        catch (Exception e) {
            log_.error((Object)("loadSession(): id: " + realId + " exception occurred during deserialization"), (Throwable)e);
            ClusteredSession clusteredSession = null;
            return clusteredSession;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevTCL);
        }
        if (firstLoad && (ver = (Integer)this.cacheWrapper_.get(fqn, VERSION_KEY)) != null) {
            toLoad.setVersion(ver);
        }
        return toLoad;
    }

    public void putSession(String realId, ClusteredSession session) {
        Fqn fqn = this.getSessionFqn(realId);
        if (session.getReplicateSessionBody()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(realId, this.externalizeSession(session));
            map.put(VERSION_KEY, new Integer(session.getVersion()));
            this.cacheWrapper_.put(fqn, map);
        } else {
            this.cacheWrapper_.put(fqn, VERSION_KEY, new Integer(session.getVersion()));
        }
    }

    public void removeSession(String realId) {
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove session from distributed store. Fqn: " + fqn));
        }
        this.cacheWrapper_.remove(fqn);
    }

    public void removeSessionLocal(String realId) {
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
        }
        this.cacheWrapper_.removeLocalSubtree(fqn);
    }

    public void removeSessionLocal(String realId, String dataOwner) {
        if (dataOwner == null) {
            this.removeSessionLocal(realId);
        } else {
            Fqn fqn = this.getSessionFqn(realId, dataOwner);
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
            }
            this.cacheWrapper_.removeLocalSubtree(fqn);
        }
    }

    public void evictSession(String realId) {
        this.evictSession(realId, null);
    }

    public void evictSession(String realId, String dataOwner) {
        Fqn fqn;
        Fqn fqn2 = fqn = dataOwner == null ? this.getSessionFqn(realId) : this.getSessionFqn(realId, dataOwner);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("evictSession(): evicting session from my distributed store. Fqn: " + fqn));
        }
        this.cacheWrapper_.evictSubtree(fqn);
    }

    public boolean exists(String realId) {
        Fqn fqn = this.getSessionFqn(realId);
        return this.plainCache_.getRoot().hasChild(fqn);
    }

    public Object getAttribute(String realId, String key) {
        Fqn fqn = this.getAttributeFqn(realId);
        return this.getUnMarshalledValue(this.cacheWrapper_.get(fqn, key));
    }

    public void putAttribute(String realId, String key, Object value) {
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.put(fqn, key, this.getMarshalledValue(value));
    }

    public void putAttribute(String realId, Map map) {
        HashMap marshalled = new HashMap(map.size());
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            marshalled.put(entry.getKey(), this.getMarshalledValue(entry.getValue()));
        }
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.put(fqn, marshalled);
    }

    public void removeAttributes(String realId) {
        Fqn fqn = this.getAttributeFqn(realId);
        this.cacheWrapper_.remove(fqn);
    }

    public Object removeAttribute(String realId, String key) {
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        return this.getUnMarshalledValue(this.cacheWrapper_.remove(fqn, key));
    }

    public void removeAttributesLocal(String realId) {
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("Remove attributes from my own distributed store only. Fqn: " + fqn));
        }
        this.cacheWrapper_.removeLocal(fqn);
    }

    public Set getAttributeKeys(String realId) {
        Set keys = null;
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            Node node = this.plainCache_.getRoot().getChild(fqn);
            if (node != null) {
                keys = node.getKeys();
            }
        }
        catch (CacheException e) {
            log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Map getAttributes(String realId) {
        if (realId == null || realId.length() == 0) {
            return new HashMap();
        }
        HashMap attrs = new HashMap();
        Fqn fqn = this.getAttributeFqn(realId);
        Node node = this.plainCache_.getRoot().getChild(fqn);
        Map rawData = node.getData();
        if (rawData.size() == 0) {
            this.plainCache_.get(fqn, new Object());
            rawData = node.getData();
        }
        for (Map.Entry entry : rawData.entrySet()) {
            attrs.put(entry.getKey(), this.getUnMarshalledValue(entry.getValue()));
        }
        return attrs;
    }

    public Map<String, String> getSessionIds() throws CacheException {
        Set owners;
        HashMap<String, String> result = new HashMap<String, String>();
        Node bbRoot = this.plainCache_.getRoot().getChild(BUDDY_BACKUP_FQN);
        if (bbRoot != null && (owners = bbRoot.getChildren()) != null) {
            for (Node owner : owners) {
                Node webRoot = owner.getChild(this.getWebappFqn());
                if (webRoot == null) continue;
                Set ids = webRoot.getChildrenNames();
                this.storeSessionOwners(ids, owner.getFqn().getLastElement(), result);
            }
        }
        this.storeSessionOwners(this.getChildrenNames(this.getWebappFqn()), null, result);
        return result;
    }

    private Set getChildrenNames(Fqn fqn) {
        Node node = this.plainCache_.getRoot().getChild(fqn);
        return node == null ? null : node.getChildrenNames();
    }

    private void storeSessionOwners(Set ids, Object owner, Map map) {
        if (ids != null) {
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                map.put(it.next(), owner);
            }
        }
    }

    public Object setPojo(String realId, String key, Object pojo) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("setPojo(): session id: " + realId + " key: " + key + " object: " + pojo.toString()));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            Object object = this.pojoCache_.attach(fqn.toString(), pojo);
            return object;
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache setPojo ... ", e);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    public Object removePojo(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojo(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            Object object = this.pojoCache_.detach(fqn.toString());
            return object;
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache removePojo ... ", e);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojosLocal(String realId) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojoLocal(): session id: " + realId));
        }
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            SessionReplicationContext.startCacheActivity();
            this.cacheWrapper_.removeLocalSubtree(fqn);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojoLocal(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojoLocal(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            this.cacheWrapper_.removeLocalSubtree(fqn);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    public Set getPojoKeys(String realId) {
        Set keys = null;
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            keys = this.getChildrenNames(fqn);
        }
        catch (CacheException e) {
            log_.error((Object)("getPojoKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Object getPojo(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("getPojo(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            return this.pojoCache_.find(fqn.toString());
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache getPojo ... ", e);
        }
    }

    public void addObserver(Observer session, Object pojo) {
        this.addObserver(session, pojo, new HashSet());
    }

    private void addObserver(Observer session, Object pojo, Set processed) {
        Class<?> type;
        Set complexFields;
        if (pojo instanceof Collection) {
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("addObserver(): pojo of type " + pojo.getClass().getName() + " is a Collection; trying to observe elements"));
            }
            Collection col = (Collection)pojo;
            Iterator i = col.iterator();
            while (i.hasNext()) {
                this.addObserver(session, i.next(), processed);
            }
        } else if (pojo instanceof Map) {
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("addObserver(): pojo of type " + pojo.getClass().getName() + " is a Map; trying to observe entries"));
            }
            for (Map.Entry entry : ((Map)pojo).entrySet()) {
                this.addObserver(session, entry.getKey(), processed);
                this.addObserver(session, entry.getValue(), processed);
            }
        }
        if (!(pojo instanceof Subject)) {
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("addObserver(): pojo of type " + pojo.getClass().getName() + " is not a Subject"));
            }
            return;
        }
        Subject subject = (Subject)pojo;
        subject.addObserver(session);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("addObserver(): session: " + session + " pojo name: " + pojo.getClass().getName()));
        }
        if ((complexFields = (Set)this.typeMap.get(type = pojo.getClass())) == null) {
            complexFields = Util.parseComplexFields(type);
            this.typeMap.put(type, complexFields);
        }
        if (complexFields.size() == 0) {
            return;
        }
        processed.add(pojo);
        block9: for (String fieldName : complexFields) {
            Class<?> curType = type;
            while (curType != null) {
                try {
                    Field field = curType.getDeclaredField(fieldName);
                    boolean accessible = field.isAccessible();
                    Object value = null;
                    try {
                        field.setAccessible(true);
                        value = field.get(pojo);
                        if (value == null || processed.contains(value)) continue block9;
                        this.addObserver(session, value, processed);
                        continue block9;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("field access failed", e);
                    }
                    finally {
                        field.setAccessible(accessible);
                        continue block9;
                    }
                }
                catch (NoSuchFieldException e) {
                    if ((curType = curType.getSuperclass()) != null) continue;
                    throw new RuntimeException("Field " + fieldName + " does not exist", e);
                }
            }
        }
    }

    public void removeObserver(Observer session, Object pojo) {
        this.removeObserver(session, pojo, new HashSet());
    }

    private void removeObserver(Observer session, Object pojo, Set stack) {
        Class<?> type;
        Set complexFields;
        if (pojo instanceof Collection) {
            Collection col = (Collection)pojo;
            for (Object obj : col) {
                this.removeObserver(session, obj, stack);
            }
            return;
        }
        if (pojo instanceof Map) {
            Map map = (Map)pojo;
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                this.removeObserver(session, key, stack);
                this.removeObserver(session, value, stack);
            }
            return;
        }
        if (!(pojo instanceof Subject)) {
            return;
        }
        Subject subject = (Subject)pojo;
        try {
            subject.removeObserver(session);
        }
        catch (PojoCacheAlreadyDetachedException e) {
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("removeObserver(): found detached in session: " + session + " pojo name: " + pojo.getClass().getName()));
            }
            return;
        }
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removeObserver(): session: " + session + " pojo name: " + pojo.getClass().getName()));
        }
        if ((complexFields = (Set)this.typeMap.get(type = pojo.getClass())) == null) {
            complexFields = Util.parseComplexFields(type);
            this.typeMap.put(type, complexFields);
        }
        if (complexFields.size() == 0) {
            return;
        }
        stack.add(pojo);
        block13: for (String fieldName : complexFields) {
            Class<?> curType = type;
            while (curType != null) {
                try {
                    Field field = curType.getDeclaredField(fieldName);
                    boolean accessible = field.isAccessible();
                    Object value = null;
                    try {
                        field.setAccessible(true);
                        value = field.get(pojo);
                        if (value == null || stack.contains(value)) continue block13;
                        this.removeObserver(session, value, stack);
                        continue block13;
                    }
                    catch (PojoCacheAlreadyDetachedException e) {
                        if (!log_.isTraceEnabled()) continue block13;
                        log_.trace((Object)("removeObserver(): found detached pojo in field " + field.getName() + " in object graph under session: " + session + " pojo name: " + pojo.getClass().getName()));
                        continue block13;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("field access failed", e);
                    }
                    finally {
                        field.setAccessible(accessible);
                        continue block13;
                    }
                }
                catch (NoSuchFieldException e) {
                    if ((curType = curType.getSuperclass()) != null) continue;
                    throw new RuntimeException("Field " + fieldName + " does not exist", e);
                }
            }
        }
    }

    public boolean isCachePassivationEnabled() {
        return this.usePassivation_;
    }

    private Fqn getFieldFqn(String id, String key) {
        return JBossCacheService.getFieldFqn(this.hostName_, this.webAppPath_, id, key);
    }

    public static Fqn getFieldFqn(String hostName, String contextPath, String sessionId, String attributeKey) {
        ArrayList<String> list = new ArrayList<String>(6);
        list.add(SESSION);
        list.add(hostName);
        list.add(contextPath);
        list.add(sessionId);
        list.add(ATTRIBUTE);
        JBossCacheService.breakKeys(attributeKey, list);
        return new Fqn(list);
    }

    private static void breakKeys(String key, List list) {
        StringTokenizer token = new StringTokenizer(key, FQN_DELIMITER);
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
    }

    private Fqn getWebappFqn() {
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        return new Fqn(objs);
    }

    private Fqn getSessionFqn(String id) {
        return JBossCacheService.getSessionFqn(this.hostName_, this.webAppPath_, id);
    }

    public static Fqn getSessionFqn(String hostname, String contextPath, String sessionId) {
        Object[] objs = new Object[]{SESSION, hostname, contextPath, sessionId};
        return new Fqn(objs);
    }

    private Fqn getSessionFqn(String id, String dataOwner) {
        return JBossCacheService.getSessionFqn(dataOwner, this.hostName_, this.webAppPath_, id);
    }

    public static Fqn getSessionFqn(String dataOwner, String hostname, String contextPath, String sessionId) {
        Object[] objs = new Object[]{BUDDY_BACKUP, dataOwner, SESSION, hostname, contextPath, sessionId};
        return new Fqn(objs);
    }

    private Fqn getAttributeFqn(String id) {
        return JBossCacheService.getAttributeFqn(this.hostName_, this.webAppPath_, id);
    }

    public static Fqn getAttributeFqn(String hostname, String contextPath, String sessionId) {
        Object[] objs = new Object[]{SESSION, hostname, contextPath, sessionId, ATTRIBUTE};
        return new Fqn(objs);
    }

    private Object getMarshalledValue(Object value) {
        try {
            if (SessionSerializationFactory.useJBossSerialization()) {
                MarshalledObject mo = SessionSerializationFactory.createMarshalledObject(value);
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)"JBoss Marshalled Object to size ");
                }
                return mo;
            }
            MarshalledValue mv = SessionSerializationFactory.createMarshalledValue(value);
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("marshalled object to size " + mv.size() + " bytes"));
            }
            return mv;
        }
        catch (IOException e) {
            log_.error((Object)"IOException occurred marshalling value ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnMarshalledValue(Object mv) {
        if (mv == null) {
            return null;
        }
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.manager_.getWebappClassLoader());
        try {
            if (SessionSerializationFactory.useJBossSerialization()) {
                Object object = ((MarshalledObject)mv).get();
                return object;
            }
            Object object = ((MarshalledValue)mv).get();
            return object;
        }
        catch (IOException e) {
            log_.error((Object)"IOException occurred unmarshalling value ", (Throwable)e);
            Object var4_7 = null;
            return var4_7;
        }
        catch (ClassNotFoundException e) {
            log_.error((Object)"ClassNotFoundException occurred unmarshalling value ", (Throwable)e);
            Object var4_8 = null;
            return var4_8;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevTCL);
        }
    }

    private byte[] externalizeSession(ClusteredSession session) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = SessionSerializationFactory.createObjectOutputStream(baos);
            session.writeExternal(oos);
            oos.close();
            byte[] bytes = baos.toByteArray();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Serialized Object to size " + bytes.length + " bytes"));
            }
            return bytes;
        }
        catch (Exception e) {
            log_.error((Object)("externalizeSession(): exception occurred externalizing session " + session), (Throwable)e);
            return null;
        }
    }

    private void initializeFieldGranularityEviction() {
        if (this.manager_.getReplicationGranularity() == ReplicationGranularity.FIELD) {
            int maxNodes = Math.max(0, this.manager_.getPassivationMaxObjects());
            int maxIdle = Math.max(0, this.manager_.getPassivationMaxObjectIdleTime());
            if (maxNodes > 0 || maxIdle > 0) {
                EvictionPolicyConfig epc = this.getEvictionPolicyConfig(maxIdle, maxNodes);
                Region region = this.plainCache_.getRegion(this.getWebappFqn(), true);
                region.setEvictionPolicy(epc);
            }
        }
    }

    private EvictionPolicyConfig getEvictionPolicyConfig(int timeToLiveSeconds, int maxNodes) {
        LRUConfiguration epc = new LRUConfiguration();
        epc.setEvictionPolicyClass(LRUPolicy.class.getName());
        epc.setTimeToLiveSeconds(timeToLiveSeconds);
        epc.setMaxNodes(maxNodes);
        return epc;
    }
}

