/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.web.tomcat.service.deployers;

import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

/**
 * Temporary workaround to support controlling the lifecycle of the webserver 
 * runtime portion of TomcatDeployer via a JMX service in the deploy directory.  
 * We want it in deploy so dependencies on services in deploy can be properly 
 * expressed. We want it as a JMX service so the ServiceBindingManager can 
 * alter the connector ports.
 * <p>
 * A more long term solution involves:
 * <ol>
 * <li>separating out the JBossWeb runtime aspects from TomcatDeployer and 
 * putting them in a separate class</li>
 * <li>developing a ProfileService-based alternative to ServiceBindingManager</li>
 * </ol>
 * </p> 
 *  
 * @author <a href="brian.stansberry@jboss.com">Brian Stansberry</a>
 * @version $Revision: 1.1 $
 */
public class TomcatDeployerWrapper 
    extends ServiceMBeanSupport
    implements TomcatDeployerWrapperMBean
{
   private TomcatDeployer tomcatDeployer;
   
   
   // Dependency inject the TomcatDeployer pojo
   
   public TomcatDeployer getTomcatDeployer()
   {
      return tomcatDeployer;
   }

   public void setTomcatDeployer(TomcatDeployer tomcatDeployer)
   {
      this.tomcatDeployer = tomcatDeployer;
   }
   
   // In our lifecycle, we invoke the webserver lifecycle-related operations
   // in the TomcatDeployer

   @Override
   protected void startService() throws Exception
   {
      if (tomcatDeployer == null)
         throw new IllegalStateException("Must set TomcatDeployer before starting");
      tomcatDeployer.startWebServer();
   }

   @Override
   protected void stopService() throws Exception
   {
      if (tomcatDeployer != null)
         tomcatDeployer.stopWebServer();
   }
   
   // Expose the TomcatDeployer MBean interface

   public String getConfigFile()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getConfigFile();
   }

   public String getContextMBeanCode()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getContextMBeanCode();
   }

   public String getDomain()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getDomain();
   }

   public String[] getFilteredPackages()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getFilteredPackages();
   }

   public String getManagerClass()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getManagerClass();
   }

   public String getSessionIdAlphabet()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getSessionIdAlphabet();
   }

   public String getSubjectAttributeName()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getSubjectAttributeName();
   }

   public boolean getUseJBossWebLoader()
   {
      return tomcatDeployer == null ? false : tomcatDeployer.getUseJBossWebLoader();
   }

   public boolean isAllowSelfPrivilegedWebApps()
   {
      return tomcatDeployer == null ? false : tomcatDeployer.isAllowSelfPrivilegedWebApps();
   }

   public void setAllowSelfPrivilegedWebApps(boolean flag)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setAllowSelfPrivilegedWebApps(flag);
   }

   public void setConfigFile(String configFile)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setConfigFile(configFile);
   }

   public void setContextMBeanCode(String className)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setContextMBeanCode(className);
   }

   public void setDomain(String domainName)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setDomain(domainName);
   }

   public void setFilteredPackages(String[] pkgs)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setFilteredPackages(pkgs);
   }

   public void setManagerClass(String managerClass)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setManagerClass(managerClass);
   }

   public void setSecurityManagerService(JaasSecurityManagerServiceMBean mgr)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setSecurityManagerService(mgr);
   }

   public void setSessionIdAlphabet(String sessionIdAlphabet)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setSessionIdAlphabet(sessionIdAlphabet);
   }

   public void setSubjectAttributeName(String name)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setSubjectAttributeName(name);
   }

   public void setUseJBossWebLoader(boolean flag)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setUseJBossWebLoader(flag);
   }

   public void startConnectors() throws Exception
   {
      if (tomcatDeployer != null)
         tomcatDeployer.startConnectors();
   }

   public void stopConnectors() throws Exception
   {
      if (tomcatDeployer != null)
         tomcatDeployer.stopConnectors();
   }

   public String getDefaultSecurityDomain()
   {
      return tomcatDeployer == null ? null : tomcatDeployer.getDefaultSecurityDomain();
   }

   public boolean getJava2ClassLoadingCompliance()
   {
      return tomcatDeployer == null ? false : tomcatDeployer.getJava2ClassLoadingCompliance();
   }

   public boolean getLenientEjbLink()
   {
      return tomcatDeployer == null ? false : tomcatDeployer.getLenientEjbLink();
   }

   public boolean getUnpackWars()
   {
      return tomcatDeployer == null ? false : tomcatDeployer.getUnpackWars();
   }

   public void setDefaultSecurityDomain(String defaultSecurityDomain)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setDefaultSecurityDomain(defaultSecurityDomain);
   }

   public void setJava2ClassLoadingCompliance(boolean flag)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setJava2ClassLoadingCompliance(flag);
   }

   public void setLenientEjbLink(boolean flag)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setLenientEjbLink(flag);
   }

   public void setUnpackWars(boolean flag)
   {
      if (tomcatDeployer != null)
         tomcatDeployer.setUnpackWars(flag);
   }

}
