/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.metamodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EnvironmentRefGroup;
import org.jboss.metamodel.descriptor.Listener;
import org.jboss.metamodel.descriptor.MessageDestination;
import org.jboss.web.metamodel.descriptor.ErrorPage;
import org.jboss.web.metamodel.descriptor.Filter;
import org.jboss.web.metamodel.descriptor.FilterMapping;
import org.jboss.web.metamodel.descriptor.LoginConfig;
import org.jboss.web.metamodel.descriptor.PassivationConfig;
import org.jboss.web.metamodel.descriptor.ReplicationConfig;
import org.jboss.web.metamodel.descriptor.SecurityConstraint;
import org.jboss.web.metamodel.descriptor.SecurityRole;
import org.jboss.web.metamodel.descriptor.Servlet;
import org.jboss.web.metamodel.descriptor.ServletMapping;
import org.jboss.web.metamodel.descriptor.SessionConfig;

public class WebDD
extends EnvironmentRefGroup {
    private static final Logger log = Logger.getLogger(WebDD.class);
    protected String securityDomain;
    protected HashMap filters = new HashMap();
    protected HashMap filterMappings = new HashMap();
    protected HashMap listeners = new HashMap();
    protected HashMap servlets = new HashMap();
    protected HashMap servletMappings = new HashMap();
    protected List sessionConfigs = new ArrayList();
    protected List securityConstraints = new ArrayList();
    protected HashMap securityRoles = new HashMap();
    protected LoginConfig loginConfig;
    protected HashMap errorPages = new HashMap();
    protected HashMap messageDestinations = new HashMap();
    protected List dependencies = new ArrayList();
    protected ReplicationConfig replicationConfig;
    protected PassivationConfig passivationConfig;

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public Collection getFilters() {
        return this.filters.values();
    }

    public void addFilter(Filter filter) {
        this.filters.put(filter.getName(), filter);
    }

    public Collection getFilterMappings() {
        return this.filterMappings.values();
    }

    public void addFilterMapping(FilterMapping mapping) {
        this.filterMappings.put(mapping.getFilterName(), mapping);
    }

    public Collection getListeners() {
        return this.listeners.values();
    }

    public void addListener(Listener listener) {
        this.listeners.put(listener.getListenerClass(), listener);
    }

    public Collection getServlets() {
        return this.servlets.values();
    }

    public void addServlet(Servlet servlet) {
        this.servlets.put(servlet.getName(), servlet);
    }

    public void updateServlet(Servlet updatedServlet) {
        Servlet servlet = (Servlet)this.servlets.get(updatedServlet.getName());
        if (servlet != null) {
            servlet.setRunAsPrincipals(updatedServlet.getRunAsPrincipals());
        } else {
            this.servlets.put(updatedServlet.getName(), updatedServlet);
        }
    }

    public Collection getServletMappings() {
        return this.servletMappings.values();
    }

    public void addServletMapping(ServletMapping mapping) {
        this.servletMappings.put(mapping.getName(), mapping);
    }

    public Collection getSessionConfigs() {
        return this.sessionConfigs;
    }

    public void addSessionConfig(SessionConfig config) {
        this.sessionConfigs.add(config);
    }

    public Collection getSecurityRoles() {
        return this.securityRoles.values();
    }

    public void addSecurityRole(SecurityRole securityRole) {
        this.securityRoles.put(securityRole.getRoleName(), securityRole);
    }

    public void updateSecurityRole(SecurityRole updatedRole) {
        SecurityRole role = (SecurityRole)((Object)this.securityRoles.get(updatedRole.getRoleName()));
        if (role != null) {
            role.setPrincipalName(updatedRole.getPrincipalName());
        } else {
            this.securityRoles.put(updatedRole.getRoleName(), updatedRole);
        }
    }

    public Collection getSecurityConstraints() {
        return this.securityConstraints;
    }

    public void addSecurityConstraint(SecurityConstraint constraint) {
        this.securityConstraints.add(constraint);
    }

    public LoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(LoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public Collection getErrorPages() {
        return this.errorPages.values();
    }

    public void addErrorPage(ErrorPage errorPage) {
        this.errorPages.put(errorPage.getErrorCode(), errorPage);
    }

    public Collection getMessageDestinations() {
        return this.messageDestinations.values();
    }

    public void addMessageDestination(MessageDestination destination) {
        log.debug((Object)("addMessageDestination, " + destination));
        this.messageDestinations.put(destination.getMessageDestinationName(), destination);
    }

    public void updateMessageDestination(MessageDestination updatedDestination) {
        MessageDestination destination = (MessageDestination)this.messageDestinations.get(updatedDestination.getMessageDestinationName());
        if (destination != null) {
            destination.setMappedName(updatedDestination.getMappedName());
        } else {
            this.messageDestinations.put(updatedDestination.getMessageDestinationName(), updatedDestination);
        }
    }

    public void addDependency(String depends) {
        this.dependencies.add(depends);
    }

    public Collection getDependencies() {
        return this.dependencies;
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public void setReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
    }

    public PassivationConfig getPassivationConfig() {
        return this.passivationConfig;
    }

    public void setPassivationConfig(PassivationConfig passivationConfig) {
        this.passivationConfig = passivationConfig;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append('[');
        sb.append(']');
        return sb.toString();
    }
}

