/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

public class WebUtil {
    public static String deriveUsefulInfo(HttpServletRequest httpRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(httpRequest.getContextPath());
        sb.append(":cookies=").append(httpRequest.getCookies()).append(":headers=");
        Enumeration en = httpRequest.getHeaderNames();
        while (en.hasMoreElements()) {
            String headerName = (String)en.nextElement();
            sb.append(headerName).append("=");
            sb.append(httpRequest.getHeader(headerName)).append(",");
        }
        sb.append("]");
        sb.append("[parameters=");
        Enumeration enparam = httpRequest.getParameterNames();
        while (enparam.hasMoreElements()) {
            String paramName = (String)enparam.nextElement();
            String[] paramValues = httpRequest.getParameterValues(paramName);
            int len = paramValues != null ? paramValues.length : 0;
            for (int i = 0; i < len; ++i) {
                sb.append(paramValues[i]).append("::");
            }
            sb.append(",");
        }
        sb.append("][attributes=");
        Enumeration enu = httpRequest.getAttributeNames();
        while (enu.hasMoreElements()) {
            String attrName = (String)enu.nextElement();
            sb.append(attrName).append("=");
            sb.append(httpRequest.getAttribute(attrName)).append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

