/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.ContextConfig;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AuthConstraintMetaData;
import org.jboss.metadata.web.spec.DispatcherType;
import org.jboss.metadata.web.spec.ErrorPageMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.JspConfigMetaData;
import org.jboss.metadata.web.spec.JspPropertyGroup;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingMetaData;
import org.jboss.metadata.web.spec.LocaleEncodingsMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.SessionConfigMetaData;
import org.jboss.metadata.web.spec.TaglibMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.metadata.web.spec.WelcomeFileListMetaData;

public class JBossContextConfig
extends ContextConfig {
    public static ThreadLocal<JBossWebMetaData> metaDataLocal = new ThreadLocal();
    public static ThreadLocal<JBossWebMetaData> metaDataShared = new ThreadLocal();

    protected void applicationWebConfig() {
        this.processWebMetaData(metaDataLocal.get());
    }

    protected void defaultWebConfig() {
        this.processWebMetaData(metaDataShared.get());
    }

    protected void processWebMetaData(JBossWebMetaData metaData) {
        SessionConfigMetaData scmd;
        WelcomeFileListMetaData welcomeFiles;
        LocaleEncodingsMetaData locales;
        JspConfigMetaData config;
        List smappings;
        JBossServletsMetaData servlets;
        SecurityRolesMetaData roles;
        List scs;
        List mimes;
        LoginConfigMetaData loginConfig;
        List listeners;
        List filtersMappings;
        FiltersMetaData filters;
        List errorPages;
        String displayName;
        DescriptionGroupMetaData dg;
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setReplaceWelcomeFiles(true);
        }
        this.context.setIgnoreAnnotations(metaData.isMetadataComplete());
        if (metaData.is25()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_5.dtd");
        } else if (metaData.is24()) {
            this.context.setPublicId("/javax/servlet/resources/web-app_2_4.dtd");
        } else if (metaData.is23()) {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
        } else {
            this.context.setPublicId("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN");
        }
        List params = metaData.getContextParams();
        if (params != null) {
            for (ParamValueMetaData param : params) {
                this.context.addParameter(param.getParamName(), param.getParamValue());
            }
        }
        if ((dg = metaData.getDescriptionGroup()) != null && (displayName = dg.getDisplayName()) != null) {
            this.context.setDisplayName(displayName);
        }
        if (metaData.getDistributable() != null) {
            this.context.setDistributable(true);
        }
        if ((errorPages = metaData.getErrorPages()) != null) {
            for (ErrorPageMetaData value : errorPages) {
                ErrorPage errorPage = new ErrorPage();
                errorPage.setErrorCode(value.getErrorCode());
                errorPage.setExceptionType(value.getExceptionType());
                errorPage.setLocation(value.getLocation());
                this.context.addErrorPage(errorPage);
            }
        }
        if ((filters = metaData.getFilters()) != null) {
            for (FilterMetaData value : filters) {
                FilterDef filterDef = new FilterDef();
                filterDef.setFilterName(value.getName());
                filterDef.setFilterClass(value.getFilterClass());
                if (value.getInitParam() != null) {
                    for (ParamValueMetaData param : value.getInitParam()) {
                        filterDef.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                this.context.addFilterDef(filterDef);
            }
        }
        if ((filtersMappings = metaData.getFilterMappings()) != null) {
            for (FilterMappingMetaData value : filtersMappings) {
                List dispatchers;
                List urlPatterns;
                FilterMap filterMap = new FilterMap();
                filterMap.setFilterName(value.getFilterName());
                List servletNames = value.getServletNames();
                if (servletNames != null) {
                    for (String name : servletNames) {
                        filterMap.addServletName(name);
                    }
                }
                if ((urlPatterns = value.getUrlPatterns()) != null) {
                    for (String pattern : urlPatterns) {
                        filterMap.addURLPattern(pattern);
                    }
                }
                if ((dispatchers = value.getDispatchers()) != null) {
                    for (DispatcherType type : dispatchers) {
                        filterMap.setDispatcher(type.name());
                    }
                }
                this.context.addFilterMap(filterMap);
            }
        }
        if ((listeners = metaData.getListeners()) != null) {
            for (ListenerMetaData value : listeners) {
                this.context.addApplicationListener(value.getListenerClass());
            }
        }
        if ((loginConfig = metaData.getLoginConfig()) != null) {
            LoginConfig loginConfig2 = new LoginConfig();
            loginConfig2.setAuthMethod(loginConfig.getAuthMethod());
            loginConfig2.setRealmName(loginConfig.getRealmName());
            if (loginConfig.getFormLoginConfig() != null) {
                loginConfig2.setLoginPage(loginConfig.getFormLoginConfig().getLoginPage());
                loginConfig2.setErrorPage(loginConfig.getFormLoginConfig().getErrorPage());
            }
            this.context.setLoginConfig(loginConfig2);
        }
        if ((mimes = metaData.getMimeMappings()) != null) {
            for (MimeMappingMetaData value : mimes) {
                this.context.addMimeMapping(value.getExtension(), value.getMimeType());
            }
        }
        if ((scs = metaData.getSecurityContraints()) != null) {
            for (SecurityConstraintMetaData value : scs) {
                WebResourceCollectionsMetaData wrcs;
                SecurityConstraint constraint = new SecurityConstraint();
                TransportGuaranteeType tg = value.getTransportGuarantee();
                constraint.setUserConstraint(tg.name());
                AuthConstraintMetaData acmd = value.getAuthConstraint();
                constraint.setAuthConstraint(acmd != null);
                if (acmd != null && acmd.getRoleNames() != null) {
                    for (String role : acmd.getRoleNames()) {
                        constraint.addAuthRole(role);
                    }
                }
                if ((wrcs = value.getResourceCollections()) != null) {
                    for (WebResourceCollectionMetaData wrc : wrcs) {
                        List patterns;
                        SecurityCollection collection2 = new SecurityCollection();
                        collection2.setName(wrc.getName());
                        List methods = wrc.getHttpMethods();
                        if (methods != null) {
                            for (String method : wrc.getHttpMethods()) {
                                collection2.addMethod(method);
                            }
                        }
                        if ((patterns = wrc.getUrlPatterns()) != null) {
                            for (String pattern : patterns) {
                                collection2.addPattern(pattern);
                            }
                        }
                        constraint.addCollection(collection2);
                    }
                }
                this.context.addConstraint(constraint);
            }
        }
        if ((roles = metaData.getSecurityRoles()) != null) {
            for (SecurityRoleMetaData value : roles) {
                this.context.addSecurityRole(value.getRoleName());
            }
        }
        if ((servlets = metaData.getServlets()) != null) {
            for (JBossServletMetaData value : servlets) {
                SecurityRoleRefsMetaData refs;
                Wrapper wrapper = this.context.createWrapper();
                wrapper.setName(value.getName());
                wrapper.setServletClass(value.getServletClass());
                if (value.getJspFile() != null) {
                    wrapper.setJspFile(value.getJspFile());
                }
                wrapper.setLoadOnStartup(value.getLoadOnStartup());
                if (value.getRunAs() != null) {
                    wrapper.setRunAs(value.getRunAs().getRoleName());
                }
                if ((params = value.getInitParam()) != null) {
                    for (ParamValueMetaData param : params) {
                        wrapper.addInitParameter(param.getParamName(), param.getParamValue());
                    }
                }
                if ((refs = value.getSecurityRoleRefs()) != null) {
                    for (SecurityRoleRefMetaData ref : refs) {
                        wrapper.addSecurityReference(ref.getRoleName(), ref.getRoleLink());
                    }
                }
                this.context.addChild((Container)wrapper);
            }
        }
        if ((smappings = metaData.getServletMappings()) != null) {
            for (ServletMappingMetaData value : smappings) {
                List urlPatterns = value.getUrlPatterns();
                if (urlPatterns == null) continue;
                for (String pattern : urlPatterns) {
                    this.context.addServletMapping(pattern, value.getServletName());
                }
            }
        }
        if ((config = metaData.getJspConfig()) != null) {
            List taglibs;
            List groups = config.getPropertyGroups();
            if (groups != null) {
                for (JspPropertyGroup group : groups) {
                    for (String pattern : group.getUrlPatterns()) {
                        this.context.addJspMapping(pattern);
                    }
                }
            }
            if ((taglibs = config.getTaglibs()) != null) {
                for (TaglibMetaData taglib : taglibs) {
                    this.context.addTaglib(taglib.getTaglibUri(), taglib.getTaglibLocation());
                }
            }
        }
        if ((locales = metaData.getLocalEncodings()) != null) {
            for (LocaleEncodingMetaData value : locales.getMappings()) {
                this.context.addLocaleEncodingMappingParameter(value.getLocale(), value.getEncoding());
            }
        }
        if ((welcomeFiles = metaData.getWelcomeFileList()) != null) {
            for (String value : welcomeFiles.getWelcomeFiles()) {
                this.context.addWelcomeFile(value);
            }
        }
        if ((scmd = metaData.getSessionConfig()) != null) {
            this.context.setSessionTimeout(scmd.getSessionTimeout());
        }
    }
}

