/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.deployers.plugins.classloading.AbstractClassLoaderSystemDeployer;
import org.jboss.deployers.plugins.classloading.Module;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.plugins.classloader.VFSClassLoaderPolicy;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarClassLoaderDeployer
extends AbstractClassLoaderSystemDeployer {
    private boolean java2ClassLoadingCompliance = false;
    private boolean includeWebInfInClasspath;
    private Set<String> filteredPackages;

    public WarClassLoaderDeployer() {
        this.setInput(JBossWebMetaData.class);
    }

    public boolean isJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public Set<String> getFilteredPackages() {
        return this.filteredPackages;
    }

    public void setFilteredPackages(Set<String> pkgs) {
        this.filteredPackages = pkgs;
    }

    public boolean isIncludeWebInfInClasspath() {
        return this.includeWebInfInClasspath;
    }

    public void setIncludeWebInfInClasspath(boolean includeWebInfInClasspath) {
        this.includeWebInfInClasspath = includeWebInfInClasspath;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (unit.isAttachmentPresent(JBossWebMetaData.class)) {
            super.deploy(unit);
        }
    }

    public void undeploy(DeploymentUnit unit) {
        if (unit.isAttachmentPresent(JBossWebMetaData.class)) {
            super.undeploy(unit);
        }
    }

    protected ClassLoaderPolicy createClassLoaderPolicy(DeploymentContext context, Module module) throws Exception {
        VFSClassLoaderPolicy policy = null;
        try {
            if (context instanceof VFSDeploymentContext) {
                VFSDeploymentContext vfscontext = (VFSDeploymentContext)context;
                ArrayList<VirtualFile> paths = new ArrayList<VirtualFile>();
                if (vfscontext.getClassPath() != null) {
                    paths.addAll(vfscontext.getClassPath());
                }
                LinkedHashSet<VirtualFile> cpSet = new LinkedHashSet<VirtualFile>();
                VirtualFile war = vfscontext.getRoot();
                VirtualFile webInf = vfscontext.getFile("WEB-INF");
                if (this.includeWebInfInClasspath && webInf != null) {
                    cpSet.add(webInf);
                }
                WarClassLoaderDeployer.addManifestLocations(war, paths, this.log);
                if (paths != null) {
                    cpSet.addAll(paths);
                }
                VirtualFile[] warFiles = new VirtualFile[cpSet.size()];
                cpSet.toArray(warFiles);
                policy = new VFSClassLoaderPolicy(module.getName(), warFiles);
                policy.setExportAll(module.getExportAll());
                policy.setImportAll(module.isImportAll());
                policy.setExcludedPackages(this.filteredPackages);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to create war ClassLoaderPolicy", (Throwable)e);
        }
        return policy;
    }

    public void removeClassLoader(DeploymentContext context) throws Exception {
    }

    public static void addManifestLocations(VirtualFile file, List<VirtualFile> paths, Logger log) throws Exception {
        Manifest manifest = VFSUtils.getManifest((VirtualFile)file);
        if (manifest != null) {
            VirtualFile parent = file.getParent();
            URL parentURL = parent != null ? parent.toURL() : file.toURL();
            Attributes mainAttributes = manifest.getMainAttributes();
            String classPath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
            if (classPath == null) {
                return;
            }
            StringTokenizer tokenizer = new StringTokenizer(classPath);
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                try {
                    VirtualFile pathvf;
                    String parentPath = parentURL.toString();
                    if (!parentPath.endsWith("/")) {
                        parentPath = parentPath + "/";
                    }
                    if ((pathvf = parent.getChild(path)) == null) continue;
                    paths.add(pathvf);
                    WarClassLoaderDeployer.addManifestLocations(pathvf, paths, log);
                }
                catch (Exception e) {
                    log.debug((Object)("Manifest Class-Path entry " + path + " ignored for " + file.getPathName() + " reason=" + e));
                }
            }
        }
    }
}

