/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.jasper;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;
import org.jboss.logging.Logger;
import org.jboss.web.jsf.integration.config.JBossJSFConfigureListener;
import org.jboss.web.tomcat.service.jasper.TagLibCache;

public class JspServletOptions
implements Options {
    static Logger log = Logger.getLogger(JspServletOptions.class);
    private Properties settings = new Properties();
    private boolean development = true;
    private boolean displaySourceFragment = true;
    public boolean fork = true;
    private boolean keepGenerated = true;
    private boolean trimSpaces = false;
    private boolean isPoolingEnabled = true;
    private boolean mappedFile = true;
    private boolean sendErrorToClient = false;
    private boolean classDebugInfo = true;
    private int checkInterval = 0;
    private boolean isSmapSuppressed = false;
    private boolean isSmapDumped = false;
    private boolean genStringAsCharArray = false;
    private boolean errorOnUseBeanInvalidClassAttribute = true;
    private File scratchDir;
    private String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private String classpath = null;
    private String compiler = null;
    private String compilerClassName = null;
    private String compilerTargetVM = "1.4";
    private String compilerSourceVM = "1.4";
    private TldLocationsCache tldLocationsCache = null;
    private JspConfig jspConfig = null;
    private TagPluginManager tagPluginManager = null;
    private String javaEncoding = "UTF8";
    private int modificationTestInterval = 4;
    private boolean ignoreAnnotations;
    private boolean xpoweredBy;

    public boolean getIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public String getProperty(String name) {
        return this.settings.getProperty(name);
    }

    public void setProperty(String name, String value) {
        if (name != null && value != null) {
            this.settings.setProperty(name, value);
        }
    }

    public boolean getKeepGenerated() {
        return this.keepGenerated;
    }

    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public boolean isPoolingEnabled() {
        return this.isPoolingEnabled;
    }

    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public boolean getSendErrorToClient() {
        return this.sendErrorToClient;
    }

    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public int getModificationTestInterval() {
        return this.modificationTestInterval;
    }

    public boolean getDevelopment() {
        return this.development;
    }

    public boolean getDisplaySourceFragment() {
        return this.displaySourceFragment;
    }

    public boolean isSmapSuppressed() {
        return this.isSmapSuppressed;
    }

    public boolean isSmapDumped() {
        return this.isSmapDumped;
    }

    public boolean genStringAsCharArray() {
        return this.genStringAsCharArray;
    }

    public String getIeClassId() {
        return this.ieClassId;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public String getCompilerClassName() {
        return this.compilerClassName;
    }

    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return this.errorOnUseBeanInvalidClassAttribute;
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean b) {
        this.errorOnUseBeanInvalidClassAttribute = b;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public void setTldLocationsCache(TldLocationsCache tldC) {
        this.tldLocationsCache = tldC;
    }

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public boolean getFork() {
        return this.fork;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public boolean isCaching() {
        return false;
    }

    public Map getCache() {
        return null;
    }

    public JspServletOptions(ServletConfig config, ServletContext context) {
        String xpoweredBy;
        String fork;
        String compilerClassName;
        String javaEncoding;
        String compilerSourceVM;
        String dir;
        String classpath;
        String ieClassId;
        String errBeanClass;
        String genCharArray;
        String dumpSmap;
        String suppressSmap;
        String displaySourceFragment;
        String development;
        String modificationTestInterval;
        String checkInterval;
        String debugInfo;
        String senderr;
        String mapFile;
        String trimsp;
        String keepgen;
        Enumeration enumeration = config.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String k = (String)enumeration.nextElement();
            String v = config.getInitParameter(k);
            this.setProperty(k, v);
        }
        String validating = config.getInitParameter("validating");
        if ("false".equals(validating)) {
            ParserUtils.validating = false;
        }
        if ((keepgen = config.getInitParameter("keepgenerated")) != null) {
            if (keepgen.equalsIgnoreCase("true")) {
                this.keepGenerated = true;
            } else if (keepgen.equalsIgnoreCase("false")) {
                this.keepGenerated = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.keepgen"));
            }
        }
        if ((trimsp = config.getInitParameter("trimSpaces")) != null) {
            if (trimsp.equalsIgnoreCase("true")) {
                this.trimSpaces = true;
            } else if (trimsp.equalsIgnoreCase("false")) {
                this.trimSpaces = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.trimspaces"));
            }
        }
        this.isPoolingEnabled = true;
        String poolingEnabledParam = config.getInitParameter("enablePooling");
        if (poolingEnabledParam != null && !poolingEnabledParam.equalsIgnoreCase("true")) {
            if (poolingEnabledParam.equalsIgnoreCase("false")) {
                this.isPoolingEnabled = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.enablePooling"));
            }
        }
        if ((mapFile = config.getInitParameter("mappedfile")) != null) {
            if (mapFile.equalsIgnoreCase("true")) {
                this.mappedFile = true;
            } else if (mapFile.equalsIgnoreCase("false")) {
                this.mappedFile = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.mappedFile"));
            }
        }
        if ((senderr = config.getInitParameter("sendErrToClient")) != null) {
            if (senderr.equalsIgnoreCase("true")) {
                this.sendErrorToClient = true;
            } else if (senderr.equalsIgnoreCase("false")) {
                this.sendErrorToClient = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.sendErrToClient"));
            }
        }
        if ((debugInfo = config.getInitParameter("classdebuginfo")) != null) {
            if (debugInfo.equalsIgnoreCase("true")) {
                this.classDebugInfo = true;
            } else if (debugInfo.equalsIgnoreCase("false")) {
                this.classDebugInfo = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.classDebugInfo"));
            }
        }
        if ((checkInterval = config.getInitParameter("checkInterval")) != null) {
            try {
                this.checkInterval = Integer.parseInt(checkInterval);
                if (this.checkInterval == 0) {
                    this.checkInterval = 300;
                    log.warn((Object)Localizer.getMessage((String)"jsp.warning.checkInterval"));
                }
            }
            catch (NumberFormatException ex) {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.checkInterval"));
            }
        }
        if ((modificationTestInterval = config.getInitParameter("modificationTestInterval")) != null) {
            try {
                this.modificationTestInterval = Integer.parseInt(modificationTestInterval);
            }
            catch (NumberFormatException ex) {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.modificationTestInterval"));
            }
        }
        if ((development = config.getInitParameter("development")) != null) {
            if (development.equalsIgnoreCase("true")) {
                this.development = true;
            } else if (development.equalsIgnoreCase("false")) {
                this.development = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.development"));
            }
        }
        if ((displaySourceFragment = config.getInitParameter("displaySourceFragment")) != null) {
            if (displaySourceFragment.equalsIgnoreCase("true")) {
                this.displaySourceFragment = true;
            } else if (displaySourceFragment.equalsIgnoreCase("false")) {
                this.displaySourceFragment = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.displaySourceFragment"));
            }
        }
        if ((suppressSmap = config.getInitParameter("suppressSmap")) != null) {
            if (suppressSmap.equalsIgnoreCase("true")) {
                this.isSmapSuppressed = true;
            } else if (suppressSmap.equalsIgnoreCase("false")) {
                this.isSmapSuppressed = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.suppressSmap"));
            }
        }
        if ((dumpSmap = config.getInitParameter("dumpSmap")) != null) {
            if (dumpSmap.equalsIgnoreCase("true")) {
                this.isSmapDumped = true;
            } else if (dumpSmap.equalsIgnoreCase("false")) {
                this.isSmapDumped = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.dumpSmap"));
            }
        }
        if ((genCharArray = config.getInitParameter("genStrAsCharArray")) != null) {
            if (genCharArray.equalsIgnoreCase("true")) {
                this.genStringAsCharArray = true;
            } else if (genCharArray.equalsIgnoreCase("false")) {
                this.genStringAsCharArray = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.genchararray"));
            }
        }
        if ((errBeanClass = config.getInitParameter("errorOnUseBeanInvalidClassAttribute")) != null) {
            if (errBeanClass.equalsIgnoreCase("true")) {
                this.errorOnUseBeanInvalidClassAttribute = true;
            } else if (errBeanClass.equalsIgnoreCase("false")) {
                this.errorOnUseBeanInvalidClassAttribute = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.errBean"));
            }
        }
        if ((ieClassId = config.getInitParameter("ieClassId")) != null) {
            this.ieClassId = ieClassId;
        }
        if ((classpath = config.getInitParameter("classpath")) != null) {
            this.classpath = classpath;
        }
        if ((dir = config.getInitParameter("scratchdir")) != null) {
            this.scratchDir = new File(dir);
        } else {
            this.scratchDir = (File)context.getAttribute("javax.servlet.context.tempdir");
            if (this.scratchDir == null && (dir = System.getProperty("java.io.tmpdir")) != null) {
                this.scratchDir = new File(dir);
            }
        }
        if (this.scratchDir == null) {
            log.fatal((Object)Localizer.getMessage((String)"jsp.error.no.scratch.dir"));
            return;
        }
        if (!(this.scratchDir.exists() && this.scratchDir.canRead() && this.scratchDir.canWrite() && this.scratchDir.isDirectory())) {
            log.fatal((Object)Localizer.getMessage((String)"jsp.error.bad.scratch.dir", (String)this.scratchDir.getAbsolutePath()));
        }
        this.compiler = config.getInitParameter("compiler");
        String compilerTargetVM = config.getInitParameter("compilerTargetVM");
        if (compilerTargetVM != null) {
            this.compilerTargetVM = compilerTargetVM;
        }
        if ((compilerSourceVM = config.getInitParameter("compilerSourceVM")) != null) {
            this.compilerSourceVM = compilerSourceVM;
        }
        if ((javaEncoding = config.getInitParameter("javaEncoding")) != null) {
            this.javaEncoding = javaEncoding;
        }
        if ((compilerClassName = config.getInitParameter("compilerClassName")) != null) {
            this.compilerClassName = compilerClassName;
        }
        if ((fork = config.getInitParameter("fork")) != null) {
            if (fork.equalsIgnoreCase("true")) {
                this.fork = true;
            } else if (fork.equalsIgnoreCase("false")) {
                this.fork = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.fork"));
            }
        }
        if ((xpoweredBy = config.getInitParameter("xpoweredBy")) != null) {
            if (xpoweredBy.equalsIgnoreCase("true")) {
                this.xpoweredBy = true;
            } else if (xpoweredBy.equalsIgnoreCase("false")) {
                this.xpoweredBy = false;
            } else {
                log.warn((Object)Localizer.getMessage((String)"jsp.warning.xpoweredBy"));
            }
        }
        String base = "tagLibJar";
        ArrayList<String> tldJars = new ArrayList<String>();
        int count = 0;
        String jarPath = null;
        do {
            String name;
            if ((jarPath = config.getInitParameter(name = base + count)) != null && this.okToAddTagsFromJSFLibs(jarPath, context)) {
                tldJars.add(jarPath);
            }
            ++count;
        } while (jarPath != null);
        this.tldLocationsCache = new TagLibCache(context, tldJars);
        this.jspConfig = new JspConfig(context);
        this.tagPluginManager = new TagPluginManager(context);
    }

    private boolean okToAddTagsFromJSFLibs(String jarPath, ServletContext context) {
        if (!jarPath.startsWith("jsf-libs")) {
            return true;
        }
        return !JBossJSFConfigureListener.warBundlesJSFImpl(context);
    }
}

